/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;

public class DrivePointsCommand
extends BaseCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"dp").requires(source -> source.hasPermission(2));
        builder.then(Commands.literal((String)"set").then(((RequiredArgumentBuilder)Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(DrivePointsCommand::setValue))).executes(DrivePointsCommand::setValue)));
        builder.then(Commands.literal((String)"give").then(((RequiredArgumentBuilder)Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(DrivePointsCommand::addValue))).executes(DrivePointsCommand::addValue)));
        builder.then(Commands.literal((String)"take").then(((RequiredArgumentBuilder)Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(DrivePointsCommand::removeValue))).executes(DrivePointsCommand::removeValue)));
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    private static int setValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = DrivePointsCommand.getPlayers(context, 4);
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        for (ServerPlayer player : players) {
            DrivePointsCommand.setValue(context, value, player);
        }
        return 1;
    }

    private static int setValue(CommandContext<CommandSourceStack> context, int value, ServerPlayer player) throws CommandSyntaxException {
        PlayerData playerData = PlayerData.get((Player)player);
        playerData.setDP(value);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Set " + player.getDisplayName().getString() + " dp to " + value)), true);
        player.sendSystemMessage((Component)Component.translatable((String)("Your dp has been set to " + value)));
        PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
        return 1;
    }

    private static int addValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = DrivePointsCommand.getPlayers(context, 4);
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        for (ServerPlayer player : players) {
            DrivePointsCommand.addValue(context, value, player);
        }
        return 1;
    }

    private static int addValue(CommandContext<CommandSourceStack> context, int value, ServerPlayer player) throws CommandSyntaxException {
        PlayerData playerData = PlayerData.get((Player)player);
        playerData.addDP(value);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Added " + value + " dp to " + player.getDisplayName().getString())), true);
        player.sendSystemMessage((Component)Component.translatable((String)("Your dp has been increased by " + value)));
        PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
        return 1;
    }

    private static int removeValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = DrivePointsCommand.getPlayers(context, 4);
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        for (ServerPlayer player : players) {
            DrivePointsCommand.removeValue(context, value, player);
        }
        return 1;
    }

    private static int removeValue(CommandContext<CommandSourceStack> context, int value, ServerPlayer player) throws CommandSyntaxException {
        PlayerData playerData = PlayerData.get((Player)player);
        playerData.remDP(value);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Taken " + value + " dp from " + player.getDisplayName().getString())), true);
        player.sendSystemMessage((Component)Component.translatable((String)("Your dp has been decreased by " + value)));
        PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
        return 1;
    }
}

