/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class ExpCommand
extends BaseCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"exp").requires(source -> source.hasPermission(2));
        builder.then(Commands.literal((String)"set").then(((RequiredArgumentBuilder)Commands.argument((String)"exp", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ExpCommand::setValue))).executes(ExpCommand::setValue)));
        builder.then(Commands.literal((String)"give").then(((RequiredArgumentBuilder)Commands.argument((String)"exp", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ExpCommand::addValue))).executes(ExpCommand::addValue)));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"fix").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ExpCommand::fixValue))).executes(ExpCommand::fixValue));
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    private static int setValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = ExpCommand.getPlayers(context, 4);
        int exp = IntegerArgumentType.getInteger(context, (String)"exp");
        for (ServerPlayer player : players) {
            PlayerData playerData = PlayerData.get((Player)player);
            Utils.restartLevel(playerData, (Player)player);
            if (playerData.getSoAState() == SoAState.COMPLETE) {
                playerData.addExperience((Player)player, exp, false, false);
                player.level().playSound(null, player.blockPosition(), (SoundEvent)ModSounds.levelup.get(), SoundSource.MASTER, 1.0f, 1.0f);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)(player.getDisplayName().getString() + " has to make a choice first")), true);
            }
            Utils.restartLevel2(playerData, (Player)player);
            PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Set " + player.getDisplayName().getString() + " experience to " + exp)), true);
            player.sendSystemMessage((Component)Component.translatable((String)("Your experience is now " + exp)));
        }
        return 1;
    }

    private static int addValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = ExpCommand.getPlayers(context, 4);
        int value = IntegerArgumentType.getInteger(context, (String)"exp");
        for (ServerPlayer player : players) {
            PlayerData playerData = PlayerData.get((Player)player);
            playerData.addExperience((Player)player, value, false, false);
            player.level().playSound(null, player.blockPosition(), (SoundEvent)ModSounds.levelup.get(), SoundSource.MASTER, 1.0f, 1.0f);
            PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Added " + value + " experience to " + player.getDisplayName().getString())), true);
            player.sendSystemMessage((Component)Component.translatable((String)("Your experience has been increased by " + value)));
        }
        return 1;
    }

    private static int fixValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = ExpCommand.getPlayers(context, 3);
        for (ServerPlayer player : players) {
            PlayerData playerData = PlayerData.get((Player)player);
            int exp = playerData.getExperience();
            ExpCommand.fix(playerData, (Player)player);
            player.level().playSound(null, player.blockPosition(), (SoundEvent)ModSounds.levelup.get(), SoundSource.MASTER, 1.0f, 1.0f);
            PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Set " + player.getDisplayName().getString() + " experience to " + exp)), true);
            player.sendSystemMessage((Component)Component.translatable((String)("Your experience is now " + exp + ", all your missing abilities have been added to you")));
        }
        return 1;
    }

    public static void fix(PlayerData playerData, Player player) {
        int exp = playerData.getExperience();
        Utils.restartLevel(playerData, player);
        if (playerData.getSoAState() == SoAState.COMPLETE) {
            playerData.addExperience(player, exp, false, false);
        }
        Utils.restartLevel2(playerData, player);
        PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
    }
}

