/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.data.PlayerData;

public class HeartsCommand
extends BaseCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"hearts").requires(source -> source.hasPermission(2));
        builder.then(Commands.literal((String)"set").then(((RequiredArgumentBuilder)Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(HeartsCommand::setValue))).executes(HeartsCommand::setValue)));
        builder.then(Commands.literal((String)"give").then(((RequiredArgumentBuilder)Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(HeartsCommand::addValue))).executes(HeartsCommand::addValue)));
        builder.then(Commands.literal((String)"take").then(((RequiredArgumentBuilder)Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(HeartsCommand::removeValue))).executes(HeartsCommand::removeValue)));
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    private static int setValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = HeartsCommand.getPlayers(context, 3);
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        for (ServerPlayer player : players) {
            HeartsCommand.setValue(context, value, player);
        }
        return 1;
    }

    private static int setValue(CommandContext<CommandSourceStack> context, int value, ServerPlayer player) throws CommandSyntaxException {
        PlayerData playerData = PlayerData.get((Player)player);
        playerData.setHearts(value);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Set " + player.getDisplayName().getString() + " hearts to " + value)), true);
        player.sendSystemMessage((Component)Component.translatable((String)("Your hearts have been set to " + value)));
        return 1;
    }

    private static int addValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = HeartsCommand.getPlayers(context, 4);
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        for (ServerPlayer player : players) {
            HeartsCommand.addValue(context, value, player);
        }
        return 1;
    }

    private static int addValue(CommandContext<CommandSourceStack> context, int value, ServerPlayer player) throws CommandSyntaxException {
        PlayerData playerData = PlayerData.get((Player)player);
        playerData.addHearts(value);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Added " + value + " hearts to " + player.getDisplayName().getString())), true);
        player.sendSystemMessage((Component)Component.translatable((String)("Your hearts have been increased by " + value)));
        return 1;
    }

    private static int removeValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = HeartsCommand.getPlayers(context, 4);
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        for (ServerPlayer player : players) {
            HeartsCommand.removeValue(context, value, player);
        }
        return 1;
    }

    private static int removeValue(CommandContext<CommandSourceStack> context, int value, ServerPlayer player) throws CommandSyntaxException {
        PlayerData playerData = PlayerData.get((Player)player);
        playerData.removeHearts(value);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Taken " + value + " hearts from " + player.getDisplayName().getString())), true);
        player.sendSystemMessage((Component)Component.translatable((String)("Your hearts have been decreased by " + value)));
        return 1;
    }
}

