/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class LevelCommand
extends BaseCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"level").requires(source -> source.hasPermission(2));
        builder.then(Commands.literal((String)"set").then(((RequiredArgumentBuilder)Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(LevelCommand::setValue))).executes(LevelCommand::setValue)));
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    private static int setValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = LevelCommand.getPlayers(context, 4);
        int level = IntegerArgumentType.getInteger(context, (String)"level");
        for (ServerPlayer player : players) {
            PlayerData playerData = PlayerData.get((Player)player);
            Utils.restartLevel(playerData, (Player)player);
            if (playerData.getSoAState() == SoAState.COMPLETE) {
                while (playerData.getLevel() < level) {
                    playerData.addExperience((Player)player, playerData.getExpNeeded(level - 1, playerData.getExperience()), false, false);
                }
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Set " + player.getDisplayName().getString() + " level to " + level)), true);
                player.sendSystemMessage((Component)Component.translatable((String)("Your level is now " + level)));
                player.level().playSound(null, player.blockPosition(), (SoundEvent)ModSounds.levelup.get(), SoundSource.MASTER, 1.0f, 1.0f);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)(player.getDisplayName().getString() + " has to make a choice first")), true);
            }
            Utils.restartLevel2(playerData, (Player)player);
            PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
        }
        return 1;
    }
}

