/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.lib.Tags;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MaterialCommand
extends BaseCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_MATERIALS = (context, builder) -> {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry itemEntry : BuiltInRegistries.ITEM.entrySet()) {
            if (!new ItemStack((ItemLike)itemEntry.getValue()).is(Tags.MATERIALS)) continue;
            list.add(((ResourceKey)itemEntry.getKey()).location().toString());
        }
        return SharedSuggestionProvider.suggest(list.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)builder);
    };

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"material").requires(source -> source.hasPermission(2));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"give").then(Commands.argument((String)"material", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_MATERIALS).then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(MaterialCommand::addMaterial))).executes(MaterialCommand::addMaterial)))).then(Commands.literal((String)"all").then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(MaterialCommand::addAllMaterials))).executes(MaterialCommand::addAllMaterials))));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"take").then(Commands.argument((String)"material", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_MATERIALS).then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(MaterialCommand::takeMaterial))).executes(MaterialCommand::takeMaterial)))).then(((LiteralArgumentBuilder)Commands.literal((String)"all").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(MaterialCommand::takeAllMaterials))).executes(MaterialCommand::takeAllMaterials)));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"set").then(Commands.argument((String)"material", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_MATERIALS).then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(MaterialCommand::setMaterial))).executes(MaterialCommand::setMaterial)))).then(Commands.literal((String)"all").then(((RequiredArgumentBuilder)Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(MaterialCommand::setAllMaterials))).executes(MaterialCommand::setAllMaterials))));
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    private static int addMaterial(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = MaterialCommand.getPlayers(context, 5);
        ResourceLocation materialName = ResourceLocation.parse((String)((String)context.getArgument("material", String.class)));
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        Item material = (Item)BuiltInRegistries.ITEM.get(materialName);
        if (material == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Material '" + String.valueOf(materialName) + "' does not exist")));
            return 0;
        }
        for (ServerPlayer player : players) {
            PlayerData playerData = PlayerData.get((Player)player);
            playerData.addMaterial(material, amount);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Given x" + amount + " '" + Utils.translateToLocal(materialName.toString(), new Object[0]) + "' to " + player.getDisplayName().getString())), true);
            player.sendSystemMessage((Component)Component.translatable((String)("You have been given x" + amount + " '" + Utils.translateToLocal(materialName.toString(), new Object[0]) + "'")));
            PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
        }
        return 1;
    }

    private static int takeMaterial(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = MaterialCommand.getPlayers(context, 5);
        ResourceLocation materialName = ResourceLocation.parse((String)((String)context.getArgument("material", String.class)));
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        Item material = (Item)BuiltInRegistries.ITEM.get(materialName);
        for (ServerPlayer player : players) {
            PlayerData playerData = PlayerData.get((Player)player);
            playerData.removeMaterial(material, amount);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Removed material '" + Utils.translateToLocal(materialName.toString(), new Object[0]) + "' from " + player.getDisplayName().getString())), true);
            player.sendSystemMessage((Component)Component.translatable((String)("x" + amount + " '" + Utils.translateToLocal(materialName.toString(), new Object[0]) + "' have been taken away from you")));
            PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
        }
        return 1;
    }

    private static int addAllMaterials(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = MaterialCommand.getPlayers(context, 5);
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        for (ServerPlayer player : players) {
            PlayerData playerData = PlayerData.get((Player)player);
            for (Item material : Tags.getItemsInTag(player.level(), Tags.MATERIALS)) {
                playerData.addMaterial(material, amount);
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Given all materials to " + player.getDisplayName().getString())), true);
            player.sendSystemMessage((Component)Component.translatable((String)"You have been given all the materials"));
            PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
        }
        return 1;
    }

    private static int takeAllMaterials(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = MaterialCommand.getPlayers(context, 4);
        for (ServerPlayer player : players) {
            PlayerData playerData = PlayerData.get((Player)player);
            playerData.clearMaterials();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Taken all materials from " + player.getDisplayName().getString())), true);
            player.sendSystemMessage((Component)Component.translatable((String)"Your materials have been taken away"));
            PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
        }
        return 1;
    }

    private static int setMaterial(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = MaterialCommand.getPlayers(context, 5);
        ResourceLocation materialName = ResourceLocation.parse((String)((String)context.getArgument("material", String.class)));
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        Item material = (Item)BuiltInRegistries.ITEM.get(materialName);
        for (ServerPlayer player : players) {
            PlayerData playerData = PlayerData.get((Player)player);
            playerData.setMaterial(material, amount);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Set x" + amount + " '" + Utils.translateToLocal(materialName.toString(), new Object[0]) + "' to " + player.getDisplayName().getString())), true);
            player.sendSystemMessage((Component)Component.translatable((String)("Your '" + Utils.translateToLocal(materialName.toString(), new Object[0]) + "' have been set to x" + amount)));
            PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
        }
        return 1;
    }

    private static int setAllMaterials(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = MaterialCommand.getPlayers(context, 5);
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        for (ServerPlayer player : players) {
            PlayerData playerData = PlayerData.get((Player)player);
            for (Item material : Tags.getItemsInTag(player.level(), Tags.MATERIALS)) {
                playerData.setMaterial(material, amount);
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Set all materials for " + player.getDisplayName().getString() + " to " + amount)), true);
            player.sendSystemMessage((Component)Component.translatable((String)("You have been set all the materials to " + amount)));
            PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
        }
        return 1;
    }
}

