/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.data.PlayerData;

public class PayMunnyCommand
extends BaseCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"paymunny").requires(source -> source.hasPermission(0));
        builder.then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).executes(PayMunnyCommand::payValue)));
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    private static int payValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer user = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        PlayerData userData = PlayerData.get((Player)user);
        Collection players = EntityArgument.getPlayers(context, (String)"targets");
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        if (userData.getMunny() - value * players.size() >= 0) {
            for (ServerPlayer target : players) {
                PlayerData targetData = PlayerData.get((Player)target);
                userData.setMunny(userData.getMunny() - value);
                targetData.setMunny(targetData.getMunny() + value);
                user.sendSystemMessage((Component)Component.translatable((String)("You paid " + value + " munny to " + target.getDisplayName().getString())));
                target.sendSystemMessage((Component)Component.translatable((String)("You got " + value + " munny from " + user.getDisplayName().getString())));
            }
        } else {
            user.sendSystemMessage((Component)Component.translatable((String)("You don't have enough munny (" + value + ") to pay " + PayMunnyCommand.getPlayersString(players))));
        }
        return 1;
    }

    public static String getPlayersString(Collection<ServerPlayer> players) {
        Object line = "";
        for (Player player : players) {
            line = (String)line + player.getDisplayName().getString() + ", ";
        }
        return ((String)line).substring(0, ((String)line).length() - 2);
    }
}

