/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;
import online.kingdomkeys.kingdomkeys.shotlock.ModShotlocks;
import online.kingdomkeys.kingdomkeys.shotlock.Shotlock;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class ShotlockCommand
extends BaseCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_SHOTLOCKS = (p_198296_0_, p_198296_1_) -> {
        ArrayList<String> list = new ArrayList<String>();
        for (ResourceLocation actual : ModShotlocks.registry.keySet()) {
            list.add(actual.toString());
        }
        return SharedSuggestionProvider.suggest(list.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)p_198296_1_);
    };

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"shotlock").requires(source -> source.hasPermission(2));
        builder.then(Commands.literal((String)"give").then(((RequiredArgumentBuilder)Commands.argument((String)"shotlock", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_SHOTLOCKS).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ShotlockCommand::addShotlock))).executes(ShotlockCommand::addShotlock)));
        builder.then(((LiteralArgumentBuilder)Commands.literal((String)"take").then(((RequiredArgumentBuilder)Commands.argument((String)"shotlock", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_SHOTLOCKS).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ShotlockCommand::removeShotlock))).executes(ShotlockCommand::removeShotlock))).then(((LiteralArgumentBuilder)Commands.literal((String)"all").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ShotlockCommand::removeAllShotlocks))).executes(ShotlockCommand::removeAllShotlocks)));
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    private static int addShotlock(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = ShotlockCommand.getPlayers(context, 4);
        String shotlockName = StringArgumentType.getString(context, (String)"shotlock");
        Shotlock a = (Shotlock)ModShotlocks.registry.get(ResourceLocation.parse((String)shotlockName));
        if (a == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Shotlock '" + shotlockName + "' does not exist")));
            return 0;
        }
        for (ServerPlayer player : players) {
            PlayerData playerData = PlayerData.get((Player)player);
            playerData.addShotlockToList(shotlockName, true);
            if (player != ((CommandSourceStack)context.getSource()).getPlayerOrException()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Added '" + Utils.translateToLocal(a.getTranslationKey(), new Object[0]) + "' shotlock to " + player.getDisplayName().getString())), true);
            }
            player.sendSystemMessage((Component)Component.translatable((String)("You have been given the shotlock '" + Utils.translateToLocal(a.getTranslationKey(), new Object[0]) + "'")));
            PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
        }
        return 1;
    }

    private static int removeShotlock(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = ShotlockCommand.getPlayers(context, 4);
        String shotlock = StringArgumentType.getString(context, (String)"shotlock");
        for (ServerPlayer player : players) {
            PlayerData playerData = PlayerData.get((Player)player);
            playerData.removeShotlockFromList(shotlock);
            if (player != ((CommandSourceStack)context.getSource()).getPlayerOrException()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Removed shotlock '" + Utils.translateToLocal(shotlock, new Object[0]) + "' from " + player.getDisplayName().getString())), true);
            }
            Shotlock a = (Shotlock)ModShotlocks.registry.get(ResourceLocation.parse((String)shotlock));
            player.sendSystemMessage((Component)Component.translatable((String)("Your shotlock '" + Utils.translateToLocal(a.getTranslationKey(), new Object[0]) + "' has been taken away")));
            PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
        }
        return 1;
    }

    private static int removeAllShotlocks(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection<ServerPlayer> players = ShotlockCommand.getPlayers(context, 4);
        for (ServerPlayer player : players) {
            PlayerData playerData = PlayerData.get((Player)player);
            playerData.getShotlockList().clear();
            if (player != ((CommandSourceStack)context.getSource()).getPlayerOrException()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)("Removed all shotlocks from " + player.getDisplayName().getString())), true);
            }
            player.sendSystemMessage((Component)Component.translatable((String)"Your shotlocks have been taken away"));
            PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
        }
        return 1;
    }
}

