/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.command.DimensionCommand;
import online.kingdomkeys.kingdomkeys.entity.mob.MarluxiaEntity;
import online.kingdomkeys.kingdomkeys.world.dimension.ModDimensions;

public class WhisperInMyEarPinkHairMan
extends BaseCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)"whisperinmyearpinkhairman").requires(source -> source.hasPermission(2));
        builder.executes(WhisperInMyEarPinkHairMan::spawn);
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
        return builder;
    }

    private static int spawn(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        if (player.level().dimension() == ModDimensions.STATION_OF_SORROW) {
            ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"overworld"));
            BlockPos coords = DimensionCommand.getWorldCoords((Player)player, (ResourceKey<Level>)dimension);
            player.changeDimension(new DimensionTransition(player.getServer().getLevel(dimension), new Vec3((double)coords.getX(), (double)coords.getY(), (double)coords.getZ()), Vec3.ZERO, player.getYRot(), player.getXRot(), entity -> {}));
            player.sendSystemMessage((Component)Component.translatable((String)("You have been teleported to " + String.valueOf(dimension.location()))));
        } else {
            ResourceKey<Level> dimension = ModDimensions.STATION_OF_SORROW;
            BlockPos coords = DimensionCommand.getWorldCoords((Player)player, dimension);
            player.changeDimension(new DimensionTransition(player.getServer().getLevel(dimension), new Vec3((double)coords.getX(), (double)coords.getY(), (double)coords.getZ()), Vec3.ZERO, player.getYRot(), player.getXRot(), entity -> {}));
            player.sendSystemMessage((Component)Component.translatable((String)("You have been returned back to " + String.valueOf(dimension.location()))));
            MarluxiaEntity marluxia = new MarluxiaEntity(player.level());
            marluxia.finalizeSpawn((ServerLevelAccessor)((ServerLevel)player.level()), player.level().getCurrentDifficultyAt(marluxia.blockPosition()), MobSpawnType.COMMAND, null);
            player.level().addFreshEntity((Entity)marluxia);
            marluxia.setPos(player.getX(), player.getY(), player.getZ() - 6.0);
        }
        return 1;
    }
}

