/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;
import online.kingdomkeys.kingdomkeys.entity.SpawningMode;

public class CommonConfig {
    public ModConfigSpec.EnumValue<SpawningMode> heartlessSpawningMode;
    public ModConfigSpec.ConfigValue<List<? extends String>> mobSpawnRate;
    public ModConfigSpec.IntValue rodHeartlessLevelScale;
    public ModConfigSpec.IntValue rodHeartlessMaxLevel;
    public ModConfigSpec.BooleanValue respawnROD;
    public ModConfigSpec.BooleanValue mobLevelingUp;
    public ModConfigSpec.BooleanValue mobLevelName;
    public ModConfigSpec.BooleanValue bombExplodeWithFire;
    public ModConfigSpec.BooleanValue keybladeOpenDoors;
    public ModConfigSpec.IntValue driveHeal;
    public ModConfigSpec.DoubleValue drivePointsMultiplier;
    public ModConfigSpec.DoubleValue focusPointsMultiplier;
    public ModConfigSpec.IntValue hpDropProbability;
    public ModConfigSpec.IntValue mpDropProbability;
    public ModConfigSpec.IntValue munnyDropProbability;
    public ModConfigSpec.IntValue driveDropProbability;
    public ModConfigSpec.IntValue focusDropProbability;
    public ModConfigSpec.BooleanValue blizzardChangeBlocks;
    public ModConfigSpec.BooleanValue playerSpawnHeartless;
    public ModConfigSpec.ConfigValue<List<? extends String>> playerSpawnHeartlessData;
    public ModConfigSpec.DoubleValue shotlockMult;
    public ModConfigSpec.DoubleValue critMult;
    public ModConfigSpec.IntValue mobLevelStats;
    public ModConfigSpec.BooleanValue bossDespawnIfNoTarget;
    public ModConfigSpec.BooleanValue needKeybladeForHeartless;
    public ModConfigSpec.ConfigValue<String> linkedSavePointRecovers;
    public ModConfigSpec.ConfigValue<String> savePointRecovers;
    public ModConfigSpec.ConfigValue<String> warpPointRecovers;
    public ModConfigSpec.ConfigValue<List<? extends String>> startingRecipes;

    CommonConfig(ModConfigSpec.Builder builder) {
        builder.push("general");
        this.bombExplodeWithFire = builder.comment("Allow Bomb heartless to explode when lit on fire").translation("kingdomkeys.config.bomb_explode_with_fire").define("bombExplodeWithfire", true);
        this.blizzardChangeBlocks = builder.comment("Allow Blizzard to turn lava into obsidian and freeze water").translation("kingdomkeys.config.blizzard_change_blocks").define("blizzardChangeBlocks", true);
        this.keybladeOpenDoors = builder.comment("Allow keyblades to open iron doors with right click").translation("kingdomkeys.config.keyblade_open_doors").define("keybladeOpenDoors", true);
        this.driveHeal = builder.comment("Health % restored when using a drive form").translation("kingdomkeys.config.drive_heal").defineInRange("driveHeal", 50, 0, 100);
        this.drivePointsMultiplier = builder.comment("Drive Points Drop Multiplier").translation("kingdomkeys.config.drive_points_multiplier").defineInRange("drivePointsMultiplier", 1.0, 0.0, 100.0);
        this.focusPointsMultiplier = builder.comment("Focus Points Drop Multiplier").translation("kingdomkeys.config.focus_points_multiplier").defineInRange("focusPointsMultiplier", 1.0, 0.0, 100.0);
        this.critMult = builder.comment("Critic Damage Multiplier").translation("kingdomkeys.config.crit_mult").defineInRange("critMult", 1.5, 0.0, 100.0);
        this.needKeybladeForHeartless = builder.comment("Force the player to need a Keyblade or an Organization weapon to hurt Heartless, and Nobodies").translation("kingdomkeys.config.need_keyblade_for_heartless").define("needKeybladeForHeartless", false);
        this.savePointRecovers = builder.comment("Stats restored when using a normal savepoint (Allowed values: HP,HUNGER,MP,FOCUS,DRIVE)").translation("kingdomkeys.config.normal_save_point_restore_list").define("normalSavePointRestoreList", (Object)"HP,MP", o -> o instanceof String);
        this.linkedSavePointRecovers = builder.comment("Stats restored when using a linked savepoint (Allowed values: HP,HUNGER,MP,FOCUS,DRIVE)").translation("kingdomkeys.config.full_save_point_restore_list").define("fullSavePointRestoreList", (Object)"HP,HUNGER,MP,FOCUS", o -> o instanceof String);
        this.warpPointRecovers = builder.comment("Stats restored when using a warp point (Allowed values: HP,HUNGER,MP,FOCUS,DRIVE)").translation("kingdomkeys.config.warp_point_restore_list").define("warpPointRestoreList", (Object)"HP,HUNGER,MP,FOCUS,DRIVE", o -> o instanceof String);
        builder.pop();
        builder.push("spawning");
        this.heartlessSpawningMode = builder.comment("Heartless spawning mode: NEVER, ALWAYS, AFTER_KEYCHAIN (after the first keychain is synthesized), AFTER_DRAGON (after the Ender Dragon is defeated)").translation("kingdomkeys.config.heartless_spawning_mode").defineEnum("heartlessSpawningMode", (Enum)SpawningMode.AFTER_KEYCHAIN);
        this.mobSpawnRate = builder.comment("Mob Spawn chance in percentage [type, chance] (if the chance doesn't add up to 100, enemies will not spawn)").translation("kingdomkeys.config.mob_spawn").defineList("mobSpawn", (List)Lists.newArrayList((Object[])new String[]{"Pureblood,35", "Emblem,35", "Nobody,30"}), () -> "Pureblood,35", o -> o instanceof String);
        this.playerSpawnHeartless = builder.comment("Allow a heartless and a nobody to spawn when a player gets killed by a heartless").translation("kingdomkeys.config.player_spawn_heartless").define("playerSpawnHeartless", true);
        this.mobLevelingUp = builder.comment("Allow heartless and nobodies to spawn with levels according to players").translation("kingdomkeys.config.player_mob_leveling_up").define("mobLevelingUp", true);
        this.mobLevelName = builder.comment("Add the level to the name of mobs, when this is enabled the name will not be removed from mobs that have already spawned in your world").translation("kingdomkeys.config.mob_level_name").define("mobLevelName", true);
        this.rodHeartlessLevelScale = builder.comment("Heartless spawning in the ROD will increase 1 level every X blocks").translation("kingdomkeys.config.rod_heartless_level_scale").defineInRange("rodHeartlessLevelScale", 10, 1, 1000);
        this.rodHeartlessMaxLevel = builder.comment("Max level for heartless spawning in ROD").translation("kingdomkeys.config.rod_heartless_max_level").defineInRange("rodHeartlessMaxLevel", 200, 1, 10000);
        this.playerSpawnHeartlessData = builder.comment("Heartless and nobody stats: name, hp (% of the player's), strength (% of the player's)").translation("kingdomkeys.config.player_spawn_heartless_Data").defineList("playerSpawnHeartlessData", (List)Lists.newArrayList((Object[])new String[]{"Heartless,100,100", "Nobody,100,100"}), () -> "Heartless,100,100", o -> o instanceof String);
        this.respawnROD = builder.comment("Force players who die in the Realm of Darkness to respawn there").translation("kingdomkeys.config.respawn_rod").define("respawnROD", false);
        this.mobLevelStats = builder.comment("Mob base stats multiplier out of 100% (default 10)").translation("kingdomkeys.config.mob_level_stats").defineInRange("mobLevelStats", 10, 0, 100);
        this.bossDespawnIfNoTarget = builder.comment("Make bosses despawn once his target disappears").translation("kingdomkeys.config.boss_despawn_if_no_target").define("bossDespawnIfNoTarget", true);
        builder.pop();
        builder.push("drops");
        this.hpDropProbability = builder.comment("HP Drops Probability").translation("kingdomkeys.config.hp_drop_probability").defineInRange("hpDropProbability", 80, 0, 100);
        this.mpDropProbability = builder.comment("MP Drops Probability").translation("kingdomkeys.config.mp_drop_probability").defineInRange("mpDropProbability", 80, 0, 100);
        this.munnyDropProbability = builder.comment("Munny Drops Probability").translation("kingdomkeys.config.munny_drop_probability").defineInRange("munnyDropProbability", 80, 0, 100);
        this.driveDropProbability = builder.comment("Drive Drops Probability").translation("kingdomkeys.config.drive_drop_probability").defineInRange("driveDropProbability", 80, 0, 100);
        this.focusDropProbability = builder.comment("Focus Drops Probability").translation("kingdomkeys.config.focus_drop_probability").defineInRange("focusDropProbability", 80, 0, 100);
        builder.pop();
        builder.push("shotlock");
        this.shotlockMult = builder.comment("Shotlock Damage Multiplier (magic * multiplier)").translation("kingdomkeys.config.shotlock_mult").defineInRange("shotlockMult", 0.4, 0.0, 100.0);
        builder.pop();
        builder.push("synthesis");
        this.startingRecipes = builder.comment("Synthesis recipes given to the player on first join, so changing this list will not give you recipes in worlds you've already created").translation("kingdomkeys.config.starting_recipes").defineList("startingRecipes", List.of("kingdomkeys:mythril_shard", "kingdomkeys:mythril_stone", "kingdomkeys:mythril_gem", "kingdomkeys:mythril_crystal", "kingdomkeys:potion", "kingdomkeys:hi_potion", "kingdomkeys:mega_potion", "kingdomkeys:ether", "kingdomkeys:hi_ether", "kingdomkeys:mega_ether", "kingdomkeys:elixir", "kingdomkeys:mega_lixir", "kingdomkeys:drive_recovery", "kingdomkeys:hi_drive_recovery", "kingdomkeys:refocuser", "kingdomkeys:hi_refocuser", "kingdomkeys:powerboost", "kingdomkeys:magicboost", "kingdomkeys:defenseboost", "kingdomkeys:apboost"), o -> {
            if (o instanceof String) {
                String s = (String)o;
                return ResourceLocation.tryParse((String)s) != null;
            }
            return false;
        });
        builder.pop();
    }
}

