/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.floor.Floor;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.Room;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomData;

public class CastleOblivionData {
    private CastleOblivionData() {
    }

    public static class ExteriorData
    extends SavedData {
        Map<UUID, ResourceLocation> interiors = new HashMap<UUID, ResourceLocation>();
        private static ExteriorData clientCache = new ExteriorData();

        private static ExteriorData create() {
            return new ExteriorData();
        }

        public static ExteriorData get(MinecraftServer server) {
            return (ExteriorData)server.overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(ExteriorData::create, ExteriorData::load), "kingdomkeys_exterior_data");
        }

        public static ExteriorData getClient() {
            return clientCache;
        }

        public static void setClientCache(ExteriorData data) {
            clientCache = data;
        }

        public CompoundTag save(CompoundTag pTag, HolderLookup.Provider pRegistries) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("interiors_size", this.interiors.size());
            List entries = this.interiors.entrySet().stream().toList();
            for (int i = 0; i < this.interiors.size(); ++i) {
                tag.putUUID("interior_uuid_" + i, (UUID)((Map.Entry)entries.get(i)).getKey());
                tag.putString("interior_dimensionrl_" + i, ((ResourceLocation)((Map.Entry)entries.get(i)).getValue()).toString());
            }
            return tag;
        }

        public static ExteriorData load(CompoundTag tag, HolderLookup.Provider provider) {
            ExteriorData data = ExteriorData.create();
            if (data.interiors == null) {
                data.interiors = new HashMap<UUID, ResourceLocation>();
            }
            int size = tag.getInt("interiors_size");
            data.interiors.clear();
            for (int i = 0; i < size; ++i) {
                data.interiors.put(tag.getUUID("interior_uuid_" + i), ResourceLocation.parse((String)tag.getString("interior_dimensionrl_" + i)));
            }
            return data;
        }

        public Map<UUID, ResourceLocation> getInteriors() {
            return this.interiors;
        }

        public void addInterior(UUID uuid, ResourceLocation dimension) {
            this.interiors.put(uuid, dimension);
            this.setDirty();
        }

        public ResourceLocation getInterior(UUID id) {
            return this.interiors.get(id);
        }
    }

    public static class InteriorData
    extends SavedData {
        List<Floor> floors = new ArrayList<Floor>();
        private static Map<ResourceKey<Level>, InteriorData> clientCache = new HashMap<ResourceKey<Level>, InteriorData>();

        private static InteriorData create() {
            return new InteriorData();
        }

        public static InteriorData get(ServerLevel level) {
            if (level.dimension().location().toString().contains("kingdomkeys:castle_oblivion_")) {
                return (InteriorData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(InteriorData::create, InteriorData::load), "kingdomkeys_interior_data");
            }
            return null;
        }

        public static InteriorData getClient(ClientLevel level) {
            if (clientCache.containsKey(level.dimension())) {
                return clientCache.get(level.dimension());
            }
            return null;
        }

        public static void setClientCache(ClientLevel level, InteriorData data) {
            clientCache.put((ResourceKey<Level>)level.dimension(), data);
        }

        public static void clearClientCache() {
            clientCache = new HashMap<ResourceKey<Level>, InteriorData>();
        }

        public CompoundTag save(CompoundTag pTag, HolderLookup.Provider pRegistries) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("floors_size", this.floors.size());
            for (int i = 0; i < this.floors.size(); ++i) {
                tag.put("floors_" + i, (Tag)this.floors.get(i).serializeNBT());
            }
            return tag;
        }

        public static InteriorData load(CompoundTag tag, HolderLookup.Provider provider) {
            InteriorData data = InteriorData.create();
            if (data.floors == null) {
                data.floors = new ArrayList<Floor>();
            }
            data.floors.clear();
            int size = tag.getInt("floors_size");
            for (int i = 0; i < size; ++i) {
                data.floors.add(new Floor((CompoundTag)tag.get("floors_" + i)));
            }
            return data;
        }

        public List<Floor> getFloors() {
            return this.floors;
        }

        public void addFloor(Floor floor) {
            this.floors.add(floor);
            this.setDirty();
        }

        public Room getRoomAtPos(BlockPos pos) {
            Floor floor = this.getFloorAtPos(pos);
            for (RoomData room : floor.getRooms()) {
                Room r = room.getGenerated();
                if (r == null || !r.inRoom(pos)) continue;
                return r;
            }
            return null;
        }

        public Floor getFloorAtPos(BlockPos pos) {
            Room closestEntrance = this.floors.getFirst().getEntranceHall().getGenerated();
            if (closestEntrance != null) {
                double closestDistance = closestEntrance.getPosition().distSqr((Vec3i)pos);
                for (Floor floor : this.getFloors()) {
                    if (!(floor.getEntranceHallPosition().distSqr((Vec3i)pos) < closestDistance)) continue;
                    closestEntrance = floor.getEntranceHall().getGenerated();
                    closestDistance = floor.getEntranceHallPosition().distSqr((Vec3i)pos);
                }
                return closestEntrance.getParent(this);
            }
            return null;
        }

        public Floor getFloorByID(int id) {
            List<Floor> f = this.getFloors().stream().filter(floor -> floor.getFloorID() == id).toList();
            return !f.isEmpty() ? f.getFirst() : null;
        }

        public boolean isInRoom(BlockPos pos) {
            return false;
        }
    }
}

