/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.common.util.INBTSerializable;
import online.kingdomkeys.kingdomkeys.data.ModData;

public class GlobalData
implements INBTSerializable<CompoundTag> {
    private static Map<Integer, GlobalData> mobDataClientCache = new HashMap<Integer, GlobalData>();
    private int level;
    private int stopModelTicks;
    ArrayList<Float> stopDmg = new ArrayList();
    private String stopCaster;
    private boolean castleOblivionMarker;

    protected GlobalData() {
    }

    public static GlobalData get(LivingEntity entity) {
        if (!entity.hasData(ModData.GLOBAL_DATA)) {
            entity.setData(ModData.GLOBAL_DATA, (Object)new GlobalData());
        }
        return (GlobalData)entity.getData(ModData.GLOBAL_DATA);
    }

    public static GlobalData getClient(LivingEntity entity) {
        return mobDataClientCache.get(entity.getId());
    }

    public static void setClientCache(LivingEntity entity, GlobalData data) {
        mobDataClientCache.put(entity.getId(), data);
    }

    public static void clearClientCache() {
        mobDataClientCache = new HashMap<Integer, GlobalData>();
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag storage = new CompoundTag();
        ListTag dmgList = new ListTag();
        for (float unit : this.stopDmg) {
            dmgList.add((Object)FloatTag.valueOf((float)unit));
        }
        storage.put("stop_dmg", (Tag)dmgList);
        storage.putBoolean("castle_oblivion_marker", this.getCastleOblivionMarker());
        storage.putInt("level", this.getLevel());
        if (this.getStopCaster() != null) {
            storage.putString("stop_caster", this.getStopCaster());
        }
        storage.putInt("stop_model_ticks", this.getStopModelTicks());
        return storage;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.stopDmg.clear();
        ListTag floatListTag = nbt.getList("stop_dmg", 5);
        for (int i = 0; i < floatListTag.size(); ++i) {
            this.stopDmg.add(Float.valueOf(floatListTag.getFloat(i)));
        }
        this.setCastleOblivionMarker(nbt.getBoolean("castle_oblivion_marker"));
        this.setLevel(nbt.getInt("level"));
        if (nbt.contains("stop_caster")) {
            this.setStopCaster(nbt.getString("stop_caster"));
        }
        this.setStopModelTicks(nbt.getInt("stop_model_ticks"));
    }

    public void setLevel(int lvl) {
        this.level = lvl;
    }

    public int getLevel() {
        return this.level;
    }

    public ArrayList<Float> getStopDamage() {
        return this.stopDmg;
    }

    public void setStopDamage(ArrayList<Float> dmg) {
        this.stopDmg = dmg;
    }

    public void addDamage(float dmg) {
        this.stopDmg.add(Float.valueOf(dmg));
    }

    public void setStopCaster(String name) {
        this.stopCaster = name;
    }

    public String getStopCaster() {
        return this.stopCaster;
    }

    public boolean getCastleOblivionMarker() {
        return this.castleOblivionMarker;
    }

    public void setCastleOblivionMarker(boolean marker) {
        this.castleOblivionMarker = marker;
    }

    public int getStopModelTicks() {
        return this.stopModelTicks;
    }

    public void setStopModelTicks(int ticks) {
        this.stopModelTicks = ticks;
    }
}

