/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.data;

import com.google.common.collect.Lists;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.util.INBTSerializable;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.advancements.ModAdvancements;
import online.kingdomkeys.kingdomkeys.api.item.IKeychain;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.GlobalData;
import online.kingdomkeys.kingdomkeys.data.ModData;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.integration.epicfight.enums.DualChoices;
import online.kingdomkeys.kingdomkeys.integration.epicfight.enums.SingleChoices;
import online.kingdomkeys.kingdomkeys.item.KKAccessoryItem;
import online.kingdomkeys.kingdomkeys.item.KKArmorItem;
import online.kingdomkeys.kingdomkeys.item.KKPotionItem;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.PauldronItem;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.leveling.Stat;
import online.kingdomkeys.kingdomkeys.lib.LevelStats;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCShowOverlayPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;
import online.kingdomkeys.kingdomkeys.reactioncommands.ModReactionCommands;
import online.kingdomkeys.kingdomkeys.reactioncommands.ReactionCommand;
import online.kingdomkeys.kingdomkeys.shotlock.ModShotlocks;
import online.kingdomkeys.kingdomkeys.shotlock.Shotlock;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class PlayerData
implements INBTSerializable<CompoundTag> {
    private int level = 1;
    private int exp = 0;
    private int expGiven = 0;
    private int maxHp = 20;
    private int remainingExp = 0;
    private int reflectTicks = 0;
    private int reflectLevel = 0;
    private int magicCasttime = 0;
    private int magicCooldown = 0;
    private int munny = 0;
    private int antipoints = 0;
    private int aerialDodgeTicks;
    private int synthLevel = 1;
    private int synthExp;
    private int remainingSynthExp = 0;
    private BlockPos airStepPos = new BlockPos(0, 0, 0);
    Stat strength = new Stat("strength", 1.0);
    Stat magic = new Stat("magic", 1.0);
    Stat defense = new Stat("defense", 1.0);
    Stat maxAP = new Stat("max_ap", 0.0);
    private String driveForm = DriveForm.NONE.toString();
    LinkedHashMap<String, int[]> driveForms = new LinkedHashMap();
    LinkedHashMap<String, int[]> magicList = new LinkedHashMap();
    List<String> shotlockList = new ArrayList<String>();
    List<Utils.ShotlockPosition> shotlockEnemies = new ArrayList<Utils.ShotlockPosition>();
    boolean hasShotMaxShotlock = false;
    List<ResourceLocation> recipeList = new ArrayList<ResourceLocation>();
    LinkedHashMap<String, int[]> abilityMap = new LinkedHashMap();
    private TreeMap<ResourceLocation, Integer> materials = new TreeMap();
    List<String> reactionList = new ArrayList<String>();
    List<String> partyList = new ArrayList<String>();
    String equippedShotlock = "";
    LinkedHashMap<Integer, String> shortcutsMap = new LinkedHashMap();
    private double mp = 0.0;
    private double maxMP = 0.0;
    private double dp = 0.0;
    private double maxDP = 1000.0;
    private double fp = 0.0;
    private double focus = 100.0;
    private double maxFocus = 100.0;
    private boolean recharge;
    private boolean reflectActive;
    private boolean isGliding;
    private boolean hasJumpedAerealDodge = false;
    private Vec3 returnPos = Vec3.ZERO;
    private ResourceKey<Level> returnDim = Level.OVERWORLD;
    SoAState soAState = SoAState.NONE;
    SoAState choice = SoAState.NONE;
    SoAState sacrifice = SoAState.NONE;
    private BlockPos choicePedestal = new BlockPos(0, 0, 0);
    private BlockPos sacrificePedestal = new BlockPos(0, 0, 0);
    private List<String> messages = new ArrayList<String>();
    private List<String> bfMessages = new ArrayList<String>();
    private List<String> dfMessages = new ArrayList<String>();
    private Utils.OrgMember alignment = Utils.OrgMember.NONE;
    private int hearts = 0;
    private Set<ItemStack> weaponUnlocks = new HashSet<ItemStack>();
    private int limitCooldownTicks = 0;
    private ItemStack equippedWeapon = ItemStack.EMPTY;
    private Map<ResourceLocation, ItemStack> equippedKeychains = new HashMap<ResourceLocation, ItemStack>();
    private Map<Integer, ItemStack> equippedItems = new HashMap<Integer, ItemStack>();
    private Map<Integer, ItemStack> equippedAccessories = new HashMap<Integer, ItemStack>();
    private Map<Integer, ItemStack> equippedArmors = new HashMap<Integer, ItemStack>();
    private Map<Integer, ItemStack> equippedKBArmors = new HashMap<Integer, ItemStack>();
    private int maxAccessories = 0;
    private int maxArmors = 0;
    private int armorColor = 0xFFFFFF;
    private boolean armorGlint = true;
    private SingleChoices singleStyle = SingleChoices.SORA;
    private DualChoices dualStyle = DualChoices.KH2_ROXAS_DUAL;
    private boolean respawnROD = false;
    private int notifColor = 0xFFFFFF;
    private Map<UUID, Instant> discoveredSavePoints = new HashMap<UUID, Instant>();
    Utils.castMagic castMagic = null;
    private Set<String> synthesisedRecipes = new HashSet<String>();

    protected PlayerData() {
    }

    public static PlayerData get(CompoundTag nbt, Player player) {
        if (FMLEnvironment.dist.isClient()) {
            PlayerData data = new PlayerData();
            data.deserializeNBT((HolderLookup.Provider)player.level().registryAccess(), nbt);
            player.setData(ModData.PLAYER_DATA, (Object)data);
            return data;
        }
        return PlayerData.get(player);
    }

    public static PlayerData get(Player player) {
        if (!player.hasData(ModData.PLAYER_DATA)) {
            player.setData(ModData.PLAYER_DATA, (Object)new PlayerData());
        }
        return (PlayerData)player.getData(ModData.PLAYER_DATA);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag storage = new CompoundTag();
        storage.putInt("level", this.getLevel());
        storage.putInt("experience", this.getExperience());
        storage.putInt("experience_given", this.getExperienceGiven());
        this.strength.serialize(storage);
        this.magic.serialize(storage);
        this.defense.serialize(storage);
        this.maxAP.serialize(storage);
        storage.putInt("max_hp", this.getMaxHP());
        storage.putDouble("mp", this.getMP());
        storage.putDouble("max_mp", this.getMaxMP());
        storage.putDouble("focus", this.getFocus());
        storage.putDouble("max_focus", this.getMaxFocus());
        storage.putBoolean("recharge", this.getRecharge());
        storage.putDouble("dp", this.getDP());
        storage.putDouble("max_dp", this.getMaxDP());
        storage.putDouble("fp", this.getFP());
        storage.putString("drive_form", this.getActiveDriveForm());
        storage.putInt("anti_points", this.getAntiPoints());
        storage.putInt("reflect_ticks", this.getReflectTicks());
        storage.putInt("reflect_level", this.getReflectLevel());
        storage.putBoolean("reflect_active", this.getReflectActive());
        storage.putInt("munny", this.getMunny());
        storage.putByte("soa_state", this.getSoAState().get());
        storage.putByte("soa_choice", this.getChosen().get());
        storage.putByte("soa_sacrifice", this.getSacrificed().get());
        CompoundTag returnCompound = new CompoundTag();
        Vec3 pos = this.getReturnLocation();
        returnCompound.putDouble("x", pos.x);
        returnCompound.putDouble("y", pos.y);
        returnCompound.putDouble("z", pos.z);
        storage.put("soa_return_pos", (Tag)returnCompound);
        storage.putString("soa_return_dim", this.getReturnDimension().location().toString());
        CompoundTag choicePedestalCompound = new CompoundTag();
        BlockPos choicePos = this.getChoicePedestal();
        choicePedestalCompound.putInt("x", choicePos.getX());
        choicePedestalCompound.putInt("y", choicePos.getY());
        choicePedestalCompound.putInt("z", choicePos.getZ());
        storage.put("soa_choice_pedestal", (Tag)choicePedestalCompound);
        CompoundTag sacrificePedestalCompound = new CompoundTag();
        BlockPos sacrificePos = this.getSacrificePedestal();
        sacrificePedestalCompound.putInt("x", sacrificePos.getX());
        sacrificePedestalCompound.putInt("y", sacrificePos.getY());
        sacrificePedestalCompound.putInt("z", sacrificePos.getZ());
        storage.put("soa_sacrifice_pedestal", (Tag)sacrificePedestalCompound);
        CompoundTag recipes = new CompoundTag();
        for (ResourceLocation resourceLocation : this.getKnownRecipeList()) {
            recipes.putString(resourceLocation.toString(), resourceLocation.toString());
        }
        storage.put("recipes", (Tag)recipes);
        CompoundTag magics = new CompoundTag();
        for (Map.Entry<String, int[]> entry : this.getMagicsMap().entrySet()) {
            magics.putIntArray(entry.getKey(), entry.getValue());
        }
        storage.put("magics", (Tag)magics);
        CompoundTag compoundTag = new CompoundTag();
        for (String string : this.getShotlockList()) {
            compoundTag.putInt(string, 0);
        }
        storage.put("shotlocks", (Tag)compoundTag);
        storage.putString("equipped_shotlock", this.getEquippedShotlock());
        CompoundTag compoundTag2 = new CompoundTag();
        for (Map.Entry<String, int[]> entry : this.getDriveFormMap().entrySet()) {
            compoundTag2.putIntArray(entry.getKey(), entry.getValue());
        }
        storage.put("drive_forms", (Tag)compoundTag2);
        CompoundTag compoundTag3 = new CompoundTag();
        for (Map.Entry<String, int[]> entry : this.getAbilityMap().entrySet()) {
            compoundTag3.putIntArray(entry.getKey(), entry.getValue());
        }
        storage.put("abilities", (Tag)compoundTag3);
        CompoundTag compoundTag4 = new CompoundTag();
        for (String rc : this.getReactionCommands()) {
            compoundTag4.putInt(rc, 0);
        }
        storage.put("reaction_commands", (Tag)compoundTag4);
        CompoundTag compoundTag5 = new CompoundTag();
        this.getEquippedKeychains().forEach((form, chain) -> keychains.put(form.toString(), chain.saveOptional(provider)));
        storage.put("keychains", (Tag)compoundTag5);
        CompoundTag items = new CompoundTag();
        this.getEquippedItems().forEach((slot, item) -> items.put(slot.toString(), item.saveOptional(provider)));
        storage.put("items", (Tag)items);
        CompoundTag accessories = new CompoundTag();
        this.getEquippedAccessories().forEach((slot, accessory) -> accessories.put(slot.toString(), accessory.saveOptional(provider)));
        storage.put("accessories", (Tag)accessories);
        CompoundTag kbArmors = new CompoundTag();
        this.getEquippedKBArmors().forEach((slot, kbArmor) -> kbArmors.put(slot.toString(), kbArmor.saveOptional(provider)));
        storage.put("kbarmors", (Tag)kbArmors);
        CompoundTag armors = new CompoundTag();
        this.getEquippedArmors().forEach((slot, armor) -> armors.put(slot.toString(), armor.saveOptional(provider)));
        storage.put("armors", (Tag)armors);
        storage.putInt("max_accessories", this.getMaxAccessories());
        storage.putInt("max_armors", this.getMaxArmors());
        storage.putInt("hearts", this.getHearts());
        storage.putInt("org_alignment", this.getAlignmentIndex());
        storage.put("org_equipped_weapon", this.getEquippedWeapon().saveOptional(provider));
        CompoundTag unlockedWeapons = new CompoundTag();
        this.getWeaponsUnlocked().forEach(weapon -> unlockedWeapons.put(Utils.getItemRegistryName(weapon.getItem()).toString(), weapon.saveOptional(provider)));
        storage.put("org_weapons_unlocked", (Tag)unlockedWeapons);
        CompoundTag parties = new CompoundTag();
        for (int i = 0; i < this.getPartiesInvited().size(); ++i) {
            parties.putInt(this.getPartiesInvited().get(i), i);
        }
        storage.put("parties", (Tag)parties);
        CompoundTag mats = new CompoundTag();
        for (Map.Entry<ResourceLocation, Integer> entry : this.getMaterialMap().entrySet()) {
            mats.putInt(entry.getKey().toString(), entry.getValue().intValue());
            if (mats.getInt(entry.getKey().toString()) != 0 || entry.getKey() == null) continue;
            mats.remove(entry.getKey().toString());
        }
        storage.put("materials", (Tag)mats);
        storage.putInt("limitCooldownTicks", this.getLimitCooldownTicks());
        CompoundTag shortcuts = new CompoundTag();
        for (Map.Entry<Integer, String> entry : this.getShortcutsMap().entrySet()) {
            shortcuts.putString(entry.getKey().toString(), entry.getValue());
        }
        storage.put("shortcuts", (Tag)shortcuts);
        storage.putInt("synth_level", this.synthLevel);
        storage.putInt("synth_exp", this.synthExp);
        storage.putString("single_style", this.singleStyle.toString());
        storage.putString("dual_style", this.dualStyle.toString());
        storage.putInt("armor_color", this.armorColor);
        storage.putBoolean("armor_glint", this.armorGlint);
        storage.putBoolean("respawn_rod", this.respawnROD);
        storage.putInt("notif_color", this.notifColor);
        CompoundTag compoundTag6 = new CompoundTag();
        Vec3 vec3 = this.getAirStep().getCenter();
        compoundTag6.putDouble("x", vec3.x);
        compoundTag6.putDouble("y", vec3.y);
        compoundTag6.putDouble("z", vec3.z);
        storage.put("airstep_pos_compound", (Tag)compoundTag6);
        CompoundTag savePoints = new CompoundTag();
        this.discoveredSavePoints.forEach((uuid, instant) -> {
            CompoundTag timeTag = new CompoundTag();
            timeTag.putLong("second", instant.getEpochSecond());
            timeTag.putInt("nano", instant.getNano());
            savePoints.put(uuid.toString(), (Tag)timeTag);
        });
        storage.put("save_points", (Tag)savePoints);
        CompoundTag synthedRecipes = new CompoundTag();
        for (String rec : this.getSynthesisedRecipes()) {
            synthedRecipes.putInt(rec, 0);
        }
        storage.put("synthesised_recipes", (Tag)synthedRecipes);
        storage.putInt("aerial_dodge_ticks", this.aerialDodgeTicks);
        storage.putBoolean("aerial_dodge_jumped", this.hasJumpedAerialDodge());
        storage.putBoolean("is_gliding", this.isGliding);
        storage.putInt("cast_ticks", this.magicCasttime);
        storage.putInt("cd_ticks", this.magicCooldown);
        return storage;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        int boost;
        this.setLevel(nbt.getInt("level"));
        this.setExperience(nbt.getInt("experience"));
        this.setExperienceGiven(nbt.getInt("experience_given"));
        this.strength = Stat.deserializeNBT("strength", nbt);
        if (nbt.contains("boost_strength")) {
            boost = nbt.getInt("boost_strength");
            nbt.remove("boost_strength");
            this.strength.addModifier("legacy_boosts", boost, false, false);
        }
        this.magic = Stat.deserializeNBT("magic", nbt);
        if (nbt.contains("boost_magic")) {
            boost = nbt.getInt("boost_magic");
            nbt.remove("boost_magic");
            this.magic.addModifier("legacy_boosts", boost, false, false);
        }
        this.defense = Stat.deserializeNBT("defense", nbt);
        if (nbt.contains("boost_defense")) {
            boost = nbt.getInt("boost_defense");
            nbt.remove("boost_defense");
            this.defense.addModifier("legacy_boosts", boost, false, false);
        }
        this.maxAP = Stat.deserializeNBT("max_ap", nbt);
        if (nbt.contains("boost_max_ap")) {
            boost = nbt.getInt("boost_max_ap");
            nbt.remove("boost_max_ap");
            this.maxAP.addModifier("legacy_boosts", boost, false, false);
        }
        this.setMaxHP(nbt.getInt("max_hp"));
        this.setMP(nbt.getDouble("mp"));
        this.setMaxMP(nbt.getDouble("max_mp"));
        this.setFocus(nbt.getDouble("focus"));
        this.setMaxFocus(nbt.getDouble("max_focus"));
        this.setRecharge(nbt.getBoolean("recharge"));
        this.setDP(nbt.getDouble("dp"));
        this.setMaxDP(nbt.getDouble("max_dp"));
        this.setFP(nbt.getDouble("fp"));
        this.setActiveDriveForm(nbt.getString("drive_form"));
        this.setAntiPoints(nbt.getInt("anti_points"));
        this.setReflectTicks(nbt.getInt("reflect_ticks"), nbt.getInt("reflect_level"));
        this.setReflectActive(nbt.getBoolean("reflect_active"));
        this.setMunny(nbt.getInt("munny"));
        this.setSoAState(SoAState.fromByte(nbt.getByte("soa_state")));
        this.setChoice(SoAState.fromByte(nbt.getByte("soa_choice")));
        this.setSacrifice(SoAState.fromByte(nbt.getByte("soa_sacrifice")));
        CompoundTag returnCompound = nbt.getCompound("soa_return_pos");
        this.setReturnLocation(new Vec3(returnCompound.getDouble("x"), returnCompound.getDouble("y"), returnCompound.getDouble("z")));
        this.setReturnDimension((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)nbt.getString("soa_return_dim"))));
        CompoundTag choicePedestal = nbt.getCompound("soa_choice_pedestal");
        this.setChoicePedestal(new BlockPos(choicePedestal.getInt("x"), choicePedestal.getInt("y"), choicePedestal.getInt("z")));
        CompoundTag sacrificePedestal = nbt.getCompound("soa_sacrifice_pedestal");
        this.setSacrificePedestal(new BlockPos(sacrificePedestal.getInt("x"), sacrificePedestal.getInt("y"), sacrificePedestal.getInt("z")));
        this.recipeList.clear();
        for (String key2 : nbt.getCompound("recipes").getAllKeys()) {
            this.getKnownRecipeList().add(ResourceLocation.parse((String)key2));
        }
        Collections.sort(this.recipeList);
        this.magicList.clear();
        for (String magicName : nbt.getCompound("magics").getAllKeys()) {
            int[] array;
            if (nbt.getCompound("magics").contains(magicName, 99)) {
                KingdomKeys.LOGGER.info("Converting " + magicName + " data");
                array = new int[]{nbt.getCompound("magics").getInt(magicName), 0};
            } else {
                array = nbt.getCompound("magics").getIntArray(magicName);
            }
            if (!ModMagic.registry.containsKey(ResourceLocation.parse((String)magicName))) continue;
            this.getMagicsMap().put(magicName, array);
        }
        this.shotlockList.clear();
        for (String key2 : nbt.getCompound("shotlocks").getAllKeys()) {
            if (!ModShotlocks.registry.containsKey(ResourceLocation.parse((String)key2))) continue;
            this.getShotlockList().add(key2);
        }
        this.setEquippedShotlock(nbt.getString("equipped_shotlock"));
        this.driveForms.clear();
        for (String driveFormName : nbt.getCompound("drive_forms").getAllKeys()) {
            if (!ModDriveForms.registry.containsKey(ResourceLocation.parse((String)driveFormName))) continue;
            this.getDriveFormMap().put(driveFormName, nbt.getCompound("drive_forms").getIntArray(driveFormName));
        }
        this.abilityMap.clear();
        for (String abilityName : nbt.getCompound("abilities").getAllKeys()) {
            if (!ModAbilities.registry.containsKey(ResourceLocation.parse((String)abilityName))) continue;
            this.getAbilityMap().put(abilityName, nbt.getCompound("abilities").getIntArray(abilityName));
        }
        this.reactionList.clear();
        for (String key2 : nbt.getCompound("reaction_commands").getAllKeys()) {
            if (!ModReactionCommands.registry.containsKey(ResourceLocation.parse((String)key2))) continue;
            this.getReactionCommands().add(key2);
        }
        this.equippedKeychains.clear();
        CompoundTag keychainsNBT = nbt.getCompound("keychains");
        keychainsNBT.getAllKeys().forEach(chain -> this.setNewKeychain(ResourceLocation.parse((String)chain), ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)keychainsNBT.getCompound(chain))));
        this.equippedItems.clear();
        CompoundTag itemsNBT = nbt.getCompound("items");
        itemsNBT.getAllKeys().forEach(slot -> this.setNewItem(Integer.parseInt(slot), ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemsNBT.getCompound(slot))));
        this.equippedAccessories.clear();
        CompoundTag accessoriesNBT = nbt.getCompound("accessories");
        accessoriesNBT.getAllKeys().forEach(slot -> this.setNewAccessory(Integer.parseInt(slot), ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)accessoriesNBT.getCompound(slot))));
        this.equippedKBArmors.clear();
        CompoundTag kbArmorsNBT = nbt.getCompound("kbarmors");
        kbArmorsNBT.getAllKeys().forEach(slot -> this.setNewKBArmor(Integer.parseInt(slot), ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)kbArmorsNBT.getCompound(slot))));
        this.equippedArmors.clear();
        CompoundTag armorsNBT = nbt.getCompound("armors");
        armorsNBT.getAllKeys().forEach(slot -> this.setNewArmor(Integer.parseInt(slot), ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)armorsNBT.getCompound(slot))));
        this.setMaxAccessories(nbt.getInt("max_accessories"));
        this.setMaxArmors(nbt.getInt("max_armors"));
        this.setHearts(nbt.getInt("hearts"));
        this.setAlignment(nbt.getInt("org_alignment"));
        this.equipWeapon(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound("org_equipped_weapon")));
        CompoundTag unlocksCompound = nbt.getCompound("org_weapons_unlocked");
        this.weaponUnlocks.clear();
        unlocksCompound.getAllKeys().forEach(key -> this.unlockWeapon(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)unlocksCompound.getCompound(key))));
        this.partyList.clear();
        for (String key3 : nbt.getCompound("parties").getAllKeys()) {
            this.getPartiesInvited().add(key3);
        }
        this.materials.clear();
        for (String mat : nbt.getCompound("materials").getAllKeys()) {
            this.getMaterialMap().put(ResourceLocation.parse((String)mat), nbt.getCompound("materials").getInt(mat));
        }
        this.setLimitCooldownTicks(nbt.getInt("limitCooldownTicks"));
        this.shortcutsMap.clear();
        for (String s : nbt.getCompound("shortcuts").getAllKeys()) {
            int shortcutPos = Integer.parseInt(s);
            this.getShortcutsMap().put(shortcutPos, nbt.getCompound("shortcuts").getString("" + shortcutPos));
        }
        this.setSynthLevel(nbt.getInt("synth_level"));
        this.setSynthExperience(nbt.getInt("synth_exp"));
        String s = nbt.getString("single_style");
        if (!s.equals("")) {
            s = nbt.getString("dual_style");
        }
        if (!s.equals("")) {
            this.setDualStyle(DualChoices.valueOf(s));
        }
        this.setArmorColor(nbt.getInt("armor_color"));
        this.setArmorGlint(nbt.getBoolean("armor_glint"));
        this.setRespawnROD(nbt.getBoolean("respawn_rod"));
        this.setNotifColor(nbt.getInt("notif_color"));
        CompoundTag airStepCompound = nbt.getCompound("airstep_pos_compound");
        this.setAirStep(new BlockPos((int)airStepCompound.getDouble("x"), (int)airStepCompound.getDouble("y"), (int)airStepCompound.getDouble("z")));
        this.discoveredSavePoints.clear();
        CompoundTag savePoints = nbt.getCompound("save_points");
        for (String key4 : savePoints.getAllKeys()) {
            UUID uuid = UUID.fromString(key4);
            CompoundTag time = savePoints.getCompound(key4);
            this.addDiscoveredSavePoint(uuid, Instant.ofEpochSecond(time.getLong("second"), time.getInt("nano")));
        }
        this.synthesisedRecipes.clear();
        for (String key4 : nbt.getCompound("synthesised_recipes").getAllKeys()) {
            if (!RecipeRegistry.getInstance().getRegistry().containsKey(ResourceLocation.parse((String)key4))) continue;
            this.getSynthesisedRecipes().add(key4);
        }
        this.setAerialDodgeTicks(nbt.getInt("aerial_dodge_ticks"));
        this.setHasJumpedAerialDodge(nbt.getBoolean("aerial_dodge_jumped"));
        this.setIsGliding(nbt.getBoolean("is_gliding"));
        this.setMagicCasttimeTicks(nbt.getInt("cast_ticks"));
        this.setMagicCooldownTicks(nbt.getInt("cd_ticks"));
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getExperience() {
        return this.exp;
    }

    public void setExperience(int exp) {
        this.exp = exp;
    }

    public void addExperience(Player player, int exp, boolean shareXP, boolean sound) {
        if (player != null && this.getSoAState() == SoAState.COMPLETE && this.level < 100) {
            Party party = WorldData.get(player.getServer()).getPartyFromMember(player.getUUID());
            if (party != null && shareXP) {
                double sharedXP = (double)exp * ((Double)ModConfigs.SERVER.partyXPShare.get() / 100.0 * 2.0);
                if (sharedXP > 0.0) {
                    for (Party.Member member : party.getMembers()) {
                        for (ResourceKey worldKey : player.level().getServer().levelKeys()) {
                            Player ally = player.getServer().getLevel(worldKey).getPlayerByUUID(member.getUUID());
                            if (ally == null || ally == player) continue;
                            PlayerData.get(ally).addExperience(ally, (int)sharedXP, false, true);
                            PacketHandler.sendTo(new SCSyncPlayerData(ally), (ServerPlayer)ally);
                        }
                    }
                }
                if (this.getNumberOfAbilitiesEquipped("kingdomkeys:ability_experience_boost") > 0 && player.getHealth() <= player.getMaxHealth() / 2.0f) {
                    exp *= 1 + this.getNumberOfAbilitiesEquipped("kingdomkeys:ability_experience_boost");
                }
                this.exp += exp;
            } else {
                if (this.getNumberOfAbilitiesEquipped("kingdomkeys:ability_experience_boost") > 0 && player.getHealth() <= player.getMaxHealth() / 2.0f && shareXP) {
                    exp *= 1 + this.getNumberOfAbilitiesEquipped("kingdomkeys:ability_experience_boost");
                }
                this.exp += exp;
            }
            while (this.getExpNeeded(this.getLevel(), this.exp) <= 0 && this.getLevel() != 100) {
                this.setLevel(this.getLevel() + 1);
                if (player instanceof ServerPlayer) {
                    ServerPlayer svPlayer = (ServerPlayer)player;
                    ModAdvancements.levelUp.trigger(svPlayer, this.getLevel());
                }
                this.levelUpStatsAndDisplayMessage(player, sound);
                PacketHandler.sendTo(new SCShowOverlayPacket("levelup", player.getUUID(), player.getDisplayName().getString(), this.getLevel(), this.getNotifColor(), new ArrayList<String>(this.getMessages())), (ServerPlayer)player);
            }
            PacketHandler.sendTo(new SCShowOverlayPacket("exp"), (ServerPlayer)player);
        }
    }

    public int getExperienceGiven() {
        return this.expGiven;
    }

    public void setExperienceGiven(int exp) {
        this.expGiven = exp;
    }

    public int getStrength(boolean combined) {
        return (int)(combined ? (((Boolean)ModConfigs.SERVER.allowBoosts.get() != false ? this.strength.getStat() : this.strength.get()) + (double)Utils.getAccessoriesStat(this, "str") + (double)(this.getRecharge() ? this.getNumberOfAbilitiesEquipped("kingdomkeys:ability_berserk_charge") * 2 : 0)) * (double)((Integer)((List)ModConfigs.SERVER.statsMultiplier.get()).get(0)).intValue() / 100.0 : this.strength.get());
    }

    public void setStrength(int level) {
        this.strength.set(level);
    }

    public int getMagic(boolean combined) {
        return (int)(combined ? (((Boolean)ModConfigs.SERVER.allowBoosts.get() != false ? this.magic.getStat() : this.magic.get()) + (double)Utils.getAccessoriesStat(this, "mag")) * (double)((Integer)((List)ModConfigs.SERVER.statsMultiplier.get()).get(1)).intValue() / 100.0 : this.magic.get());
    }

    public void setMagic(int level) {
        this.magic.set(level);
    }

    public int getDefense(boolean combined) {
        return (int)(combined ? (((Boolean)ModConfigs.SERVER.allowBoosts.get() != false ? this.defense.getStat() : this.defense.get()) + (double)Utils.getArmorsStat(this, "def")) * (double)((Integer)((List)ModConfigs.SERVER.statsMultiplier.get()).get(2)).intValue() / 100.0 : this.defense.get());
    }

    public void setDefense(int level) {
        this.defense.set(level);
    }

    public int getExpNeeded(int level, int currentExp) {
        if (level == 100) {
            return 0;
        }
        double nextLevel = ((double)level + 300.0 * Math.pow(2.0, (double)level / 7.0)) * ((double)level * 0.25);
        this.remainingExp = (int)nextLevel - currentExp;
        return this.remainingExp;
    }

    public void addStrength(int str) {
        this.strength.add(str);
        this.messages.add("stats.levelUpStr");
    }

    public Stat getStrengthStat() {
        return this.strength;
    }

    public void setStrengthStat(Stat stat) {
        this.strength = stat;
    }

    public void addMagic(int mag) {
        this.magic.add(mag);
        this.messages.add("stats.levelUpMag");
    }

    public Stat getMagicStat() {
        return this.magic;
    }

    public void setMagicStat(Stat stat) {
        this.magic = stat;
    }

    public void addDefense(int def) {
        this.defense.add(def);
        this.messages.add("stats.levelUpDef");
    }

    public Stat getDefenseStat() {
        return this.defense;
    }

    public void setDefenseStat(Stat stat) {
        this.defense = stat;
    }

    public int getMaxHP() {
        return this.maxHp;
    }

    public void setMaxHP(int hp) {
        this.maxHp = hp;
    }

    public void addMaxHP(int hp) {
        this.maxHp += hp;
        this.messages.add("stats.levelUpHP");
    }

    public int getMaxAP(boolean combined) {
        return (int)(combined ? this.maxAP.getStat() + (double)this.getAccessoriesAP("ap") : this.maxAP.get());
    }

    public Stat getMaxAPStat() {
        return this.maxAP;
    }

    public void setMaxAPStat(Stat stat) {
        this.maxAP = stat;
    }

    private int getAccessoriesAP(String type) {
        int res = 0;
        for (Map.Entry<Integer, ItemStack> accessory : this.getEquippedAccessories().entrySet()) {
            Object object;
            if (ItemStack.matches((ItemStack)accessory.getValue(), (ItemStack)ItemStack.EMPTY) || !((object = accessory.getValue().getItem()) instanceof KKAccessoryItem)) continue;
            KKAccessoryItem a = (KKAccessoryItem)object;
            switch (type) {
                case "ap": {
                    res += a.getAp();
                    break;
                }
                case "str": {
                    res += a.getStr();
                    break;
                }
                case "mag": {
                    res += a.getMag();
                }
            }
        }
        return res;
    }

    public void setMaxAP(int ap) {
        this.maxAP.set(ap);
    }

    public void addMaxAP(int ap) {
        this.maxAP.add(ap);
        this.messages.add("stats.levelUpAP");
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void clearMessages() {
        this.getMessages().clear();
    }

    public List<String> getBFMessages() {
        return this.bfMessages;
    }

    public void clearBFMessages() {
        this.getBFMessages().clear();
    }

    public void setBFMessages(List<String> messages) {
        this.bfMessages = messages;
    }

    public List<String> getDFMessages() {
        return this.dfMessages;
    }

    public void clearDFMessages() {
        this.getDFMessages().clear();
    }

    public void setDFMessages(List<String> messages) {
        this.dfMessages = messages;
    }

    public void levelUpStatsAndDisplayMessage(Player player, boolean sound) {
        this.getMessages().clear();
        LevelStats.applyStatsForLevel(this.level, player, this);
        Party party = WorldData.get(player.getServer()).getPartyFromMember(player.getUUID());
        if (party != null) {
            for (Party.Member member : party.getMembers()) {
                for (ResourceKey worldKey : player.level().getServer().levelKeys()) {
                    Player ally = player.getServer().getLevel(worldKey).getPlayerByUUID(member.getUUID());
                    if (ally == null || ally == player) continue;
                    PacketHandler.sendTo(new SCShowOverlayPacket("levelup", player.getUUID(), player.getDisplayName().getString(), this.getLevel(), this.getNotifColor(), new ArrayList<String>(this.getMessages())), (ServerPlayer)ally);
                    PacketHandler.syncToAllAround(player, this);
                }
            }
        }
        if (sound) {
            player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.levelup.get(), SoundSource.MASTER, 0.5f, 1.0f);
        }
        player.getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)this.getMaxHP());
        PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
        PacketHandler.syncToAllAround(player, this);
        AABB radius = new AABB(player.getX(), player.getY(), player.getZ(), player.getX() + 1.0, player.getY() + 1.0, player.getZ() + 1.0).inflate(50.0, 50.0, 50.0);
        List tamedAnimals = player.level().getNearbyEntities(TamableAnimal.class, TargetingConditions.forNonCombat(), (LivingEntity)player, radius);
        if (!tamedAnimals.isEmpty()) {
            tamedAnimals.forEach(tamableAnimal -> {
                GlobalData animalData = GlobalData.get((LivingEntity)tamableAnimal);
                animalData.setLevel(this.getLevel());
                Utils.applyMobLevel((LivingEntity)tamableAnimal, this.level);
                tamableAnimal.heal(tamableAnimal.getMaxHealth());
            });
        }
    }

    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    public void displayDriveFormLevelUpMessage(Player player, String driveForm) {
        String name;
        Ability a;
        this.getBFMessages().clear();
        this.getDFMessages().clear();
        this.dfMessages.add("stats.levelUpFG");
        DriveForm form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)driveForm));
        String driveformAbility = form.getDFAbilityForLevel(this.getDriveFormLevel(driveForm));
        String baseAbility = form.getBaseAbilityForLevel(this.getDriveFormLevel(driveForm));
        if (driveformAbility != null && !driveformAbility.equals("")) {
            a = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)driveformAbility));
            name = a.getTranslationKey();
            if (a.getType() == Ability.AbilityType.GROWTH) {
                int level = this.getEquippedAbilityLevel(driveformAbility)[0] + 2;
                name = new StringBuilder(name).insert(name.lastIndexOf(46), "_" + level).toString();
            }
            this.dfMessages.add("A_" + name);
        }
        if (baseAbility != null && !baseAbility.equals("")) {
            a = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)baseAbility));
            name = a.getTranslationKey();
            if (a.getType() == Ability.AbilityType.GROWTH) {
                name = new StringBuilder(name).insert(name.lastIndexOf(46), "_" + (this.getEquippedAbilityLevel(baseAbility)[0] + 1)).toString();
            }
            this.addAbility(baseAbility, name, true);
        }
        player.level().playSound(null, player.position().x(), player.position().y(), player.position().z(), (SoundEvent)ModSounds.levelup.get(), SoundSource.MASTER, 0.5f, 1.0f);
        PacketHandler.sendTo(new SCShowOverlayPacket("drivelevelup", driveForm, new ArrayList<String>(this.bfMessages), new ArrayList<String>(this.dfMessages)), (ServerPlayer)player);
    }

    public double getDP() {
        return this.dp;
    }

    public void setDP(double dp) {
        this.dp = dp;
    }

    public void addDP(double dp) {
        this.dp = Utils.clamp(this.dp + dp, 0.0, this.maxDP);
    }

    public void remDP(double dp) {
        this.dp = Utils.clamp(this.dp - dp, 0.0, this.maxDP);
    }

    public double getMaxDP() {
        return this.maxDP;
    }

    public void setMaxDP(double dp) {
        this.maxDP = Math.min(this.maxDP + dp, 1000.0);
    }

    public double getFP() {
        return this.fp;
    }

    public void setFP(double fp) {
        this.fp = fp;
    }

    public void addFP(double fp) {
        double max = 200 + Utils.getDriveFormLevel(this.getDriveFormMap(), this.getActiveDriveForm()) * 100;
        this.fp = Math.min(this.fp + fp, max);
    }

    public void remFP(double fp) {
        this.fp = Math.max(this.fp - fp, 0.0);
    }

    public void setActiveDriveForm(String form) {
        this.driveForm = form;
    }

    public String getActiveDriveForm() {
        return this.driveForm;
    }

    public LinkedHashMap<String, int[]> getDriveFormMap() {
        return this.driveForms;
    }

    public void setDriveFormMap(LinkedHashMap<String, int[]> map) {
        this.driveForms = map;
    }

    public int getDriveFormLevel(String name) {
        return this.driveForms.containsKey(name) ? this.driveForms.get(name)[0] : 0;
    }

    public void setDriveFormLevel(String name, int level) {
        DriveForm form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)name));
        if (name.equals(DriveForm.NONE.toString()) || name.equals(DriveForm.SYNCH_BLADE.toString())) {
            this.driveForms.put(name, new int[]{level, 1});
        } else if (level == 0) {
            this.driveForms.remove(name);
        } else if (level <= form.getMaxLevel()) {
            int experience = form.getLevelUpCost(level);
            this.driveForms.put(name, new int[]{level, experience});
        }
    }

    public int getDriveFormExp(String name) {
        return this.driveForms.get(name)[1];
    }

    public void setDriveFormExp(Player player, String name, int exp) {
        DriveForm form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)name));
        int oldLevel = this.getDriveFormLevel(name);
        int driveLevel = form.getLevelFromExp(exp);
        if (driveLevel <= form.getMaxLevel()) {
            this.driveForms.put(name, new int[]{driveLevel, exp});
            if (driveLevel > oldLevel) {
                this.displayDriveFormLevelUpMessage(player, name);
                if (driveLevel == form.getMaxLevel()) {
                    this.setMaxDP(this.getMaxDP() + 100.0);
                }
                PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
            }
        }
    }

    public void addDriveFormExperience(String drive, ServerPlayer player, int value) {
        DriveForm form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)drive));
        int oldLevel = this.getDriveFormLevel(drive);
        int driveLevel = form.getLevelFromExp(this.exp + value);
        if (driveLevel <= form.getMaxLevel()) {
            this.driveForms.put(drive, new int[]{driveLevel, this.exp + value});
            if (driveLevel > oldLevel) {
                this.displayDriveFormLevelUpMessage((Player)player, drive);
                if (driveLevel == form.getMaxLevel()) {
                    this.setMaxDP(this.getMaxDP() + 100.0);
                }
                PacketHandler.sendTo(new SCSyncPlayerData((Player)player), player);
            }
        }
    }

    public int getAntiPoints() {
        return this.antipoints;
    }

    public void setAntiPoints(int points) {
        this.antipoints = points;
    }

    public double getMP() {
        return this.mp;
    }

    public void setMP(double mp) {
        this.mp = mp;
    }

    public void addMP(double mp) {
        this.mp = Utils.clamp(this.mp + mp, 0.0, this.maxMP);
    }

    public double getMaxMP() {
        return this.maxMP;
    }

    public void setMaxMP(double mp) {
        this.maxMP = mp;
    }

    public void addMaxMP(double mp) {
        this.maxMP += mp;
        this.setMP(this.getMaxMP());
        this.messages.add("stats.levelUpMP");
    }

    public void remMP(double amount) {
        this.mp = this.isAbilityEquipped("kingdomkeys:ability_extra_cast") ? (amount >= this.maxMP ? Math.max(this.mp - amount, 0.0) : (this.mp > 1.0 && this.mp - amount < 1.0 ? 1.0 : Math.max(this.mp - amount, 0.0))) : Math.max(this.mp - amount, 0.0);
    }

    public double getFocus() {
        return this.focus;
    }

    public void setFocus(double focus) {
        this.focus = focus;
    }

    public void addFocus(double focus) {
        this.focus = Math.min(this.focus + focus, this.getMaxFocus());
    }

    public void remFocus(double cost) {
        this.focus = Math.max(this.focus - cost, 0.0);
    }

    public double getMaxFocus() {
        return this.maxFocus;
    }

    public void setMaxFocus(double maxFocus) {
        this.maxFocus = maxFocus;
    }

    public void addMaxFocus(double focus) {
        this.focus += focus;
    }

    public void setShotlockEnemies(List<Utils.ShotlockPosition> list) {
        this.shotlockEnemies = list;
    }

    public List<Utils.ShotlockPosition> getShotlockEnemies() {
        return this.shotlockEnemies;
    }

    public void addShotlockEnemy(Utils.ShotlockPosition shotlockPos) {
        this.shotlockEnemies.add(shotlockPos);
    }

    public boolean hasShotMaxShotlock() {
        return this.hasShotMaxShotlock;
    }

    public void setHasShotMaxShotlock(boolean val) {
        this.hasShotMaxShotlock = val;
    }

    public void setRecharge(boolean b) {
        this.recharge = b;
    }

    public boolean getRecharge() {
        return this.recharge;
    }

    public int getReflectLevel() {
        return this.reflectLevel;
    }

    public void setReflectLevel(int level) {
        this.reflectLevel = level;
    }

    public void setReflectTicks(int ticks, int level) {
        this.reflectTicks = ticks;
        this.reflectLevel = level;
    }

    public void remReflectTicks(int ticks) {
        this.reflectTicks -= ticks;
    }

    public int getReflectTicks() {
        return this.reflectTicks;
    }

    public void setReflectActive(boolean active) {
        this.reflectActive = active;
    }

    public boolean getReflectActive() {
        return this.reflectActive;
    }

    public LinkedHashMap<String, int[]> getMagicsMap() {
        return this.magicList;
    }

    public void setMagicsMap(LinkedHashMap<String, int[]> map) {
        this.magicList = map;
    }

    public int getMagicLevel(ResourceLocation name) {
        return this.magicList.containsKey(name.toString()) ? this.magicList.get(name.toString())[0] : 0;
    }

    public void setMagicLevel(ResourceLocation name, int level, boolean notification) {
        Magic magic = (Magic)ModMagic.registry.get(name);
        if (level == -1) {
            this.magicList.remove(name.toString());
        } else if (level <= magic.getMaxLevel()) {
            int uses = this.magicList.containsKey(name.toString()) ? this.getMagicUses(name) : 0;
            this.magicList.put(name.toString(), new int[]{level, uses});
            if (notification) {
                this.messages.add("M_" + magic.getTranslationKey(level));
            }
        }
    }

    public int getMagicUses(ResourceLocation name) {
        return this.magicList.get(name.toString())[1];
    }

    public void setMagicUses(ResourceLocation name, int uses) {
        Magic magic = (Magic)ModMagic.registry.get(name);
        int level = this.getMagicLevel(name);
        if (level <= magic.getMaxLevel()) {
            this.magicList.put(name.toString(), new int[]{level, uses});
        }
    }

    public void addMagicUses(ResourceLocation name, int uses) {
        this.setMagicUses(name, this.getMagicUses(name) + uses);
    }

    public void remMagicUses(ResourceLocation name, int uses) {
        this.setMagicUses(name, this.getMagicUses(name) - uses);
    }

    public List<String> getShotlockList() {
        return this.shotlockList;
    }

    public void setShotlockList(List<String> list) {
        this.shotlockList = list;
    }

    public void addShotlockToList(String shotlock, boolean notification) {
        Shotlock shotlockthis = (Shotlock)ModShotlocks.registry.get(ResourceLocation.parse((String)shotlock));
        if (notification) {
            this.messages.add("S_" + shotlockthis.getTranslationKey());
        }
        if (!this.shotlockList.contains(shotlock)) {
            this.shotlockList.add(shotlock);
        }
    }

    public void removeShotlockFromList(String shotlock) {
        this.shotlockList.remove(shotlock);
    }

    public void setMunny(int amount) {
        this.munny = amount;
    }

    public int getMunny() {
        return this.munny;
    }

    public Map<ResourceLocation, ItemStack> getEquippedKeychains() {
        return this.equippedKeychains;
    }

    public ItemStack equipKeychain(ResourceLocation form, ItemStack stack) {
        if (this.canEquipKeychain(form, stack)) {
            ItemStack previous = this.getEquippedKeychain(form);
            this.equippedKeychains.put(form, stack);
            return previous;
        }
        return null;
    }

    public ItemStack getEquippedKeychain(ResourceLocation form) {
        if (this.equippedKeychains.containsKey(form)) {
            return this.equippedKeychains.get(form);
        }
        return null;
    }

    public void equipAllKeychains(Map<ResourceLocation, ItemStack> keychains, boolean force) {
        if (!force) {
            keychains.replaceAll((k, v) -> this.canEquipKeychain((ResourceLocation)k, (ItemStack)v) ? v : ItemStack.EMPTY);
        }
        this.equippedKeychains = keychains;
    }

    public boolean canEquipKeychain(ResourceLocation form, ItemStack stack) {
        if (this.getEquippedKeychain(form) != null && ItemStack.matches((ItemStack)stack, (ItemStack)ItemStack.EMPTY) | stack.getItem() instanceof IKeychain) {
            return stack.getCount() <= 1;
        }
        return false;
    }

    public void setNewKeychain(ResourceLocation form, ItemStack stack) {
        if (!this.equippedKeychains.containsKey(form)) {
            this.equippedKeychains.put(form, stack);
        }
    }

    public Map<Integer, ItemStack> getEquippedItems() {
        return this.equippedItems;
    }

    public ItemStack equipItem(int slot, ItemStack stack) {
        if (this.canEquipItem(slot, stack)) {
            ItemStack previous = this.getEquippedItem(slot);
            this.equippedItems.put(slot, stack);
            return previous;
        }
        return null;
    }

    public ItemStack getEquippedItem(int slot) {
        if (this.equippedItems.containsKey(slot)) {
            return this.equippedItems.get(slot);
        }
        return null;
    }

    public void equipAllItems(Map<Integer, ItemStack> Items2, boolean force) {
        if (!force) {
            Items2.replaceAll((k, v) -> this.canEquipItem((int)k, (ItemStack)v) ? v : ItemStack.EMPTY);
        }
        this.equippedItems = Items2;
    }

    public boolean canEquipItem(int slot, ItemStack stack) {
        if (this.getEquippedItem(slot) != null && (ItemStack.matches((ItemStack)stack, (ItemStack)ItemStack.EMPTY) || stack.getItem() instanceof KKPotionItem)) {
            return stack.getCount() <= 1;
        }
        return false;
    }

    public void setNewItem(int slot, ItemStack stack) {
        if (!this.equippedItems.containsKey(slot)) {
            this.equippedItems.put(slot, stack);
        }
    }

    public Map<Integer, ItemStack> getEquippedAccessories() {
        return this.equippedAccessories;
    }

    public ItemStack equipAccessory(int slot, ItemStack stack) {
        if (this.canEquipAccessory(slot, stack)) {
            ItemStack previous = this.getEquippedAccessory(slot);
            this.equippedAccessories.put(slot, stack);
            return previous;
        }
        return null;
    }

    public ItemStack getEquippedAccessory(int slot) {
        if (this.equippedAccessories.containsKey(slot)) {
            return this.equippedAccessories.get(slot);
        }
        return null;
    }

    public void equipAllAccessories(Map<Integer, ItemStack> accessories, boolean force) {
        if (!force) {
            accessories.replaceAll((k, v) -> this.canEquipAccessory((int)k, (ItemStack)v) ? v : ItemStack.EMPTY);
        }
        this.equippedAccessories = accessories;
    }

    public boolean canEquipAccessory(int slot, ItemStack stack) {
        if (this.getEquippedAccessory(slot) != null && (ItemStack.matches((ItemStack)stack, (ItemStack)ItemStack.EMPTY) || stack.getItem() instanceof KKAccessoryItem)) {
            return stack.getCount() <= 1;
        }
        return false;
    }

    public void setNewAccessory(int slot, ItemStack stack) {
        if (!this.equippedAccessories.containsKey(slot)) {
            this.equippedAccessories.put(slot, stack);
        }
    }

    public Map<Integer, ItemStack> getEquippedKBArmors() {
        return this.equippedKBArmors;
    }

    public ItemStack equipKBArmor(int slot, ItemStack stack) {
        if (this.canEquipKBArmor(slot, stack)) {
            ItemStack previous = this.getEquippedKBArmor(slot);
            this.equippedKBArmors.put(slot, stack);
            return previous;
        }
        return null;
    }

    public ItemStack getEquippedKBArmor(int slot) {
        if (this.equippedKBArmors.containsKey(slot)) {
            return this.equippedKBArmors.get(slot);
        }
        return null;
    }

    public void equipAllKBArmor(Map<Integer, ItemStack> KBArmors, boolean force) {
        if (!force) {
            KBArmors.replaceAll((k, v) -> this.canEquipKBArmor((int)k, (ItemStack)v) ? v : ItemStack.EMPTY);
        }
        this.equippedKBArmors = KBArmors;
    }

    public boolean canEquipKBArmor(int slot, ItemStack stack) {
        if (this.getEquippedKBArmor(slot) != null && (ItemStack.matches((ItemStack)stack, (ItemStack)ItemStack.EMPTY) || stack.getItem() instanceof PauldronItem)) {
            return stack.getCount() <= 1;
        }
        return false;
    }

    public void setNewKBArmor(int slot, ItemStack stack) {
        if (!this.equippedKBArmors.containsKey(slot)) {
            this.equippedKBArmors.put(slot, stack);
        }
    }

    public int getNotifColor() {
        return this.notifColor;
    }

    public void setNotifColor(int color) {
        this.notifColor = color;
    }

    public int getArmorColor() {
        return this.armorColor;
    }

    public void setArmorColor(int color) {
        this.armorColor = color;
    }

    public boolean getArmorGlint() {
        return this.armorGlint;
    }

    public void setArmorGlint(boolean glint) {
        this.armorGlint = glint;
    }

    public Map<Integer, ItemStack> getEquippedArmors() {
        return this.equippedArmors;
    }

    public ItemStack getEquippedArmor(int slot) {
        if (this.equippedArmors.containsKey(slot)) {
            return this.equippedArmors.get(slot);
        }
        return null;
    }

    public ItemStack equipArmor(int slot, ItemStack stack) {
        if (this.canEquipArmor(slot, stack)) {
            ItemStack previous = this.getEquippedArmor(slot);
            this.equippedArmors.put(slot, stack);
            return previous;
        }
        return null;
    }

    public boolean canEquipArmor(int slot, ItemStack stack) {
        if (this.getEquippedArmor(slot) != null && (ItemStack.matches((ItemStack)stack, (ItemStack)ItemStack.EMPTY) || stack.getItem() instanceof KKArmorItem)) {
            return stack.getCount() <= 1;
        }
        return false;
    }

    public void equipAllArmors(Map<Integer, ItemStack> armors, boolean force) {
        if (!force) {
            armors.replaceAll((k, v) -> this.canEquipArmor((int)k, (ItemStack)v) ? v : ItemStack.EMPTY);
        }
        this.equippedArmors = armors;
    }

    public void setNewArmor(int slot, ItemStack stack) {
        if (!this.equippedArmors.containsKey(slot)) {
            this.equippedArmors.put(slot, stack);
        }
    }

    public int getHearts() {
        return this.hearts;
    }

    public void setHearts(int hearts) {
        this.hearts = Math.max(0, hearts);
    }

    public void addHearts(int hearts) {
        this.hearts = Mth.clamp((int)(this.hearts + hearts), (int)0, (int)Integer.MAX_VALUE);
    }

    public void removeHearts(int hearts) {
        this.addHearts(-hearts);
    }

    public Utils.OrgMember getAlignment() {
        return this.alignment;
    }

    public int getAlignmentIndex() {
        return this.alignment.ordinal();
    }

    public void setAlignment(int index) {
        this.alignment = Utils.OrgMember.values()[index];
    }

    public void setAlignment(Utils.OrgMember member) {
        this.alignment = member;
    }

    public boolean isWeaponUnlocked(Item weapon) {
        for (ItemStack stack : this.weaponUnlocks) {
            if (stack.getItem() != weapon) continue;
            return true;
        }
        return false;
    }

    public void unlockWeapon(ItemStack weapon) {
        if (!this.weaponUnlocks.contains(weapon)) {
            this.weaponUnlocks.add(weapon);
        }
    }

    public void unlockWeapon(String registryName) {
        ItemStack weaponUnlock;
        Item weapon = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)registryName));
        if (weapon != null && !this.weaponUnlocks.contains(weaponUnlock = new ItemStack((ItemLike)weapon))) {
            this.weaponUnlocks.add(weaponUnlock);
        }
    }

    public ItemStack getEquippedWeapon() {
        return this.equippedWeapon;
    }

    public void equipWeapon(ItemStack weapon) {
        this.equippedWeapon = weapon;
    }

    public Set<ItemStack> getWeaponsUnlocked() {
        return this.weaponUnlocks;
    }

    public void setWeaponsUnlocked(Set<ItemStack> unlocks) {
        this.weaponUnlocks = unlocks;
    }

    public int getLimitCooldownTicks() {
        return this.limitCooldownTicks;
    }

    public void setLimitCooldownTicks(int ticks) {
        this.limitCooldownTicks = ticks;
    }

    public boolean getIsGliding() {
        return this.isGliding;
    }

    public void setIsGliding(boolean b) {
        this.isGliding = b;
    }

    public int getAerialDodgeTicks() {
        return this.aerialDodgeTicks;
    }

    public void setAerialDodgeTicks(int ticks) {
        this.aerialDodgeTicks = ticks;
    }

    public boolean hasJumpedAerialDodge() {
        return this.hasJumpedAerealDodge;
    }

    public void setHasJumpedAerialDodge(boolean b) {
        this.hasJumpedAerealDodge = b;
    }

    public LinkedHashMap<String, int[]> getAbilityMap() {
        return this.abilityMap;
    }

    public void setAbilityMap(LinkedHashMap<String, int[]> map) {
        this.abilityMap = map;
    }

    public void addAbility(String ability, boolean notification) {
        Ability abilitythis = (Ability)ModAbilities.registry.get(ResourceLocation.parse((String)ability));
        if (notification) {
            this.messages.add("A_" + abilitythis.getTranslationKey());
        }
        if (this.abilityMap.containsKey(ability)) {
            this.abilityMap.put(ability, new int[]{this.abilityMap.get(ability)[0] + 1, this.abilityMap.get(ability)[1]});
        } else {
            this.abilityMap.put(ability, new int[]{1, 0});
        }
    }

    public void addAbility(String ability, String displayName, boolean dfLevelUp) {
        if (dfLevelUp) {
            this.bfMessages.add("A_" + displayName);
        } else {
            this.messages.add("A_" + displayName);
        }
        if (this.abilityMap.containsKey(ability)) {
            this.abilityMap.put(ability, new int[]{this.abilityMap.get(ability)[0] + 1, this.abilityMap.get(ability)[1]});
        } else {
            this.abilityMap.put(ability, new int[]{1, 0});
        }
    }

    public void removeAbility(String ability) {
        if (this.abilityMap.containsKey(ability)) {
            if (this.abilityMap.get(ability)[0] <= 1) {
                this.abilityMap.remove(ability);
            } else {
                this.abilityMap.put(ability, new int[]{this.abilityMap.get(ability)[0] - 1, 0});
            }
        }
    }

    public int[] getEquippedAbilityLevel(String string) {
        if (this.abilityMap.containsKey(string)) {
            return this.abilityMap.get(string);
        }
        return new int[]{0, 0};
    }

    public boolean isAbilityEquipped(String string) {
        return this.getNumberOfAbilitiesEquipped(string) > 0;
    }

    public int getNumberOfAbilitiesEquipped(String ability) {
        List<String> abilities;
        int level;
        IKeychain weapon;
        ItemStack stack;
        int amount = 0;
        if (this.getAlignment() == Utils.OrgMember.NONE) {
            if (this.getEquippedKeychain(DriveForm.NONE) != null && !ItemStack.matches((ItemStack)this.getEquippedKeychain(DriveForm.NONE), (ItemStack)ItemStack.EMPTY)) {
                stack = this.getEquippedKeychain(DriveForm.NONE);
                weapon = (IKeychain)stack.getItem();
                level = weapon.toSummon().getKeybladeLevel(stack);
                abilities = Utils.getKeybladeAbilitiesAtLevel((Item)weapon.toSummon(), level);
                amount += Collections.frequency(abilities, ability);
            }
        } else if (this.getEquippedWeapon() != null && !ItemStack.matches((ItemStack)this.getEquippedWeapon(), (ItemStack)ItemStack.EMPTY)) {
            Object[] abilitiesArray;
            if (this.getEquippedWeapon().getItem() instanceof KeybladeItem) {
                List<String> abilities2 = Utils.getKeybladeAbilitiesAtLevel(this.getEquippedWeapon().getItem(), 0);
                amount += Collections.frequency(abilities2, ability);
            } else if (this.getEquippedWeapon().getItem() instanceof IOrgWeapon && (abilitiesArray = ((IOrgWeapon)this.getEquippedWeapon().getItem()).getAbilities()) != null) {
                ArrayList a = Lists.newArrayList((Object[])abilitiesArray);
                amount += Collections.frequency(a, ability);
                if (this.abilityMap.containsKey("kingdomkeys:ability_synch_blade") && this.abilityMap.get("kingdomkeys:ability_synch_blade")[1] > 0) {
                    amount *= 2;
                }
            }
        }
        if (this.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
            if (this.abilityMap.containsKey("kingdomkeys:ability_synch_blade") && this.abilityMap.get("kingdomkeys:ability_synch_blade")[1] > 0 && !ItemStack.matches((ItemStack)this.getEquippedKeychain(DriveForm.SYNCH_BLADE), (ItemStack)ItemStack.EMPTY)) {
                stack = this.getEquippedKeychain(DriveForm.SYNCH_BLADE);
                weapon = (IKeychain)this.getEquippedKeychain(DriveForm.SYNCH_BLADE).getItem();
                level = weapon.toSummon().getKeybladeLevel(stack);
                abilities = Utils.getKeybladeAbilitiesAtLevel((Item)weapon.toSummon(), level);
                amount += Collections.frequency(abilities, ability);
            }
        } else {
            DriveForm form;
            List<String> list;
            stack = this.getEquippedKeychain(ResourceLocation.parse((String)this.getActiveDriveForm()));
            if (stack != null && !ItemStack.matches((ItemStack)stack, (ItemStack)ItemStack.EMPTY)) {
                weapon = (IKeychain)this.getEquippedKeychain(ResourceLocation.parse((String)this.getActiveDriveForm())).getItem();
                level = weapon.toSummon().getKeybladeLevel(stack);
                abilities = Utils.getKeybladeAbilitiesAtLevel((Item)weapon.toSummon(), level);
                amount += Collections.frequency(abilities, ability);
            }
            if ((list = (form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)this.getActiveDriveForm()))).getDriveFormData().getAbilities()) != null && !list.isEmpty()) {
                amount += Collections.frequency(list, ability);
            }
        }
        amount += Collections.frequency(Utils.getAccessoriesAbilities(this), ability);
        if (((Ability)ModAbilities.registry.get(ResourceLocation.parse((String)ability))).getType() != Ability.AbilityType.GROWTH) {
            return amount + (this.abilityMap.containsKey(ability) ? Integer.bitCount(this.abilityMap.get(ability)[1]) : 0);
        }
        return this.abilityMap.containsKey(ability) ? this.abilityMap.get(ability)[1] : 0;
    }

    public boolean isAbilityEquipped(String ability, int index) {
        int indexConvert = (int)Math.pow(2.0, index);
        if (this.abilityMap.containsKey(ability)) {
            if (this.abilityMap.get(ability)[0] < index) {
                return false;
            }
            return (this.abilityMap.get(ability)[1] & indexConvert) == indexConvert;
        }
        return false;
    }

    public void equipAbilityToggle(String ability, int index) {
        int indexConvert = (int)Math.pow(2.0, index);
        if (this.abilityMap.containsKey(ability) && this.abilityMap.get(ability)[0] >= index) {
            int[] nArray = this.abilityMap.get(ability);
            nArray[1] = nArray[1] ^ indexConvert;
        }
    }

    public void equipAbility(String ability, int index) {
        int indexConvert = (int)Math.pow(2.0, index);
        if (this.abilityMap.containsKey(ability) && this.abilityMap.get(ability)[0] >= index) {
            int[] nArray = this.abilityMap.get(ability);
            nArray[1] = nArray[1] | indexConvert;
        }
    }

    public void unequipAbility(String ability, int index) {
        int indexConvert = (int)Math.pow(2.0, index);
        if (this.abilityMap.containsKey(ability) && this.abilityMap.get(ability)[0] >= indexConvert) {
            int[] nArray = this.abilityMap.get(ability);
            nArray[1] = nArray[1] & ~indexConvert;
        }
    }

    public void addEquippedAbilityLevel(String ability, int level) {
        this.abilityMap.put(ability, new int[]{this.abilityMap.get(ability)[0], this.abilityMap.get(ability)[1] + level});
    }

    public int getAbilityQuantity(String ability) {
        if (((Ability)ModAbilities.registry.get(ResourceLocation.parse((String)ability))).getType() != Ability.AbilityType.GROWTH) {
            return this.abilityMap.get(ability)[0] + 1;
        }
        return 1;
    }

    public void clearAbilities() {
        this.abilityMap.clear();
    }

    public List<String> getPartiesInvited() {
        return this.partyList;
    }

    public void setPartiesInvited(List<String> list) {
        this.partyList = list;
    }

    public void addPartiesInvited(String partyName) {
        this.partyList.add(partyName);
    }

    public void removePartiesInvited(String partyName) {
        this.partyList.remove(partyName);
    }

    public List<ResourceLocation> getKnownRecipeList() {
        return this.recipeList;
    }

    public void setKnownRecipeList(List<ResourceLocation> list) {
        this.recipeList = list;
    }

    public boolean hasKnownRecipe(ResourceLocation recipe) {
        return this.recipeList.contains(recipe);
    }

    public void addKnownRecipe(ResourceLocation recipe) {
        if (!this.recipeList.contains(recipe)) {
            this.recipeList.add(recipe);
            Collections.sort(this.recipeList);
        }
    }

    public void removeKnownRecipe(ResourceLocation recipe) {
        if (this.recipeList.contains(recipe)) {
            this.recipeList.remove(recipe);
            Collections.sort(this.recipeList);
        }
    }

    public void clearRecipes(String type) {
        switch (type) {
            case "all": {
                this.recipeList.clear();
                break;
            }
            case "keyblade": {
                ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
                for (ResourceLocation rl : this.recipeList) {
                    Recipe r = RecipeRegistry.getInstance().getValue(rl);
                    if (!r.getType().equals("keyblade")) continue;
                    list.add(rl);
                }
                this.recipeList.removeAll(list);
                break;
            }
            case "item": {
                ArrayList<ResourceLocation> list2 = new ArrayList<ResourceLocation>();
                for (ResourceLocation rl : this.recipeList) {
                    Recipe r = RecipeRegistry.getInstance().getValue(rl);
                    if (!r.getType().equals("item")) continue;
                    list2.add(rl);
                }
                this.recipeList.removeAll(list2);
            }
        }
    }

    public TreeMap<ResourceLocation, Integer> getMaterialMap() {
        return this.materials;
    }

    public void setMaterialMap(TreeMap<ResourceLocation, Integer> materialMap) {
        this.materials = materialMap;
    }

    public int getMaterialAmount(Item material) {
        ResourceLocation regName = BuiltInRegistries.ITEM.getKey((Object)material);
        if (this.materials.containsKey(regName)) {
            return this.materials.get(regName);
        }
        return 0;
    }

    public void addMaterial(Item material, int amount) {
        ResourceLocation regName = BuiltInRegistries.ITEM.getKey((Object)material);
        if (this.materials.containsKey(regName)) {
            int currAmount = this.materials.get(regName);
            if (amount <= 0) {
                this.materials.remove(regName);
            } else {
                this.materials.replace(regName, currAmount + amount);
            }
        } else if (amount <= 0) {
            this.materials.remove(regName);
        } else {
            this.materials.put(regName, amount);
        }
    }

    public void setMaterial(Item material, int amount) {
        ResourceLocation regName = BuiltInRegistries.ITEM.getKey((Object)material);
        if (this.materials.containsKey(regName)) {
            if (amount <= 0) {
                this.materials.remove(regName);
            } else {
                this.materials.replace(regName, amount);
            }
        } else if (amount <= 0) {
            this.materials.remove(regName);
        } else {
            this.materials.put(regName, amount);
        }
    }

    public void removeMaterial(Item material, int amount) {
        ResourceLocation regName = BuiltInRegistries.ITEM.getKey((Object)material);
        if (this.materials.containsKey(regName)) {
            int currAmount = this.materials.get(regName);
            if (amount > currAmount) {
                amount = currAmount;
            }
            this.materials.replace(regName, currAmount - amount);
            if (this.materials.get(regName) <= 0) {
                this.materials.remove(regName);
            }
        }
    }

    public void clearMaterials() {
        this.materials.clear();
    }

    public Vec3 getReturnLocation() {
        return this.returnPos;
    }

    public void setReturnLocation(Player playerEntity) {
        this.setReturnLocation(playerEntity.position());
    }

    public void setReturnLocation(Vec3 location) {
        this.returnPos = location;
    }

    public ResourceKey<Level> getReturnDimension() {
        return this.returnDim;
    }

    public void setReturnDimension(Player playerEntity) {
        this.setReturnDimension((ResourceKey<Level>)playerEntity.level().dimension());
    }

    public void setReturnDimension(ResourceKey<Level> type) {
        this.returnDim = type;
    }

    public SoAState getSoAState() {
        return this.soAState;
    }

    public void setSoAState(SoAState state) {
        this.soAState = state;
    }

    public SoAState getChosen() {
        return this.choice;
    }

    public void setChoice(SoAState choice) {
        this.choice = choice;
    }

    public SoAState getSacrificed() {
        return this.sacrifice;
    }

    public void setSacrifice(SoAState sacrifice) {
        this.sacrifice = sacrifice;
    }

    public BlockPos getChoicePedestal() {
        return this.choicePedestal;
    }

    public void setChoicePedestal(BlockPos pos) {
        this.choicePedestal = pos;
    }

    public BlockPos getSacrificePedestal() {
        return this.sacrificePedestal;
    }

    public void setSacrificePedestal(BlockPos pos) {
        this.sacrificePedestal = pos;
    }

    public String getEquippedShotlock() {
        return this.equippedShotlock;
    }

    public void setEquippedShotlock(String shotlock) {
        this.equippedShotlock = shotlock;
    }

    public void setMagicCasttimeTicks(int ticks) {
        this.magicCasttime = ticks;
    }

    public void remMagicCasttimeTicks(int ticks) {
        this.magicCasttime = Math.max(this.magicCasttime - ticks, 0);
    }

    public int getMagicCasttimeTicks() {
        return this.magicCasttime;
    }

    public void setMagicCooldownTicks(int ticks) {
        this.magicCooldown = ticks;
    }

    public void remMagicCooldownTicks(int ticks) {
        this.magicCooldown = Math.max(this.magicCooldown - ticks, 0);
    }

    public int getMagicCooldownTicks() {
        return this.magicCooldown;
    }

    public List<String> getReactionCommands() {
        return this.reactionList;
    }

    public void setReactionCommands(List<String> list) {
        this.reactionList = list;
    }

    public boolean addReactionCommand(String command, Player player) {
        if (this.reactionList.contains(command)) {
            return false;
        }
        if (((ReactionCommand)ModReactionCommands.registry.get(ResourceLocation.parse((String)command))).conditionsToAppear(player, (LivingEntity)player)) {
            this.reactionList.add(command);
            return true;
        }
        return false;
    }

    public boolean removeReactionCommand(String command) {
        if (this.reactionList.contains(command)) {
            this.reactionList.remove(command);
            return true;
        }
        return false;
    }

    public LinkedHashMap<Integer, String> getShortcutsMap() {
        return this.shortcutsMap;
    }

    public void setShortcutsMap(LinkedHashMap<Integer, String> map) {
        this.shortcutsMap = map;
    }

    public void changeShortcut(int position, String name, int level) {
        this.shortcutsMap.put(position, name + "," + level);
    }

    public void removeShortcut(int position) {
        this.shortcutsMap.remove(position);
    }

    public int getSynthLevel() {
        return this.synthLevel;
    }

    public void setSynthLevel(int level) {
        this.synthLevel = level;
    }

    public int getSynthExperience() {
        return this.synthExp;
    }

    public void setSynthExperience(int exp) {
        this.synthExp = exp;
    }

    public void addSynthExperience(int exp) {
        if (this.synthLevel < 7) {
            this.synthExp += exp;
            while (this.getSynthExpNeeded(this.getSynthLevel(), this.synthExp) <= 0 && this.getSynthLevel() <= 7) {
                this.setSynthLevel(this.getSynthLevel() + 1);
            }
        }
    }

    public int getSynthExpNeeded(int level, int currentExp) {
        if (level > 7) {
            return 0;
        }
        double nextLevel = ((double)level + 300.0 * Math.pow(2.0, (double)level / 8.0)) * ((double)level * 0.25);
        this.remainingSynthExp = (int)nextLevel - currentExp;
        return this.remainingSynthExp;
    }

    public boolean getRespawnROD() {
        return this.respawnROD;
    }

    public void setRespawnROD(boolean respawn) {
        this.respawnROD = respawn;
    }

    public SingleChoices getSingleStyle() {
        return this.singleStyle;
    }

    public void setSingleStyle(SingleChoices singleStyle) {
        this.singleStyle = singleStyle;
    }

    public DualChoices getDualStyle() {
        return this.dualStyle;
    }

    public void setDualStyle(DualChoices dualStyle) {
        this.dualStyle = dualStyle;
    }

    public int getMaxAccessories() {
        return this.maxAccessories;
    }

    public void setMaxAccessories(int num) {
        this.maxAccessories = num;
    }

    public void addMaxAccessories(int num) {
        this.maxAccessories += num;
        this.messages.add("C_stats.levelUpMaxAccessories");
    }

    public int getMaxArmors() {
        return this.maxArmors;
    }

    public void setMaxArmors(int num) {
        this.maxArmors = num;
    }

    public void addMaxArmors(int num) {
        this.maxArmors += num;
        this.messages.add("R_stats.levelUpMaxArmors");
    }

    public void setCastedMagic(Utils.castMagic castMagic2) {
        this.castMagic = castMagic2;
        if (castMagic2 != null) {
            this.magicCasttime = castMagic2.magic().getCasttimeTicks(castMagic2.level());
        }
    }

    public BlockPos getAirStep() {
        return this.airStepPos;
    }

    public void setAirStep(BlockPos pos) {
        this.airStepPos = pos;
    }

    public Map<UUID, Instant> discoveredSavePoints() {
        return this.discoveredSavePoints;
    }

    public void addDiscoveredSavePoint(UUID id, Instant time) {
        this.discoveredSavePoints.put(id, time);
    }

    public void setDiscoveredSavePoints(Map<UUID, Instant> list) {
        this.discoveredSavePoints = list;
    }

    public Utils.castMagic getCastedMagic() {
        return this.castMagic;
    }

    public void setSynthesisedRecipes(Set<String> synthesisedRecipes) {
        this.synthesisedRecipes = synthesisedRecipes;
    }

    public void addSynthesisedRecipe(String recipe) {
        if (RecipeRegistry.getInstance().containsKey(ResourceLocation.parse((String)recipe))) {
            this.synthesisedRecipes.add(recipe);
        } else {
            KingdomKeys.LOGGER.warn("Recipe does not exist");
        }
    }

    public Set<String> getSynthesisedRecipes() {
        return this.synthesisedRecipes;
    }
}

