/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.saveddata.SavedData;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.lib.PortalData;
import online.kingdomkeys.kingdomkeys.lib.Struggle;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class WorldData
extends SavedData {
    private static WorldData clientCache = new WorldData();
    private List<Party> parties = new ArrayList<Party>();
    private List<Struggle> struggles = new ArrayList<Struggle>();
    int heartlessSpawnLevel = 0;
    Map<UUID, PortalData> portals = new HashMap<UUID, PortalData>();

    private WorldData() {
    }

    private static WorldData create() {
        return new WorldData();
    }

    public CompoundTag save(CompoundTag storage, HolderLookup.Provider pRegistries) {
        storage.putInt("heartless", this.getHeartlessSpawnLevel());
        ListTag parties = new ListTag();
        ArrayList<String> partyNames = new ArrayList<String>();
        int dupeCount = 0;
        for (Party party : this.getParties()) {
            if (partyNames.contains(party.getName())) {
                ++dupeCount;
                continue;
            }
            partyNames.add(party.getName());
            parties.add((Object)party.write());
        }
        if (dupeCount > 0) {
            KingdomKeys.LOGGER.warn("Discarded {} duplicate parties while writing", (Object)dupeCount);
        }
        storage.put("parties", (Tag)parties);
        ListTag portals = new ListTag();
        for (Map.Entry<UUID, PortalData> entry : this.getPortals().entrySet()) {
            portals.add((Object)entry.getValue().write());
        }
        storage.put("portals", (Tag)portals);
        ListTag listTag = new ListTag();
        ArrayList<String> arrayList = new ArrayList<String>();
        int struggleDupeCount = 0;
        for (Struggle struggle : this.getStruggles()) {
            if (arrayList.contains(struggle.getName())) {
                ++struggleDupeCount;
                continue;
            }
            arrayList.add(struggle.getName());
            listTag.add((Object)struggle.write());
        }
        if (struggleDupeCount > 0) {
            KingdomKeys.LOGGER.warn("Discarded {} duplicate struggles while writing", (Object)struggleDupeCount);
        }
        storage.put("struggles", (Tag)listTag);
        return storage;
    }

    public static WorldData load(CompoundTag nbt, HolderLookup.Provider provider) {
        WorldData data = WorldData.create();
        data.setHeartlessSpawnLevel(nbt.getInt("heartless"));
        List<Party> partiesList = data.getParties();
        ArrayList<String> partyNames = new ArrayList<String>();
        int dupeCount = 0;
        ListTag parties = nbt.getList("parties", 10);
        for (int i = 0; i < parties.size(); ++i) {
            CompoundTag partyNBT = parties.getCompound(i);
            Party party = new Party();
            party.read(partyNBT);
            if (partyNames.contains(party.getName())) {
                ++dupeCount;
                continue;
            }
            partyNames.add(party.getName());
            partiesList.add(party);
        }
        if (dupeCount > 0) {
            KingdomKeys.LOGGER.warn("Discarded {} duplicate parties while reading", (Object)dupeCount);
        }
        data.setParties(partiesList);
        Map<UUID, PortalData> portalList = data.getPortals();
        ListTag portals = nbt.getList("portals", 10);
        for (int i = 0; i < portals.size(); ++i) {
            CompoundTag portalNBT = portals.getCompound(i);
            PortalData portal = new PortalData(null, null, 0.0, 0.0, 0.0, null, null);
            portal.read(portalNBT);
            portalList.put(portal.getUUID(), portal);
        }
        data.setPortals(portalList);
        List<Struggle> strugglesList = data.getStruggles();
        ArrayList<String> struggleNames = new ArrayList<String>();
        int struggleDupeCount = 0;
        ListTag struggles = nbt.getList("struggles", 10);
        for (int i = 0; i < struggles.size(); ++i) {
            CompoundTag struggleNBT = struggles.getCompound(i);
            Struggle struggle = new Struggle();
            struggle.read(struggleNBT);
            if (struggleNames.contains(struggle.getName())) {
                ++struggleDupeCount;
                continue;
            }
            struggleNames.add(struggle.getName());
            strugglesList.add(struggle);
        }
        if (struggleDupeCount > 0) {
            KingdomKeys.LOGGER.warn("Discarded {} duplicate struggles while reading", (Object)struggleDupeCount);
        }
        data.setParties(partiesList);
        return data;
    }

    public static WorldData get(MinecraftServer server) {
        if (server == null) {
            return WorldData.getClient();
        }
        return (WorldData)server.overworld().getDataStorage().computeIfAbsent(new SavedData.Factory(WorldData::create, WorldData::load), "kingdomkeys_data");
    }

    public static WorldData getClient() {
        return clientCache;
    }

    public static void setClientCache(WorldData data) {
        clientCache = data;
    }

    public Map<UUID, PortalData> getPortals() {
        return this.portals;
    }

    public void setPortals(Map<UUID, PortalData> portals) {
        this.portals = portals;
        this.setDirty();
    }

    public void addPortal(UUID uuid, PortalData data) {
        this.portals.put(uuid, data);
        this.setDirty();
    }

    public boolean removePortal(UUID id) {
        if (this.portals.containsKey(id)) {
            this.portals.remove(id);
            this.setDirty();
            return true;
        }
        return false;
    }

    public PortalData getPortalFromUUID(UUID uuid) {
        return this.portals.getOrDefault(uuid, null);
    }

    public UUID getOwnerIDFromUUID(UUID portalUUID) {
        for (Map.Entry<UUID, PortalData> p : this.portals.entrySet()) {
            if (!p.getValue().getUUID().equals(portalUUID)) continue;
            return p.getValue().getOwnerID();
        }
        return null;
    }

    public List<UUID> getAllPortalsFromOwnerID(UUID ownerID) {
        ArrayList<UUID> portals = new ArrayList<UUID>();
        for (Map.Entry<UUID, PortalData> p : this.getPortals().entrySet()) {
            if (!p.getValue().getOwnerID().equals(ownerID)) continue;
            portals.add(p.getValue().getUUID());
        }
        return portals;
    }

    public int getHeartlessSpawnLevel() {
        return this.heartlessSpawnLevel;
    }

    public void setHeartlessSpawnLevel(int level) {
        this.heartlessSpawnLevel = level;
        this.setDirty();
    }

    public void setParties(List<Party> list) {
        this.parties = list;
        this.setDirty();
    }

    public List<Party> getParties() {
        return this.parties;
    }

    @Nullable
    public Party getPartyFromMember(UUID memId) {
        for (Party party : this.parties) {
            for (Party.Member member : party.getMembers()) {
                if (!member.getUUID().equals(memId)) continue;
                return party;
            }
        }
        return null;
    }

    @Nullable
    public Party getPartyFromName(String name) {
        for (Party party : this.parties) {
            if (!party.getName().equalsIgnoreCase(name)) continue;
            return party;
        }
        return null;
    }

    public void removeParty(Party party) {
        String key = Utils.getResourceName(party.getName());
        int pos = -1;
        for (int i = 0; i < this.parties.size(); ++i) {
            if (!Utils.getResourceName(this.parties.get(i).getName()).equalsIgnoreCase(key)) continue;
            pos = i;
            break;
        }
        if (pos > -1) {
            this.parties.remove(pos);
        }
        this.setDirty();
    }

    public void addParty(Party party) {
        String key = Utils.getResourceName(party.getName());
        boolean found = false;
        for (Party p : this.parties) {
            if (!Utils.getResourceName(p.getName()).equalsIgnoreCase(key)) continue;
            found = true;
        }
        if (!found) {
            this.parties.add(party);
        }
        this.setDirty();
    }

    public void removeLeaderMember(Party party, LivingEntity entity) {
        party.removeMember(entity.getUUID());
        this.setDirty();
    }

    public void addPartyMember(Party party, LivingEntity entity) {
        party.addMember(entity);
        this.setDirty();
    }

    public void setStruggles(List<Struggle> list) {
        this.struggles = list;
        this.setDirty();
    }

    public List<Struggle> getStruggles() {
        return this.struggles;
    }

    public Struggle getStruggleFromParticipant(UUID memId) {
        for (Struggle struggle : this.struggles) {
            for (Struggle.Participant participant : struggle.getParticipants()) {
                if (!participant.getUUID().equals(memId)) continue;
                return struggle;
            }
        }
        return null;
    }

    public void addStruggleParticipant(Struggle struggle, LivingEntity entity) {
        struggle.addParticipant(entity);
        this.setDirty();
    }

    public void addStruggle(Struggle struggle) {
        String key = Utils.getResourceName(struggle.getName());
        boolean found = false;
        for (Struggle p : this.struggles) {
            if (!Utils.getResourceName(p.getName()).equalsIgnoreCase(key)) continue;
            found = true;
        }
        if (!found) {
            this.struggles.add(struggle);
        }
        this.setDirty();
    }

    public void removeStruggle(Struggle struggle) {
        String key = Utils.getResourceName(struggle.getName());
        int pos = -1;
        for (int i = 0; i < this.struggles.size(); ++i) {
            if (!Utils.getResourceName(this.struggles.get(i).getName()).equalsIgnoreCase(key)) continue;
            pos = i;
            break;
        }
        if (pos > -1) {
            this.struggles.remove(pos);
        }
        this.setDirty();
    }

    public Struggle getStruggleFromName(String name) {
        for (Struggle struggle : this.struggles) {
            if (!struggle.getName().equalsIgnoreCase(name)) continue;
            return struggle;
        }
        return null;
    }

    public Struggle getStruggleFromBlockPos(BlockPos boardPos) {
        for (Struggle struggle : this.struggles) {
            if (!struggle.getPos().equals((Object)boardPos)) continue;
            return struggle;
        }
        return null;
    }
}

