/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.datagen;

import java.util.Set;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import online.kingdomkeys.kingdomkeys.damagesource.KKDamageTypes;
import online.kingdomkeys.kingdomkeys.datagen.init.AtlasProvider;
import online.kingdomkeys.kingdomkeys.datagen.init.BlockModels;
import online.kingdomkeys.kingdomkeys.datagen.init.BlockStates;
import online.kingdomkeys.kingdomkeys.datagen.init.BlockTagsGen;
import online.kingdomkeys.kingdomkeys.datagen.init.ItemModels;
import online.kingdomkeys.kingdomkeys.datagen.init.ItemTagsGen;
import online.kingdomkeys.kingdomkeys.datagen.init.KeybladeStats;
import online.kingdomkeys.kingdomkeys.datagen.init.LanguageENGB;
import online.kingdomkeys.kingdomkeys.datagen.init.LanguageENUS;
import online.kingdomkeys.kingdomkeys.datagen.init.LanguageESES;
import online.kingdomkeys.kingdomkeys.datagen.init.Recipes;
import online.kingdomkeys.kingdomkeys.datagen.init.Sounds;
import online.kingdomkeys.kingdomkeys.datagen.init.SynthesisRecipe;
import online.kingdomkeys.kingdomkeys.datagen.provider.BaseLootTableProvider;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class DataGeneration {
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.DAMAGE_TYPE, KKDamageTypes::bootstrap);

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(output, event.getLookupProvider(), BUILDER, Set.of("kingdomkeys")));
        BlockTagsGen blockTags = new BlockTagsGen(generator, event.getLookupProvider(), existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagsGen(generator.getPackOutput(), event.getLookupProvider(), blockTags.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new Recipes(generator, event.getLookupProvider()));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStates(generator, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModels(generator, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new AtlasProvider(generator, event.getLookupProvider(), existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockModels(generator, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new KeybladeStats(generator, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new BaseLootTableProvider(output, event.getLookupProvider()));
        generator.addProvider(event.includeServer(), (DataProvider)new SynthesisRecipe(generator, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new LanguageENUS(generator));
        generator.addProvider(event.includeClient(), (DataProvider)new LanguageESES(generator));
        generator.addProvider(event.includeClient(), (DataProvider)new LanguageENGB(generator));
        generator.addProvider(event.includeClient(), (DataProvider)new Sounds(generator, existingFileHelper));
    }
}

