/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.datagen.init;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import online.kingdomkeys.kingdomkeys.block.GhostBloxBlock;
import online.kingdomkeys.kingdomkeys.block.INoDataGen;
import online.kingdomkeys.kingdomkeys.block.KKOreBlock;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.block.PairBloxBlock;

public class BlockStates
extends BlockStateProvider {
    public BlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen.getPackOutput(), "kingdomkeys", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (DeferredHolder itemRegistryObject : ModBlocks.BLOCKS.getEntries()) {
            Block block = (Block)itemRegistryObject.get();
            String name = Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)block)).getPath();
            if (block instanceof GhostBloxBlock) {
                this.getVariantBuilder(block).forAllStates(state -> {
                    boolean active = (Boolean)state.getValue((Property)GhostBloxBlock.VISIBLE);
                    String modelName = active ? name + "_visible" : name + "_invisible";
                    ConfiguredModel.Builder builder = ConfiguredModel.builder();
                    ModelBuilder blockModel = ((BlockModelBuilder)this.models().withExistingParent(modelName, ResourceLocation.withDefaultNamespace((String)"block/cube_all"))).texture("all", ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)("block/" + modelName)));
                    builder.modelFile((ModelFile)blockModel);
                    if (active) {
                        this.simpleBlockItem(block, (ModelFile)blockModel);
                    }
                    return builder.build();
                });
                continue;
            }
            if (block instanceof PairBloxBlock) {
                this.getVariantBuilder(block).forAllStates(state -> {
                    int pairState = (Integer)state.getValue((Property)PairBloxBlock.PAIR);
                    String modelName = name + "_" + pairState;
                    ConfiguredModel.Builder builder = ConfiguredModel.builder();
                    ModelBuilder blockModel = ((BlockModelBuilder)this.models().withExistingParent(modelName, ResourceLocation.withDefaultNamespace((String)"block/cube_all"))).texture("all", ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)("block/" + modelName)));
                    builder.modelFile((ModelFile)blockModel);
                    if (pairState == 0) {
                        this.simpleBlockItem(block, (ModelFile)blockModel);
                    }
                    return builder.build();
                });
                continue;
            }
            if (block instanceof INoDataGen) continue;
            if (block instanceof KKOreBlock && name.endsWith("_n")) {
                this.simpleNetherOre((Supplier<? extends Block>)itemRegistryObject);
                continue;
            }
            this.simpleBlock((Supplier<? extends Block>)itemRegistryObject);
        }
    }

    public void simpleBlock(Supplier<? extends Block> blockSupplier) {
        this.simpleBlock(blockSupplier.get());
    }

    public void simpleBlock(Block block, ModelFile model) {
        super.simpleBlock(block, model);
        this.simpleBlockItem(block, model);
    }

    public ModelFile netherCubeAll(Block block) {
        ResourceLocation name = BuiltInRegistries.BLOCK.getKey((Object)block);
        return this.models().cubeAll(name.getPath(), ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("block/" + name.getPath() + "ether")));
    }

    public void simpleNetherOre(Supplier<? extends Block> blockSupplier) {
        this.simpleBlock(blockSupplier.get(), this.netherCubeAll(blockSupplier.get()));
    }
}

