/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.datagen.init;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import org.jetbrains.annotations.Nullable;

public class BlockTagsGen
extends BlockTagsProvider {
    public static final TagKey<Block> BLOX = BlockTagsGen.create("kingdomkeys:blox");
    public static final TagKey<Block> BLAZING = BlockTagsGen.create("c:ores/blazing");
    public static final TagKey<Block> SOOTHING = BlockTagsGen.create("c:ores/soothing");
    public static final TagKey<Block> WRITHING = BlockTagsGen.create("c:ores/writhing");
    public static final TagKey<Block> BETWIXT = BlockTagsGen.create("c:ores/betwixt");
    public static final TagKey<Block> WELLSPRING = BlockTagsGen.create("c:ores/wellspring");
    public static final TagKey<Block> FROST = BlockTagsGen.create("c:ores/frost");
    public static final TagKey<Block> LUCID = BlockTagsGen.create("c:ores/lucid");
    public static final TagKey<Block> LIGHTNING = BlockTagsGen.create("c:ores/lightning");
    public static final TagKey<Block> PULSING = BlockTagsGen.create("c:ores/pulsing");
    public static final TagKey<Block> REMEMBRANCE = BlockTagsGen.create("c:ores/remembrance");
    public static final TagKey<Block> HUNGRY = BlockTagsGen.create("c:ores/hungry");
    public static final TagKey<Block> SINISTER = BlockTagsGen.create("c:ores/sinister");
    public static final TagKey<Block> STORMY = BlockTagsGen.create("c:ores/stormy");
    public static final TagKey<Block> TRANQUILITY = BlockTagsGen.create("c:ores/tranquility");
    public static final TagKey<Block> TWILIGHT = BlockTagsGen.create("c:ores/twilight");

    public BlockTagsGen(DataGenerator generator, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), lookupProvider, "kingdomkeys", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider pProvider) {
        this.add((TagKey<Block>)BlockTags.DRAGON_IMMUNE, ModBlocks.metalBlox.get());
        this.add((TagKey<Block>)BlockTags.WITHER_IMMUNE, ModBlocks.metalBlox.get());
        for (DeferredHolder itemRegistryObject : ModBlocks.BLOCKS.getEntries()) {
            Block block = (Block)itemRegistryObject.get();
            String name = Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)block)).getPath();
            if (!(block instanceof Block)) continue;
            if (block == ModBlocks.rodSand.get()) {
                this.add((TagKey<Block>)BlockTags.MINEABLE_WITH_SHOVEL, block);
            } else {
                if (name.contains("blazing")) {
                    this.add(BLAZING, block);
                }
                if (name.contains("soothing")) {
                    this.add(SOOTHING, block);
                }
                if (name.contains("writhing")) {
                    this.add(WRITHING, block);
                }
                if (name.contains("betwixt")) {
                    this.add(BETWIXT, block);
                }
                if (name.contains("wellspring")) {
                    this.add(WELLSPRING, block);
                }
                if (name.contains("frost")) {
                    this.add(FROST, block);
                }
                if (name.contains("lucid")) {
                    this.add(LUCID, block);
                }
                if (name.contains("lightning")) {
                    this.add(LIGHTNING, block);
                }
                if (name.contains("pulsing")) {
                    this.add(PULSING, block);
                }
                if (name.contains("remembrance")) {
                    this.add(REMEMBRANCE, block);
                }
                if (name.contains("hungry")) {
                    this.add(HUNGRY, block);
                }
                if (name.contains("sinister")) {
                    this.add(SINISTER, block);
                }
                if (name.contains("stormy")) {
                    this.add(STORMY, block);
                }
                if (name.contains("tranquility")) {
                    this.add(TRANQUILITY, block);
                }
                if (name.contains("twilight")) {
                    this.add(TWILIGHT, block);
                }
                this.add((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE, block);
                if (name.contains("writhing_ore") || name.contains("betwixt_ore") || name.contains("pulsing_ore") || name.contains("sinister_ore") || name.contains("stormy_ore") || name.contains("twilight_ore")) {
                    this.add((TagKey<Block>)BlockTags.NEEDS_IRON_TOOL, block);
                } else {
                    this.add((TagKey<Block>)BlockTags.NEEDS_STONE_TOOL, block);
                }
            }
            if (block != ModBlocks.normalBlox.get() && block != ModBlocks.hardBlox.get() && block != ModBlocks.metalBlox.get() && block != ModBlocks.dangerBlox.get() && block != ModBlocks.blastBlox.get() && block != ModBlocks.prizeBlox.get() && block != ModBlocks.rarePrizeBlox.get() && block != ModBlocks.pairBlox.get() && block != ModBlocks.ghostBlox.get() && block != ModBlocks.bounceBlox.get() && block != ModBlocks.magnetBlox.get()) continue;
            this.add(BLOX, block);
        }
    }

    public void add(TagKey<Block> branch, Block block) {
        this.tag(branch).add((Object)block);
    }

    public void add(TagKey<Block> branch, Block ... block) {
        this.tag(branch).add((Object[])block);
    }

    private static TagKey<Block> create(String pName) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)pName));
    }
}

