/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.datagen.init;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import online.kingdomkeys.kingdomkeys.item.BaseArmorItem;
import online.kingdomkeys.kingdomkeys.item.DriveFormOrbItem;
import online.kingdomkeys.kingdomkeys.item.KKAccessoryItem;
import online.kingdomkeys.kingdomkeys.item.KKArmorItem;
import online.kingdomkeys.kingdomkeys.item.KKRecordItem;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.item.MagicSpellItem;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.item.PauldronItem;
import online.kingdomkeys.kingdomkeys.item.SynthesisItem;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import org.jetbrains.annotations.Nullable;

public class ItemTagsGen
extends ItemTagsProvider {
    public static final TagKey<Item> KEYBLADES = ItemTagsGen.bind("kingdomkeys:keyblades");
    public static final TagKey<Item> KEYCHAINS = ItemTagsGen.bind("kingdomkeys:keychains");
    public static final TagKey<Item> MAGICS = ItemTagsGen.bind("kingdomkeys:magics");
    public static final TagKey<Item> DRIVES = ItemTagsGen.bind("kingdomkeys:drives");
    public static final TagKey<Item> ORG = ItemTagsGen.bind("kingdomkeys:org_weapons");
    public static final TagKey<Item> PAULDRONS = ItemTagsGen.bind("kingdomkeys:pauldrons");
    public static final TagKey<Item> ACCESSORIES = ItemTagsGen.bind("kingdomkeys:accessories");
    public static final TagKey<Item> ARMORS = ItemTagsGen.bind("kingdomkeys:armors");
    public static final TagKey<Item> MUSIC_DISCS = ItemTagsGen.bind("kingdomkeys:music_discs");
    public static final TagKey<Item> SYNTHESIS_MATERIAL = ItemTagsGen.bind("kingdomkeys:synthesis_material");

    public ItemTagsGen(PackOutput p_255871_, CompletableFuture<HolderLookup.Provider> p_256035_, CompletableFuture<TagsProvider.TagLookup<Block>> p_256467_, @Nullable ExistingFileHelper existingFileHelper) {
        super(p_255871_, p_256035_, p_256467_, "kingdomkeys", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider pProvider) {
        for (DeferredHolder itemRegistryObject : ModItems.ITEMS.getEntries()) {
            Item item = (Item)itemRegistryObject.get();
            if (item instanceof MagicSpellItem) {
                this.add(MAGICS, item);
            }
            if (item instanceof DriveFormOrbItem) {
                this.add(DRIVES, item);
            }
            if (item instanceof BaseArmorItem) {
                BaseArmorItem armor = (BaseArmorItem)item;
                switch (armor.getEquipmentSlot()) {
                    case HEAD: {
                        this.add((TagKey<Item>)ItemTags.HEAD_ARMOR, (Item)armor);
                        break;
                    }
                    case CHEST: {
                        this.add((TagKey<Item>)ItemTags.CHEST_ARMOR, (Item)armor);
                        break;
                    }
                    case LEGS: {
                        this.add((TagKey<Item>)ItemTags.LEG_ARMOR, (Item)armor);
                        break;
                    }
                    case FEET: {
                        this.add((TagKey<Item>)ItemTags.FOOT_ARMOR, (Item)armor);
                    }
                }
            }
            if (item instanceof KeychainItem) {
                this.add(KEYCHAINS, item);
                this.add((TagKey<Item>)ItemTags.SWORD_ENCHANTABLE, item);
                this.add((TagKey<Item>)ItemTags.SHARP_WEAPON_ENCHANTABLE, item);
            }
            if (item instanceof KeybladeItem) {
                this.add(KEYBLADES, item);
                this.add((TagKey<Item>)ItemTags.SWORD_ENCHANTABLE, item);
                this.add((TagKey<Item>)ItemTags.SHARP_WEAPON_ENCHANTABLE, item);
            }
            if (item instanceof IOrgWeapon) {
                this.add(ORG, item);
                this.add((TagKey<Item>)ItemTags.SWORD_ENCHANTABLE, item);
                this.add((TagKey<Item>)ItemTags.SHARP_WEAPON_ENCHANTABLE, item);
            }
            if (item instanceof PauldronItem) {
                this.add(PAULDRONS, item);
            }
            if (item instanceof KKAccessoryItem) {
                this.add(ACCESSORIES, item);
            }
            if (item instanceof KKArmorItem) {
                this.add(ARMORS, item);
            }
            if (item instanceof KKRecordItem) {
                this.add(MUSIC_DISCS, item);
                this.add((TagKey<Item>)ItemTags.CREEPER_DROP_MUSIC_DISCS, item);
            }
            if (!(item instanceof SynthesisItem)) continue;
            this.add(SYNTHESIS_MATERIAL, item);
        }
    }

    public void add(TagKey<Item> branch, Item item) {
        this.tag(branch).add((Object)item);
    }

    public void add(TagKey<Item> branch, Item ... item) {
        this.tag(branch).add((Object[])item);
    }

    private static TagKey<Item> bind(String pName) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)pName));
    }
}

