/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.driveform;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.mob.IKHMob;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSetAerialDodgeTicksPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSSetGlidingPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;

@EventBusSubscriber(modid="kingdomkeys")
public class DriveFormFinal
extends DriveForm {
    public DriveFormFinal(ResourceLocation registryName, int order, ResourceLocation skinRL, boolean hasKeychain, boolean baseGrowth) {
        super(registryName, order, hasKeychain, baseGrowth);
        this.color = new float[]{0.9f, 0.9f, 0.9f};
        this.skinRL = skinRL;
    }

    @SubscribeEvent
    public static void getFinalFormXP(LivingDeathEvent event) {
        Player player;
        PlayerData playerData;
        Entity entity;
        if ((!event.getEntity().level().isClientSide && event.getEntity() instanceof EnderMan || event.getEntity() instanceof IKHMob && ((IKHMob)event.getEntity()).getKHMobType() == EntityHelper.MobType.NOBODY) && (entity = event.getSource().getEntity()) instanceof Player && (playerData = PlayerData.get(player = (Player)entity)) != null && playerData.getActiveDriveForm().equals("kingdomkeys:form_final")) {
            double mult = Double.parseDouble(((String)((List)ModConfigs.SERVER.driveFormXPMultiplier.get()).get(4)).split(",")[1]);
            playerData.setDriveFormExp(player, playerData.getActiveDriveForm(), (int)((double)playerData.getDriveFormExp(playerData.getActiveDriveForm()) + 1.0 * mult));
            PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        PlayerData playerData = PlayerData.get(player);
        if (playerData != null) {
            if (playerData.getDriveFormMap() != null && playerData.getActiveDriveForm().equals("kingdomkeys:form_final")) {
                DriveFormFinal.handleHighJump(player, playerData);
            }
            DriveForm form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)playerData.getActiveDriveForm()));
            if (playerData.getActiveDriveForm().equals("kingdomkeys:form_final") || (playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) || form.getBaseGrowthAbilities()) && playerData.getDriveFormMap().containsKey("kingdomkeys:form_final") && playerData.getDriveFormLevel("kingdomkeys:form_final") >= 3 && playerData.getEquippedAbilityLevel("kingdomkeys:ability_glide") != null && playerData.getEquippedAbilityLevel("kingdomkeys:ability_glide")[1] > 0) {
                DriveFormFinal.handleGlide(player, playerData);
            }
            if (playerData.getIsGliding() && !playerData.isAbilityEquipped("kingdomkeys:ability_glide")) {
                playerData.setIsGliding(false);
            }
        }
    }

    private static void handleHighJump(Player player, PlayerData playerData) {
        boolean j = false;
        if (player.level().isClientSide) {
            j = Minecraft.getInstance().options.keyJump.isDown();
        }
        if (j && player.getDeltaMovement().y > 0.0 && playerData.getActiveDriveForm().equals("kingdomkeys:form_final")) {
            player.setDeltaMovement(player.getDeltaMovement().add(0.0, (double)DriveForm.FINAL_JUMP_BOOST[playerData.getDriveFormLevel("kingdomkeys:form_final")], 0.0));
        }
    }

    private static void handleGlide(Player player, PlayerData playerData) {
        if (player.isInWater() || player.isInLava()) {
            return;
        }
        if (player.level().isClientSide) {
            Minecraft mc = Minecraft.getInstance();
            if (mc.player == player) {
                if (!player.onGround() && player.fallDistance > 0.0f) {
                    if (mc.options.keyJump.isDown()) {
                        if (!(playerData.getIsGliding() || player.level().getBlockState(player.blockPosition()).getBlock() instanceof LiquidBlock || player.level().getBlockState(player.blockPosition().below()).getBlock() instanceof LiquidBlock)) {
                            playerData.setIsGliding(true);
                            playerData.setAerialDodgeTicks(0);
                            PacketHandler.sendToServer(new CSSetGlidingPacket(true));
                            PacketHandler.sendToServer(new CSSetAerialDodgeTicksPacket(true, 0));
                        }
                    } else if (playerData.getIsGliding()) {
                        playerData.setIsGliding(false);
                        PacketHandler.sendToServer(new CSSetGlidingPacket(false));
                    }
                } else if (playerData.getIsGliding()) {
                    playerData.setIsGliding(false);
                    PacketHandler.sendToServer(new CSSetGlidingPacket(false));
                    PacketHandler.sendToServer(new CSSetAerialDodgeTicksPacket(false, 0));
                }
            }
        }
        if (playerData.getIsGliding()) {
            int glideLevel = playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) ? playerData.getDriveFormLevel("kingdomkeys:form_final") - 2 : playerData.getDriveFormLevel("kingdomkeys:form_final");
            float glide = DriveForm.FINAL_GLIDE[glideLevel];
            float limit = DriveForm.FINAL_GLIDE_SPEED[glideLevel];
            float forward = player.zza;
            float strafe = player.xxa;
            float yaw = player.getYRot();
            float rad = (float)Math.toRadians(yaw);
            double sin = Math.sin(rad);
            double cos = Math.cos(rad);
            double moveX = (double)strafe * cos - (double)forward * sin;
            double moveZ = (double)forward * cos + (double)strafe * sin;
            Vec3 current = player.getDeltaMovement();
            double accelFactor = 0.1;
            double xSpeed = current.x + (moveX * (double)limit - current.x) * accelFactor;
            double zSpeed = current.z + (moveZ * (double)limit - current.z) * accelFactor;
            double ySpeed = current.y;
            if (current.y < (double)glide) {
                ySpeed = glide;
            }
            player.setDeltaMovement(new Vec3(xSpeed, ySpeed, zSpeed));
            if (player.getForcedPose() != Pose.SWIMMING) {
                player.setForcedPose(Pose.SWIMMING);
            }
        } else if (player.getForcedPose() == Pose.SWIMMING) {
            player.setForcedPose(null);
        }
    }
}

