/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.driveform;

import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSetAerialDodgeTicksPacket;

@EventBusSubscriber(modid="kingdomkeys")
public class DriveFormMaster
extends DriveForm {
    public DriveFormMaster(ResourceLocation registryName, int order, ResourceLocation skinRL, boolean hasKeychain, boolean baseGrowth) {
        super(registryName, order, hasKeychain, baseGrowth);
        this.color = new float[]{1.0f, 0.7f, 0.1f};
        this.skinRL = skinRL;
    }

    @SubscribeEvent
    public static void onLivingUpdate(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        PlayerData playerData = PlayerData.get(player);
        if (playerData != null) {
            DriveForm form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)playerData.getActiveDriveForm()));
            if (playerData.getActiveDriveForm().equals("kingdomkeys:form_master") || (playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) || form.getBaseGrowthAbilities()) && playerData.getDriveFormMap().containsKey("kingdomkeys:form_master") && playerData.getDriveFormLevel("kingdomkeys:form_master") >= 3 && playerData.getEquippedAbilityLevel("kingdomkeys:ability_aerial_dodge") != null && playerData.getEquippedAbilityLevel("kingdomkeys:ability_aerial_dodge")[1] > 0) {
                DriveFormMaster.handleAerialDodge(player, playerData);
            }
        }
    }

    private static void handleAerialDodge(Player player, PlayerData playerData) {
        if (playerData.getAerialDodgeTicks() <= 0) {
            if (player.onGround()) {
                playerData.setHasJumpedAerialDodge(false);
                playerData.setAerialDodgeTicks(0);
            } else if (player.level().isClientSide && player.getDeltaMovement().y < 0.0 && Minecraft.getInstance().options.keyJump.isDown() && !player.isShiftKeyDown() && !playerData.hasJumpedAerialDodge()) {
                playerData.setHasJumpedAerialDodge(true);
                player.jumpFromGround();
                int jumpLevel = playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) ? playerData.getDriveFormLevel("kingdomkeys:form_master") - 2 : playerData.getDriveFormLevel("kingdomkeys:form_master");
                float boost = DriveForm.MASTER_AERIAL_DODGE_BOOST[jumpLevel];
                player.setDeltaMovement(player.getDeltaMovement().multiply(new Vec3((double)boost, (double)boost, (double)boost)));
                PacketHandler.sendToServer(new CSSetAerialDodgeTicksPacket(true, 10));
            }
        }
    }
}

