/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.driveform;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;

@EventBusSubscriber(modid="kingdomkeys")
public class DriveFormValor
extends DriveForm {
    public DriveFormValor(ResourceLocation registryName, int order, ResourceLocation skinRL, boolean hasKeychain, boolean baseGrowth) {
        super(registryName, order, hasKeychain, baseGrowth);
        this.color = new float[]{1.0f, 0.0f, 0.0f};
        this.skinRL = skinRL;
    }

    @SubscribeEvent
    public static void getValorFormXP(LivingDamageEvent.Post event) {
        Player player;
        PlayerData playerData;
        Entity entity;
        if (!event.getEntity().level().isClientSide && (event.getEntity() instanceof Monster || event.getEntity() instanceof EnderDragon) && (entity = event.getSource().getEntity()) instanceof Player && (playerData = PlayerData.get(player = (Player)entity)) != null && playerData.getActiveDriveForm().equals("kingdomkeys:form_valor")) {
            double mult = Double.parseDouble(((String)((List)ModConfigs.SERVER.driveFormXPMultiplier.get()).get(0)).split(",")[1]);
            playerData.setDriveFormExp(player, playerData.getActiveDriveForm(), (int)((double)playerData.getDriveFormExp(playerData.getActiveDriveForm()) + 1.0 * mult));
            PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        PlayerData playerData = PlayerData.get(player);
        if (playerData != null && DriveFormValor.shouldHandleHighJump(player, playerData)) {
            DriveFormValor.handleHighJump(player, playerData);
        }
    }

    private static boolean shouldHandleHighJump(Player player, PlayerData playerData) {
        if (playerData.getDriveFormMap() == null) {
            return false;
        }
        if (playerData.getActiveDriveForm().equals("kingdomkeys:form_valor") || playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) && playerData.getDriveFormMap().containsKey("kingdomkeys:form_valor") && playerData.getDriveFormLevel("kingdomkeys:form_valor") >= 3 && playerData.getEquippedAbilityLevel("kingdomkeys:ability_high_jump") != null && playerData.getEquippedAbilityLevel("kingdomkeys:ability_high_jump")[1] > 0) {
            return true;
        }
        DriveForm form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)playerData.getActiveDriveForm()));
        return form.getBaseGrowthAbilities() || playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) && playerData.getDriveFormMap().containsKey("kingdomkeys:form_valor") && playerData.getDriveFormLevel("kingdomkeys:form_valor") >= 3 && playerData.getEquippedAbilityLevel("kingdomkeys:ability_high_jump") != null && playerData.getEquippedAbilityLevel("kingdomkeys:ability_high_jump")[1] > 0;
    }

    private static void handleHighJump(Player player, PlayerData playerData) {
        boolean j = false;
        if (player.level().isClientSide) {
            j = Minecraft.getInstance().options.keyJump.isDown();
        }
        if (j && player.getDeltaMovement().y > 0.0) {
            DriveForm form = (DriveForm)ModDriveForms.registry.get(ResourceLocation.parse((String)playerData.getActiveDriveForm()));
            if (playerData.getActiveDriveForm().equals("kingdomkeys:form_valor")) {
                player.setDeltaMovement(player.getDeltaMovement().add(0.0, (double)DriveForm.VALOR_JUMP_BOOST[playerData.getDriveFormLevel("kingdomkeys:form_valor")], 0.0));
            } else if (playerData.getActiveDriveForm() != null) {
                int jumpLevel;
                int n = jumpLevel = playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) || form.getBaseGrowthAbilities() ? playerData.getDriveFormLevel("kingdomkeys:form_valor") - 2 : playerData.getDriveFormLevel("kingdomkeys:form_valor");
                if (jumpLevel > -1) {
                    player.setDeltaMovement(player.getDeltaMovement().add(0.0, (double)DriveForm.VALOR_JUMP_BOOST[jumpLevel], 0.0));
                }
            }
        }
    }
}

