/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.effects;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.WhiteMushroomEntity;

public class FreezeEffect
extends MobEffect {
    public FreezeEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public boolean applyEffectTick(LivingEntity pLivingEntity, int pAmplifier) {
        super.applyEffectTick(pLivingEntity, pAmplifier);
        if (pLivingEntity instanceof WhiteMushroomEntity) {
            return false;
        }
        pLivingEntity.setIsInPowderSnow(true);
        if (pLivingEntity.getRandom().nextInt(10) < 2) {
            double d0 = pLivingEntity.getX() + 0.5 + pLivingEntity.getRandom().nextDouble() * 3.0 / 16.0;
            double d1 = pLivingEntity.getY() + 1.0;
            double d2 = pLivingEntity.getZ() + 0.5 + pLivingEntity.getRandom().nextDouble() / 16.0;
            double d4 = pLivingEntity.getRandom().nextDouble() * 0.6 - 0.3;
            double d5 = pLivingEntity.getRandom().nextDouble() * 0.6 - 0.3;
            if (pLivingEntity.level().isClientSide) {
                pLivingEntity.level().addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, d0 + d5, d1, d2 + d4, 0.0, 0.05, 0.0);
            } else {
                ServerLevel serverLevel = (ServerLevel)pLivingEntity.level();
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SNOWFLAKE, pLivingEntity.getX() + pLivingEntity.getRandom().nextDouble() * 0.5, d1, pLivingEntity.getZ() + pLivingEntity.getRandom().nextDouble() * 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

