/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity;

import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;

public class EntityHelper {
    public static Dir get8Directions(Entity e) {
        return switch (Mth.floor((double)((double)(e.getYRot() * 8.0f / 360.0f) + 0.5)) & 7) {
            case 0 -> Dir.SOUTH;
            case 1 -> Dir.SOUTH_WEST;
            case 2 -> Dir.WEST;
            case 3 -> Dir.NORTH_WEST;
            case 4 -> Dir.NORTH;
            case 5 -> Dir.NORTH_EAST;
            case 6 -> Dir.EAST;
            case 7 -> Dir.SOUTH_EAST;
            default -> null;
        };
    }

    public static double[] generateAnimationArray(double startPos, double minPos, double maxPos, double frameSkip, int framesPerSlot) {
        double i;
        int framesCount = 0;
        double currentFrame = startPos;
        boolean hasReachedMaxPos = false;
        boolean hasReachedMinPos = false;
        for (i = startPos; i <= maxPos; i += frameSkip) {
            ++framesCount;
        }
        for (i = maxPos; i > minPos; i -= frameSkip) {
            ++framesCount;
        }
        for (i = minPos; i <= startPos; i += frameSkip) {
            ++framesCount;
        }
        framesCount *= framesPerSlot;
        double[] animation = new double[framesCount -= framesPerSlot];
        for (int j = 0; j < framesCount; ++j) {
            for (int i2 = 0; i2 < framesPerSlot; ++i2) {
                if (j + 1 >= framesCount) continue;
                if (i2 > 0) {
                    ++j;
                }
                animation[j] = currentFrame;
            }
            if (!hasReachedMaxPos && currentFrame < maxPos) {
                currentFrame += frameSkip;
            } else if (!hasReachedMinPos && hasReachedMaxPos && currentFrame > minPos) {
                currentFrame -= frameSkip;
            } else if (hasReachedMinPos && currentFrame < startPos) {
                currentFrame += frameSkip;
            }
            if (currentFrame >= maxPos) {
                hasReachedMaxPos = true;
            }
            if (!(currentFrame <= minPos)) continue;
            hasReachedMinPos = true;
        }
        return animation;
    }

    public static List<LivingEntity> getEntitiesNear(Entity e, double radius) {
        AABB aabb = new AABB(e.getX(), e.getY(), e.getZ(), e.getX() + 1.0, e.getY() + 1.0, e.getZ() + 1.0).inflate(radius, radius, radius);
        List list = e.level().getEntitiesOfClass(LivingEntity.class, aabb);
        list.remove(e);
        return list;
    }

    public static enum Dir {
        SOUTH,
        SOUTH_EAST,
        EAST,
        NORTH,
        NORTH_EAST,
        NORTH_WEST,
        WEST,
        SOUTH_WEST;

    }

    public static enum MobType {
        HEARTLESS_PUREBLOOD,
        HEARTLESS_EMBLEM,
        NOBODY,
        NPC,
        BOSS;

    }
}

