/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;

public class GummiShipEntity
extends Entity {
    public static final int MAX_TICKS = 30;
    private String data;
    private static final EntityDataAccessor<String> DATA = SynchedEntityData.defineId(GummiShipEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public GummiShipEntity(EntityType<? extends Entity> type, Level world) {
        super(ModEntities.TYPE_GUMMI_SHIP.get(), world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(DATA, (Object)"");
    }

    public GummiShipEntity(Level world) {
        super(ModEntities.TYPE_GUMMI_SHIP.get(), world);
    }

    public void tick() {
        super.tick();
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createLivingAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, 1000.0).add(Attributes.FOLLOW_RANGE, 0.0).add(Attributes.ATTACK_DAMAGE, 0.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String name) {
        this.entityData.set(DATA, (Object)name);
        this.data = name;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals(DATA)) {
            this.data = this.getDataDataManager();
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putString("Data", this.getData());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.setData(compound.getString("Data"));
    }

    public String getDataDataManager() {
        return (String)this.entityData.get(DATA);
    }
}

