/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import online.kingdomkeys.kingdomkeys.block.CardDoorBlock;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.DoorData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomData;
import online.kingdomkeys.kingdomkeys.world.dimension.castle_oblivion.system.room.RoomDirection;

public class CardDoorTileEntity
extends BlockEntity {
    boolean open = false;
    BlockPos destination;
    RoomData parent;
    RoomData destinationRoom;
    RoomDirection direction;
    DoorData data;

    public CardDoorTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(ModEntities.TYPE_CARD_DOOR.get(), pWorldPosition, pBlockState);
    }

    public void openDoor(boolean setBlock) {
        this.open = true;
        if (setBlock) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)CardDoorBlock.OPEN, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setParent(RoomData room) {
        this.parent = room;
    }

    public RoomData getParentRoom() {
        return this.parent;
    }

    public RoomData getDestinationRoom() {
        return this.destinationRoom;
    }

    public void setDestinationRoom(RoomData destinationRoom) {
        this.destinationRoom = destinationRoom;
    }

    public void setDirection(RoomDirection direction) {
        this.direction = direction;
    }

    public RoomDirection getDirection() {
        return this.direction;
    }

    public DoorData getData() {
        return this.data;
    }

    public void setData(DoorData data) {
        this.data = data;
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider provider) {
        super.loadAdditional(pTag, provider);
        if (pTag.contains("parent")) {
            this.parent = new RoomData(pTag.getCompound("parent"));
            this.direction = RoomDirection.values()[pTag.getInt("direction")];
        }
        if (pTag.contains("destination_room")) {
            this.destinationRoom = new RoomData(pTag.getCompound("destination_room"));
        }
        this.open = pTag.getBoolean("open");
        this.destination = this.open && pTag.contains("destination") ? (BlockPos)NbtUtils.readBlockPos((CompoundTag)pTag.getCompound("destination"), (String)"destination").get() : null;
        if (pTag.contains("door_data")) {
            this.data = new DoorData(pTag.getCompound("door_data"));
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider provider) {
        super.saveAdditional(pTag, provider);
        if (this.parent != null) {
            pTag.put("parent", (Tag)this.parent.serializeNBT());
            pTag.putInt("direction", this.direction.ordinal());
        }
        if (this.destinationRoom != null) {
            pTag.put("destination_room", (Tag)this.destinationRoom.serializeNBT());
        }
        pTag.putBoolean("open", this.open);
        if (this.open && this.destination != null) {
            pTag.put("destination", NbtUtils.writeBlockPos((BlockPos)this.destination));
        }
        if (this.data != null) {
            pTag.put("door_data", (Tag)this.data.serializeNBT());
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveCustomOnly(pRegistries);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }
}

