/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import online.kingdomkeys.kingdomkeys.block.GummiEditorBlock;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.menu.GummiEditorMenu;
import org.joml.Vector3f;

public class GummiEditorTileEntity
extends BlockEntity
implements MenuProvider {
    public static final int NUMBER_OF_SLOTS = 1;
    private final ItemStackHandler itemStackHandler = this.createInventory();
    public final Lazy<IItemHandler> inventory = Lazy.of(() -> this.itemStackHandler);
    private ItemStack displayStack = ItemStack.EMPTY;
    private int ticksExisted;
    public int previousTicks;
    int ticks = 0;

    public GummiEditorTileEntity(BlockPos pos, BlockState state) {
        super(ModEntities.TYPE_GUMMI_EDITOR.get(), pos, state);
    }

    private ItemStackHandler createInventory() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            protected void onContentsChanged(int slot) {
                GummiEditorTileEntity.this.setChanged();
                GummiEditorTileEntity.this.level.sendBlockUpdated(GummiEditorTileEntity.this.worldPosition, GummiEditorTileEntity.this.getBlockState(), GummiEditorTileEntity.this.getBlockState(), 3);
                super.onContentsChanged(slot);
            }
        };
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        CompoundTag invCompound = compound.getCompound("inv");
        this.itemStackHandler.deserializeNBT(provider, invCompound);
        this.displayStack = (ItemStack)ItemStack.parse((HolderLookup.Provider)provider, (Tag)compound.getCompound("display_stack")).get();
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.put("inv", (Tag)this.itemStackHandler.serializeNBT(provider));
        compound.put("display_stack", this.displayStack.save(provider));
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.gummi_editor");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowID, Inventory playerInventory, Player playerEntity) {
        return new GummiEditorMenu(windowID, playerInventory, this);
    }

    public ItemStack getDisplayStack() {
        return this.displayStack;
    }

    public void setDisplayStack(ItemStack displayStack) {
        this.displayStack = displayStack;
        this.setChanged();
    }

    public int ticksExisted() {
        return this.ticksExisted;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, pRegistries);
        return tag;
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        GummiEditorTileEntity TE = (GummiEditorTileEntity)((Object)blockEntity);
        Direction facing = (Direction)state.getValue((Property)GummiEditorBlock.FACING);
        ++TE.ticks;
        for (int x = 0; x < 7; ++x) {
            for (int y = 0; y < 7; ++y) {
                block8: for (int z = 0; z < 7; ++z) {
                    if (x != 0 && x != 6 && z != 0 && z != 6 || y != 0 && y != 6) continue;
                    switch (facing) {
                        case NORTH: {
                            level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f), (double)pos.getX() + 0.5 - 3.0 + (double)x, (double)(pos.getY() + y) + 0.5, (double)pos.getZ() + 1.5 + (double)z, 0.0, 0.0, 0.0);
                            continue block8;
                        }
                        case SOUTH: {
                            level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f), (double)pos.getX() + 0.5 - 3.0 + (double)x, (double)(pos.getY() + y) + 0.5, (double)pos.getZ() - 0.5 - (double)z, 0.0, 0.0, 0.0);
                            continue block8;
                        }
                        case EAST: {
                            level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f), (double)pos.getX() - 0.5 - 6.0 + (double)x, (double)(pos.getY() + y) + 0.5, (double)pos.getZ() + 0.5 + 3.0 - (double)z, 0.0, 0.0, 0.0);
                            continue block8;
                        }
                        case WEST: {
                            level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(1.0f, 1.0f, 1.0f), 1.0f), (double)pos.getX() - 0.5 + 2.0 + (double)x, (double)(pos.getY() + y) + 0.5, (double)pos.getZ() + 0.5 + 3.0 - (double)z, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
        }
    }
}

