/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.block;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.menu.MagicalChestMenu;

public class MagicalChestTileEntity
extends BlockEntity
implements MenuProvider {
    public static final int NUMBER_OF_SLOTS = 36;
    private final ItemStackHandler itemStackHandler = this.createInventory();
    public final Lazy<IItemHandler> inventory = Lazy.of(() -> this.itemStackHandler);
    private UUID keyblade;
    private UUID owner;

    public MagicalChestTileEntity(BlockPos pos, BlockState state) {
        super(ModEntities.TYPE_MAGICAL_CHEST.get(), pos, state);
    }

    private ItemStackHandler createInventory() {
        return new ItemStackHandler(36){

            protected void onContentsChanged(int slot) {
                MagicalChestTileEntity.this.setChanged();
                MagicalChestTileEntity.this.level.sendBlockUpdated(MagicalChestTileEntity.this.worldPosition, MagicalChestTileEntity.this.getBlockState(), MagicalChestTileEntity.this.getBlockState(), 3);
            }
        };
    }

    public UUID getKeyblade() {
        return this.keyblade;
    }

    public void setKeyblade(UUID keyblade) {
        this.keyblade = keyblade;
        this.setChanged();
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        compound.put("inv", (Tag)this.itemStackHandler.serializeNBT(provider));
        if (this.owner != null) {
            compound.putUUID("owner", this.owner);
            if (this.keyblade != null && !this.keyblade.equals(new UUID(0L, 0L))) {
                compound.putUUID("keyblade", this.keyblade);
            }
        }
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        CompoundTag invCompound = compound.getCompound("inv");
        this.itemStackHandler.deserializeNBT(provider, invCompound);
        if (compound.hasUUID("owner")) {
            this.owner = compound.getUUID("owner");
        }
        if (compound.hasUUID("keyblade")) {
            this.keyblade = compound.getUUID("keyblade");
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.magical_chest");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
        return new MagicalChestMenu(windowId, playerInventory, this);
    }
}

