/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import online.kingdomkeys.kingdomkeys.block.GhostBloxBlock;
import online.kingdomkeys.kingdomkeys.block.MagnetBloxBlock;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import org.joml.Vector3f;

public class MagnetBloxTileEntity
extends BlockEntity {
    int ticks = 0;

    public MagnetBloxTileEntity(BlockPos pos, BlockState state) {
        super(ModEntities.TYPE_MAGNET_BLOX.get(), pos, state);
    }

    int calculateActualRange(Direction facing, int range) {
        int actualRange = range;
        for (int i = 0; i < range; ++i) {
            BlockState current = this.level.getBlockState(this.worldPosition.relative(facing, i + 1));
            if (current.getBlock() == ModBlocks.ghostBlox.get()) {
                if (!((Boolean)current.getValue((Property)GhostBloxBlock.VISIBLE)).booleanValue()) continue;
                actualRange = i;
                break;
            }
            if (!current.canOcclude() || current.getBlock() == Blocks.AIR) continue;
            actualRange = i;
            break;
        }
        return actualRange;
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        Direction facing;
        int range;
        MagnetBloxTileEntity TE = (MagnetBloxTileEntity)((Object)blockEntity);
        ++TE.ticks;
        if (((Boolean)state.getValue((Property)MagnetBloxBlock.ACTIVE)).booleanValue() && (range = TE.calculateActualRange(facing = (Direction)state.getValue((Property)MagnetBloxBlock.FACING), (Integer)state.getValue((Property)MagnetBloxBlock.RANGE))) > 0) {
            List entities;
            boolean attract = (Boolean)state.getValue((Property)MagnetBloxBlock.ATTRACT);
            if (TE.ticks % 5 == 0) {
                int[] colors = new int[]{1, 0, 0};
                if (!attract) {
                    colors[0] = 0;
                    colors[1] = 0;
                    colors[2] = 1;
                }
                for (double i = 0.7; i < (double)range; i += 0.3) {
                    float scale = 1.0f + (float)i / 6.0f;
                    if (facing == Direction.NORTH) {
                        level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f((float)colors[0], (float)colors[1], (float)colors[2]), scale), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5 - i, 0.0, 0.0, 0.0);
                        continue;
                    }
                    if (facing == Direction.EAST) {
                        level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f((float)colors[0], (float)colors[1], (float)colors[2]), scale), (double)pos.getX() + 0.5 + i, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
                        continue;
                    }
                    if (facing == Direction.SOUTH) {
                        level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f((float)colors[0], (float)colors[1], (float)colors[2]), scale), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5 + i, 0.0, 0.0, 0.0);
                        continue;
                    }
                    if (facing == Direction.WEST) {
                        level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f((float)colors[0], (float)colors[1], (float)colors[2]), scale), (double)pos.getX() + 0.5 - i, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
                        continue;
                    }
                    if (facing == Direction.UP) {
                        level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f((float)colors[0], (float)colors[1], (float)colors[2]), scale), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5 + i, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
                        continue;
                    }
                    if (facing != Direction.DOWN) continue;
                    level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f((float)colors[0], (float)colors[1], (float)colors[2]), scale), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5 - i, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
                }
            }
            if (!(entities = level.getEntitiesOfClass(Entity.class, new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).expandTowards((double)(range * facing.getNormal().getX()), (double)(range * facing.getNormal().getY()), (double)(range * facing.getNormal().getZ())).move(pos))).isEmpty()) {
                double strength = 0.75;
                for (Entity e : entities) {
                    Vec3 pushDir = TE.toVector3f(facing);
                    strength = attract ? -strength : strength;
                    e.setDeltaMovement(pushDir.normalize().multiply(strength, strength, strength));
                }
            }
        }
    }

    public Vec3 toVector3f(Direction facing) {
        return new Vec3((double)facing.getStepX(), (double)facing.getStepY(), (double)facing.getStepZ());
    }
}

