/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.block;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.block.PairBloxBlock;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;

public class PairBloxEntity
extends Entity {
    private static final EntityDataAccessor<Integer> PAIR = SynchedEntityData.defineId(PairBloxEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int pair = 0;

    public PairBloxEntity(EntityType<? extends Entity> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public PairBloxEntity(Level world, double x, double y, double z, int pair) {
        this(ModEntities.TYPE_PAIR_BLOX.get(), world);
        this.setPos(x + 0.5, y, z + 0.5);
        this.setPair(pair);
        this.xo = x + 0.5;
        this.yo = y;
        this.zo = z + 0.5;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(PAIR, (Object)0);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.SOUNDS;
    }

    public boolean isPickable() {
        return this.isAlive();
    }

    public void tick() {
        this.xo = this.blockPosition().getX();
        this.yo = this.blockPosition().getY();
        this.zo = this.blockPosition().getZ();
        this.move(MoverType.SELF, this.getDeltaMovement().add(0.0, -1.0, 0.0));
        if (this.tickCount >= 5) {
            this.level().setBlockAndUpdate(this.blockPosition(), (BlockState)ModBlocks.pairBlox.get().defaultBlockState().setValue((Property)PairBloxBlock.PAIR, (Comparable)Integer.valueOf(this.getPair())));
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("Pair", this.getPair());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setPair(compound.getInt("Pair"));
    }

    public double getEyeY() {
        return 0.0;
    }

    public void setPair(int pair) {
        this.entityData.set(PAIR, (Object)pair);
        this.pair = pair;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (PAIR.equals(key)) {
            this.pair = this.getPairDataManager();
        }
    }

    public int getPairDataManager() {
        return (Integer)this.entityData.get(PAIR);
    }

    public int getPair() {
        return this.pair;
    }
}

