/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.menu.PedestalMenu;

public class PedestalTileEntity
extends BlockEntity
implements MenuProvider {
    public static final int NUMBER_OF_SLOTS = 1;
    private final ItemStackHandler itemStackHandler = this.createInventory();
    public Lazy<IItemHandler> inventory = Lazy.of(() -> this.itemStackHandler);
    public static final float DEFAULT_HEIGHT = 1.25f;
    public static final float DEFAULT_ROTATION = 0.0f;
    public static final float DEFAULT_ROTATION_SPEED = 0.6f;
    public static final float DEFAULT_BOB_SPEED = 0.02f;
    public static final float DEFAULT_SCALE = 1.0f;
    private boolean stationOfAwakeningMarker = false;
    private ItemStack displayStack = ItemStack.EMPTY;
    private float rotationSpeed = 0.6f;
    private float bobSpeed = 0.02f;
    private float scale = 1.0f;
    private float currentRotation = 0.0f;
    private float currentHeight = 0.0f;
    private float savedRotation = 0.0f;
    private float savedHeight = 1.25f;
    private float baseHeight = 1.25f;
    private boolean pause = false;
    private boolean flipped = false;
    public boolean hide = false;
    private int ticksExisted;
    public int previousTicks;

    public PedestalTileEntity(BlockPos pos, BlockState state) {
        super(ModEntities.TYPE_PEDESTAL.get(), pos, state);
    }

    private ItemStackHandler createInventory() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            protected void onContentsChanged(int slot) {
                PedestalTileEntity.this.setChanged();
            }
        };
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        CompoundTag invCompound = compound.getCompound("inv");
        this.itemStackHandler.deserializeNBT(registries, invCompound);
        CompoundTag transformations = compound.getCompound("transforms");
        this.rotationSpeed = transformations.getFloat("rotspeed");
        this.bobSpeed = transformations.getFloat("bobspeed");
        this.savedRotation = transformations.getFloat("savedrot");
        this.savedHeight = transformations.getFloat("savedheight");
        this.scale = transformations.getFloat("scale");
        this.baseHeight = transformations.getFloat("baseheight");
        this.pause = transformations.getBoolean("pause");
        this.flipped = transformations.getBoolean("flipped");
        this.stationOfAwakeningMarker = compound.getBoolean("soa_marker");
        this.displayStack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compound.getCompound("display_stack"));
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.put("inv", (Tag)this.itemStackHandler.serializeNBT(registries));
        CompoundTag transformations = new CompoundTag();
        transformations.putFloat("rotspeed", this.rotationSpeed);
        transformations.putFloat("bobspeed", this.bobSpeed);
        transformations.putFloat("savedrot", this.savedRotation);
        transformations.putFloat("savedheight", this.savedHeight);
        transformations.putFloat("scale", this.scale);
        transformations.putFloat("baseheight", this.baseHeight);
        transformations.putBoolean("pause", this.pause);
        transformations.putBoolean("flipped", this.flipped);
        compound.put("transforms", (Tag)transformations);
        compound.putBoolean("soa_marker", this.stationOfAwakeningMarker);
        if (!this.displayStack.isEmpty()) {
            compound.put("display_stack", this.displayStack.save(registries));
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.pedestal");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowID, Inventory playerInventory, Player playerEntity) {
        return new PedestalMenu(windowID, playerInventory, this);
    }

    public void setStationOfAwakeningMarker(boolean marker) {
        this.stationOfAwakeningMarker = marker;
        this.setChanged();
    }

    public boolean isStationOfAwakeningMarker() {
        return this.stationOfAwakeningMarker;
    }

    public ItemStack getDisplayStack() {
        return this.displayStack;
    }

    public void setDisplayStack(ItemStack displayStack) {
        this.displayStack = displayStack;
        this.setChanged();
    }

    public float getRotationSpeed() {
        return this.rotationSpeed;
    }

    public float getBobSpeed() {
        return this.bobSpeed;
    }

    public float getSavedRotation() {
        return this.savedRotation;
    }

    public float getSavedHeight() {
        return this.savedHeight;
    }

    public boolean isPaused() {
        return this.pause;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setSpeed(float rotationSpeed, float bobSpeed) {
        this.rotationSpeed = rotationSpeed;
        this.bobSpeed = bobSpeed;
        this.setChanged();
    }

    public void saveTransforms(float savedRotation, float savedHeight) {
        this.savedRotation = savedRotation;
        this.savedHeight = savedHeight;
        this.setChanged();
    }

    public void setPause(boolean pause) {
        this.pause = pause;
        this.setChanged();
    }

    public void setFlipped(boolean flipped) {
        this.flipped = flipped;
        this.setChanged();
    }

    public void setCurrentTransforms(float currentRotation, float currentHeight) {
        this.currentHeight = currentHeight;
        this.currentRotation = currentRotation;
    }

    public float getBaseHeight() {
        return this.baseHeight;
    }

    public void setBaseHeight(float baseHeight) {
        this.baseHeight = baseHeight;
    }

    public float getCurrentRotation() {
        return this.currentRotation;
    }

    public float getCurrentHeight() {
        return this.currentHeight;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public int ticksExisted() {
        return this.ticksExisted;
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, BlockEntity te) {
        PedestalTileEntity pedestalTile;
        if (te instanceof PedestalTileEntity && !(pedestalTile = (PedestalTileEntity)te).isPaused()) {
            pedestalTile.previousTicks = pedestalTile.ticksExisted++;
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }
}

