/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.block;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import online.kingdomkeys.kingdomkeys.block.SavePointBlock;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.world.SavePointStorage;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class SavepointTileEntity
extends BlockEntity {
    public static float[] WARP_COLOR = new float[]{0.6f, 1.0f, 1.0f};
    public static float[] SAVEPOINT_COLOR = new float[]{0.3f, 1.0f, 0.3f};
    long ticks;
    private UUID id = UUID.randomUUID();
    private int heal = 20;
    private int hunger = 20;
    private int magic = 20;
    private int drive = 20;
    private int focus = 20;

    public SavepointTileEntity(BlockPos pos, BlockState state) {
        super(ModEntities.TYPE_SAVEPOINT.get(), pos, state);
    }

    public UUID getID() {
        return this.id;
    }

    public int getHeal() {
        return this.heal;
    }

    public void setHeal(int heal) {
        this.heal = heal;
        this.setChanged();
    }

    public int getHunger() {
        return this.hunger;
    }

    public void setHunger(int hunger) {
        this.hunger = hunger;
        this.setChanged();
    }

    public int getMagic() {
        return this.magic;
    }

    public void setMagic(int magic) {
        this.magic = magic;
        this.setChanged();
    }

    public int getDrive() {
        return this.drive;
    }

    public void setDrive(int drive) {
        this.drive = drive;
        this.setChanged();
    }

    public int getFocus() {
        return this.focus;
    }

    public void setFocus(int focus) {
        this.focus = focus;
        this.setChanged();
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        super.loadAdditional(pTag, registries);
        if (this.getBlockState().getValue(SavePointBlock.TIER) != SavePointStorage.SavePointType.NORMAL) {
            this.id = pTag.getUUID("savepoint_id");
        }
        this.heal = pTag.getInt("heal");
        this.hunger = pTag.getInt("hunger");
        this.magic = pTag.getInt("magic");
        this.drive = pTag.getInt("drive");
        this.focus = pTag.getInt("focus");
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider registries) {
        if (this.getBlockState().getValue(SavePointBlock.TIER) != SavePointStorage.SavePointType.NORMAL) {
            pTag.putUUID("savepoint_id", this.id);
        }
        pTag.putInt("heal", this.heal);
        pTag.putInt("hunger", this.hunger);
        pTag.putInt("magic", this.magic);
        pTag.putInt("drive", this.drive);
        pTag.putInt("focus", this.focus);
        super.saveAdditional(pTag, registries);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof SavepointTileEntity) {
            SavepointTileEntity savepoint = (SavepointTileEntity)((Object)blockEntity);
            if (savepoint.ticks > 1800L) {
                savepoint.ticks = 0L;
            }
            double r = 0.7;
            double cx = (double)pos.getX() + 0.5;
            double cy = (double)pos.getY() + 0.5;
            double cz = (double)pos.getZ() + 0.5;
            savepoint.ticks += 10L;
            double x = cx + r * Math.cos(Math.toRadians(savepoint.ticks));
            double z = cz + r * Math.sin(Math.toRadians(savepoint.ticks));
            double x2 = cx + r * Math.cos(Math.toRadians(-savepoint.ticks));
            double z2 = cz + r * Math.sin(Math.toRadians(-savepoint.ticks));
            float[] color = state.getValue(SavePointBlock.TIER) == SavePointStorage.SavePointType.WARP ? WARP_COLOR : SAVEPOINT_COLOR;
            level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(color[0], color[1], color[2]), 1.0f), x, cy - 0.5 - (double)((float)(-savepoint.ticks) / 1800.0f), z, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(color[0], color[1], color[2]), 1.0f), x2, cy + 0.5 - (double)((float)savepoint.ticks / 1800.0f), z2, 0.0, 0.0, 0.0);
        }
    }
}

