/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import org.jetbrains.annotations.Nullable;

public class SoAPlatformTileEntity
extends BlockEntity {
    private boolean multiblockFormed = false;
    public List<BlockPos> structureBlockPosCache = new ArrayList<BlockPos>();

    public void setMultiblockFormed(boolean formed) {
        this.multiblockFormed = formed;
        this.setChanged();
    }

    public boolean isMultiblockFormed() {
        return this.multiblockFormed;
    }

    public SoAPlatformTileEntity(BlockPos pos, BlockState state) {
        super(ModEntities.TYPE_SOA_PLATFORM.get(), pos, state);
    }

    public void clearPositions() {
        this.structureBlockPosCache.clear();
        this.setChanged();
    }

    public void addPos(BlockPos pos) {
        this.structureBlockPosCache.add(pos);
        this.setChanged();
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.loadAdditional(compound, registries);
        this.multiblockFormed = compound.getBoolean("formed");
        CompoundTag structureCompound = compound.getCompound("structure");
        int size = structureCompound.getInt("size");
        this.structureBlockPosCache.clear();
        for (int i = 0; i < size; ++i) {
            this.structureBlockPosCache.add((BlockPos)NbtUtils.readBlockPos((CompoundTag)structureCompound.getCompound("pos" + i), (String)("pos" + i)).get());
        }
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putBoolean("formed", this.multiblockFormed);
        CompoundTag structureCompound = new CompoundTag();
        structureCompound.putInt("size", this.structureBlockPosCache.size());
        for (int i = 0; i < this.structureBlockPosCache.size(); ++i) {
            structureCompound.put("pos" + i, NbtUtils.writeBlockPos((BlockPos)this.structureBlockPosCache.get(i)));
        }
        compound.put("structure", (Tag)structureCompound);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, pRegistries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }
}

