/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.drops;

import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.drops.ItemDropEntity;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;

public class DriveOrbEntity
extends ItemDropEntity {
    public DriveOrbEntity(Level worldIn, double x, double y, double z, int expValue) {
        super(ModEntities.TYPE_DRIVEORB.get(), worldIn, x, y, z, expValue);
    }

    public DriveOrbEntity(EntityType<? extends Entity> type, Level world) {
        super(type, world);
    }

    @Override
    void onPickup(Player player) {
        PlayerData playerData = PlayerData.get(player);
        float finalValue = this.value;
        if (playerData.isAbilityEquipped("kingdomkeys:ability_drive_boost") && playerData.getRecharge()) {
            finalValue *= 2.0f;
        }
        if (playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
            playerData.addDP(finalValue);
        } else {
            playerData.addFP(finalValue);
            if (playerData.getActiveDriveForm().equals("kingdomkeys:form_master")) {
                double mult = Double.parseDouble(((String)((List)ModConfigs.SERVER.driveFormXPMultiplier.get()).get(3)).split(",")[1]);
                playerData.setDriveFormExp(player, playerData.getActiveDriveForm(), (int)((double)playerData.getDriveFormExp(playerData.getActiveDriveForm()) + Math.max(1.0, (double)((float)this.value / 10.0f) * mult)));
                PacketHandler.sendTo(new SCSyncPlayerData(player), (ServerPlayer)player);
            }
        }
    }

    @Override
    SoundEvent getPickupSound() {
        return (SoundEvent)ModSounds.hp_orb.get();
    }

    @Override
    public void tick() {
        super.tick();
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(2.0, 2.0, 2.0));
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                ItemDropEntity e;
                Object e2 = list.get(i);
                if (!(e2 instanceof ItemDropEntity) || !((e = (ItemDropEntity)((Object)e2)) instanceof DriveOrbEntity) || this.tickCount <= e.tickCount) continue;
                this.value += e.value;
                e.remove(Entity.RemovalReason.KILLED);
            }
        }
    }
}

