/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.drops;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncPlayerData;

public abstract class ItemDropEntity
extends Entity {
    public int delayBeforeCanPickup;
    public int value;
    private Player closestPlayer;
    private static final EntityDataAccessor<Integer> VALUE = SynchedEntityData.defineId(ItemDropEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ItemDropEntity(EntityType<? extends Entity> type, Level worldIn, double x, double y, double z, int expValue) {
        this(type, worldIn);
        this.setPos(x, y, z);
        this.setYRot((float)(this.random.nextDouble() * 360.0));
        this.setDeltaMovement((this.random.nextDouble() * (double)0.2f - (double)0.1f) * 2.0, this.random.nextDouble() * 0.2 * 2.0, (this.random.nextDouble() * (double)0.2f - (double)0.1f) * 2.0);
        this.setValue(expValue);
        this.delayBeforeCanPickup = 20;
    }

    public ItemDropEntity(EntityType<? extends Entity> type, Level world) {
        super(type, world);
    }

    protected boolean isMovementNoisy() {
        return false;
    }

    public void tick() {
        PlayerData playerData;
        if (this.tickCount > 2400) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        super.tick();
        if (this.delayBeforeCanPickup > 0) {
            --this.delayBeforeCanPickup;
        }
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        if (this.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value())) {
            this.applyFloatMotion();
        } else if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
        }
        if (this.level().getFluidState(new BlockPos((int)this.position().x, (int)this.position().y, (int)this.position().z)).is(FluidTags.LAVA)) {
            this.setDeltaMovement((this.random.nextFloat() - this.random.nextFloat()) * 0.2f, 0.2f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
            this.playSound(SoundEvents.GENERIC_BURN, 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
        }
        if (!this.level().noCollision(this.getBoundingBox())) {
            this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
        }
        double maxDist = 8.0;
        if (this.closestPlayer == null || this.closestPlayer.distanceToSqr((Entity)this) > Math.pow(maxDist, 2.0)) {
            this.closestPlayer = this.level().getNearestPlayer((Entity)this, maxDist);
        }
        if (this.closestPlayer != null && this.closestPlayer.isSpectator()) {
            this.closestPlayer = null;
        }
        if (this.closestPlayer != null && (playerData = PlayerData.get(this.closestPlayer)) != null) {
            maxDist = 8 + playerData.getNumberOfAbilitiesEquipped("kingdomkeys:ability_treasure_magnet") * 2;
            Vec3 vec3d = new Vec3(this.closestPlayer.getX() - this.getX(), this.closestPlayer.getY() + (double)this.closestPlayer.getEyeHeight() / 2.0 - this.getY(), this.closestPlayer.getZ() - this.getZ());
            double d1 = vec3d.lengthSqr();
            if (d1 < Math.pow(maxDist, 2.0)) {
                double d2 = 1.0 - Math.sqrt(d1) / maxDist;
                this.setDeltaMovement(this.getDeltaMovement().add(vec3d.normalize().scale(d2 * d2 * 0.1)));
            }
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        float f = 0.98f;
        if (this.onGround()) {
            BlockPos pos = new BlockPos((int)this.getX(), (int)(this.getY() - 1.0), (int)this.getZ());
            f = this.level().getBlockState(pos).getFriction((LevelReader)this.level(), pos, (Entity)this) * 0.98f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, 0.98, (double)f));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.9, 1.0));
        }
    }

    private void applyFloatMotion() {
        Vec3 vec3d = this.getDeltaMovement();
        this.setDeltaMovement(vec3d.x * (double)0.99f, Math.min(vec3d.y + (double)5.0E-4f, (double)0.06f), vec3d.z * (double)0.99f);
    }

    protected void dealFireDamage(int amount) {
        this.hurt(this.damageSources().onFire(), amount);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.level().isClientSide || this.isRemoved()) {
            return false;
        }
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        this.markHurt();
        return false;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("value", this.getValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.setValue(compound.getInt("value"));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals(VALUE)) {
            this.value = (Integer)this.entityData.get(VALUE);
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int v) {
        this.entityData.set(VALUE, (Object)v);
        this.value = v;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(VALUE, (Object)0);
    }

    public void playerTouch(Player entityIn) {
        if (!this.level().isClientSide && this.delayBeforeCanPickup == 0) {
            this.onPickup(entityIn);
            this.playSound(this.getPickupSound(), 1.0f, 1.0f);
            this.remove(Entity.RemovalReason.KILLED);
            PacketHandler.sendTo(new SCSyncPlayerData(entityIn), (ServerPlayer)entityIn);
        }
    }

    abstract void onPickup(Player var1);

    abstract SoundEvent getPickupSound();

    @OnlyIn(value=Dist.CLIENT)
    public int getTextureByXP() {
        if (this.value >= 2477) {
            return 10;
        }
        if (this.value >= 1237) {
            return 9;
        }
        if (this.value >= 617) {
            return 8;
        }
        if (this.value >= 307) {
            return 7;
        }
        if (this.value >= 149) {
            return 6;
        }
        if (this.value >= 73) {
            return 5;
        }
        if (this.value >= 37) {
            return 4;
        }
        if (this.value >= 17) {
            return 3;
        }
        if (this.value >= 7) {
            return 2;
        }
        return this.value >= 3 ? 1 : 0;
    }

    public boolean isAttackable() {
        return false;
    }
}

