/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.drops;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;

public class XPEntity
extends Entity {
    public static final int MAX_TICKS = 30;
    public double xp;
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.defineId(XPEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Integer> EXP = SynchedEntityData.defineId(XPEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public XPEntity(EntityType<? extends Entity> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(OWNER, Optional.of(Util.NIL_UUID));
        pBuilder.define(EXP, (Object)0);
    }

    public XPEntity(Level world) {
        super(ModEntities.TYPE_XP.get(), world);
        this.blocksBuilding = true;
    }

    public XPEntity(Level level, Player player, LivingEntity mob, double exp) {
        super(ModEntities.TYPE_XP.get(), level);
        this.setPos(mob.getX() + 0.5, mob.getY(), mob.getZ() + 0.5);
        this.setExp((int)exp);
        this.setCaster(player.getUUID());
    }

    public void tick() {
        if (this.tickCount < 20) {
            // empty if block
        }
        if (this.tickCount >= 30) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        super.tick();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        if (((Optional)this.entityData.get(OWNER)).isPresent()) {
            compound.putString("OwnerUUID", ((UUID)((Optional)this.entityData.get(OWNER)).get()).toString());
        }
        compound.putInt("exp", ((Integer)this.entityData.get(EXP)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.entityData.set(OWNER, Optional.of(UUID.fromString(compound.getString("OwnerUUID"))));
        this.entityData.set(EXP, (Object)compound.getInt("exp"));
    }

    public Player getCaster() {
        return ((Optional)this.getEntityData().get(OWNER)).isPresent() ? this.level().getPlayerByUUID((UUID)((Optional)this.getEntityData().get(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.entityData.set(OWNER, Optional.of(uuid));
    }

    public int getExp() {
        return (Integer)this.getEntityData().get(EXP);
    }

    public void setExp(int exp) {
        this.entityData.set(EXP, (Object)exp);
    }
}

