/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.damagesource.KKDamageTypes;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.lib.Party;

public class BlizzardEntity
extends ThrowableProjectile {
    int maxTicks = 120;
    float dmgMult = 1.0f;
    int freezeTime;

    public BlizzardEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public BlizzardEntity(Level world, LivingEntity player, float dmgMult, int freezeTime) {
        super(ModEntities.TYPE_BLIZZARD.get(), player, world);
        this.dmgMult = dmgMult;
        this.freezeTime = freezeTime;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public void tick() {
        if (this.tickCount > this.maxTicks) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        if (ModConfigs.blizzardChangeBlocks && !this.level().isClientSide) {
            if (this.level().getBlockState(this.blockPosition()) == Blocks.WATER.defaultBlockState()) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.ICE.defaultBlockState());
                this.remove(Entity.RemovalReason.KILLED);
            } else if (this.level().getBlockState(this.blockPosition()) == Blocks.LAVA.defaultBlockState()) {
                this.level().setBlockAndUpdate(this.blockPosition(), Blocks.OBSIDIAN.defaultBlockState());
                this.remove(Entity.RemovalReason.KILLED);
            }
        }
        if (this.tickCount > 2) {
            this.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
        super.tick();
    }

    protected void onHit(HitResult rtRes) {
        if (!this.level().isClientSide) {
            LivingEntity target;
            Entity entity;
            EntityHitResult ertResult = null;
            BlockHitResult brtResult = null;
            if (rtRes instanceof EntityHitResult) {
                ertResult = (EntityHitResult)rtRes;
            }
            if (rtRes instanceof BlockHitResult) {
                brtResult = (BlockHitResult)rtRes;
            }
            if (ertResult != null && (entity = ertResult.getEntity()) instanceof LivingEntity && (target = (LivingEntity)entity) != this.getOwner()) {
                Party p = null;
                if (this.getOwner() != null) {
                    p = WorldData.get(this.getOwner().getServer()).getPartyFromMember(this.getOwner().getUUID());
                }
                if (p == null || p.getMember(target.getUUID()) == null || p.getFriendlyFire()) {
                    float dmg = this.getOwner() instanceof Player ? DamageCalculation.getMagicDamage((Player)this.getOwner()) * 1.4f : 2.0f;
                    target.hurt(KKDamageTypes.getElementalDamage(KKDamageTypes.ICE, (Entity)this, this.getOwner()), dmg * this.dmgMult);
                    if (!target.isOnFire()) {
                        MobEffectInstance freeze = target.getEffect(ModMobEffects.FREEZE);
                        int duration = this.freezeTime;
                        if (freeze != null) {
                            duration += freeze.getDuration();
                        }
                        target.addEffect(new MobEffectInstance(ModMobEffects.FREEZE, duration, 0, false, false, false));
                    }
                }
            }
            if (brtResult != null) {
                BlockPos blockpos = brtResult.getBlockPos();
                BlockState blockstate = this.level().getBlockState(blockpos);
                if (blockstate.hasProperty((Property)BlockStateProperties.LIT)) {
                    this.level().setBlock(blockpos, (BlockState)blockstate.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)), 11);
                }
            }
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
    }

    public void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }
}

