/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.damagesource.KKDamageTypes;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class BlizzazaEntity
extends ThrowableProjectile {
    int maxTicks = 120;
    float dmgMult = 1.0f;
    int freezeTime;
    float radius = 6.0f;

    public BlizzazaEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public BlizzazaEntity(Level world, LivingEntity player, float dmgMult, int freezeTime) {
        super(ModEntities.TYPE_BLIZZAZA.get(), player, world);
        this.dmgMult = dmgMult;
        this.freezeTime = freezeTime;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public void tick() {
        if (this.tickCount > this.maxTicks) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        if (ModConfigs.blizzardChangeBlocks && !this.level().isClientSide && this.level().getBlockState(this.blockPosition()) != Blocks.AIR.defaultBlockState()) {
            int x = (int)(this.getX() - (double)(this.radius / 2.0f));
            while ((double)x < this.getX() + (double)(this.radius / 2.0f)) {
                int y = (int)this.getY();
                while ((double)y < this.getY() + 1.0) {
                    int z = (int)(this.getZ() - (double)(this.radius / 2.0f));
                    while ((double)z < this.getZ() + (double)(this.radius / 2.0f)) {
                        if ((this.getX() - (double)x) * (this.getX() - (double)x) + (this.getY() - (double)y) * (this.getY() - (double)y) + (this.getZ() - (double)z) * (this.getZ() - (double)z) <= (double)(this.radius / 2.0f * this.radius / 2.0f)) {
                            BlockPos blockpos = new BlockPos(x, y, z);
                            BlockState blockstate = this.level().getBlockState(blockpos);
                            if (blockstate == Blocks.WATER.defaultBlockState()) {
                                this.level().setBlockAndUpdate(blockpos, Blocks.ICE.defaultBlockState());
                            } else if (blockstate == Blocks.LAVA.defaultBlockState()) {
                                this.level().setBlockAndUpdate(blockpos, Blocks.OBSIDIAN.defaultBlockState());
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            this.remove(Entity.RemovalReason.KILLED);
        }
        if (this.tickCount > 2) {
            float radius = 0.5f;
            for (int t = 1; t < 360; t += 50) {
                for (int s = 1; s < 360; s += 50) {
                    double x = this.getX() + (double)radius * Math.cos(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                    double z = this.getZ() + (double)radius * Math.sin(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                    double y = this.getY() + (double)radius * Math.cos(Math.toRadians(t));
                    this.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, x, y, z, 0.0, 0.0, 0.0);
                }
            }
        }
        super.tick();
    }

    protected void onHit(HitResult rtRes) {
        if (!this.level().isClientSide) {
            Entity ogBlockPos;
            LivingEntity target;
            EntityHitResult ertResult;
            Entity entity;
            if (rtRes instanceof EntityHitResult && (entity = (ertResult = (EntityHitResult)rtRes).getEntity()) instanceof LivingEntity && (target = (LivingEntity)entity) != this.getOwner()) {
                Party p = null;
                if (this.getOwner() != null) {
                    p = WorldData.get(this.getOwner().getServer()).getPartyFromMember(this.getOwner().getUUID());
                }
                if (p == null || p.getMember(target.getUUID()) == null || p.getFriendlyFire()) {
                    float dmg = this.getOwner() instanceof Player ? DamageCalculation.getMagicDamage((Player)this.getOwner()) * 1.4f : 2.0f;
                    target.hurt(KKDamageTypes.getElementalDamage(KKDamageTypes.ICE, (Entity)this, this.getOwner()), dmg * this.dmgMult);
                    if (!target.isOnFire()) {
                        MobEffectInstance freeze = target.getEffect(ModMobEffects.FREEZE);
                        int duration = this.freezeTime;
                        if (freeze != null) {
                            duration += freeze.getDuration();
                        }
                        target.addEffect(new MobEffectInstance(ModMobEffects.FREEZE, duration, 0, false, false));
                    }
                }
            }
            if (rtRes instanceof BlockHitResult) {
                BlockHitResult brtResult = (BlockHitResult)rtRes;
                ogBlockPos = brtResult.getBlockPos();
                int x = (int)((float)ogBlockPos.getX() - this.radius);
                while ((float)x < (float)ogBlockPos.getX() + this.radius) {
                    int y = (int)((float)ogBlockPos.getY() - this.radius);
                    while ((float)y < (float)ogBlockPos.getY() + this.radius) {
                        int z = (int)((float)ogBlockPos.getZ() - this.radius);
                        while ((float)z < (float)ogBlockPos.getZ() + this.radius) {
                            BlockPos blockpos = new BlockPos(x, y, z);
                            BlockState blockstate = this.level().getBlockState(blockpos);
                            if (blockstate.hasProperty((Property)BlockStateProperties.LIT)) {
                                this.level().setBlock(blockpos, (BlockState)blockstate.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)), 11);
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
            if ((ogBlockPos = this.getOwner()) instanceof Player) {
                float i;
                Player player = (Player)ogBlockPos;
                List<LivingEntity> list = Utils.getLivingEntitiesInRadius((Entity)this, this.radius);
                int r = 2;
                for (int t = 1; t < 360; t += 20) {
                    for (int s = 1; s < 360; s += 20) {
                        double x = this.getX() + (double)r * Math.cos(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                        double z = this.getZ() + (double)r * Math.sin(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                        double y = this.getY() + (double)r * Math.cos(Math.toRadians(t));
                        ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, x, y + 1.0, z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                for (i = -5.0f; i <= 5.0f; i += 0.5f) {
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, this.getX(), this.getY() + (double)i, this.getZ(), 3, 0.0, 0.0, 0.0, 0.2);
                }
                for (i = -5.0f; i <= 5.0f; i += 0.5f) {
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, this.getX() + (double)i, this.getY(), this.getZ(), 3, 0.0, 0.0, 0.0, 0.2);
                }
                for (i = -5.0f; i <= 5.0f; i += 0.5f) {
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, this.getX(), this.getY(), this.getZ() + (double)i, 3, 0.0, 0.0, 0.0, 0.2);
                }
                Party casterParty = WorldData.get(player.getServer()).getPartyFromMember(player.getUUID());
                if (!list.isEmpty()) {
                    for (LivingEntity e : list) {
                        if (e.isOnFire()) {
                            e.clearFire();
                            continue;
                        }
                        if (Utils.isEntityInParty(casterParty, (Entity)e) || e == this.getOwner()) continue;
                        float baseDmg = DamageCalculation.getMagicDamage((Player)this.getOwner()) * 1.4f;
                        float dmg = this.getOwner() instanceof Player ? baseDmg : 2.0f;
                        e.hurt(KKDamageTypes.getElementalDamage(KKDamageTypes.ICE, (Entity)this, (Entity)player), dmg);
                        MobEffectInstance freeze = e.getEffect(ModMobEffects.FREEZE);
                        int duration = this.freezeTime;
                        if (freeze != null) {
                            duration += freeze.getDuration();
                        }
                        e.addEffect(new MobEffectInstance(ModMobEffects.FREEZE, duration, 0, false, false));
                    }
                }
            }
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
    }

    public void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }
}

