/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import online.kingdomkeys.kingdomkeys.damagesource.KKDamageTypes;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class FirazaEntity
extends ThrowableProjectile {
    int maxTicks = 100;
    float dmgMult = 1.0f;

    public FirazaEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public FirazaEntity(Level world, LivingEntity player, float dmgMult) {
        super(ModEntities.TYPE_FIRAZA.get(), player, world);
        this.dmgMult = dmgMult;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity pEntity) {
        return super.getAddEntityPacket(pEntity);
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public void tick() {
        if (this.tickCount > this.maxTicks) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        if (this.tickCount > 2) {
            float radius = 1.0f;
            for (int t = 1; t < 360; t += 30) {
                for (int s = 1; s < 360; s += 30) {
                    double x = this.getX() + (double)radius * Math.cos(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                    double z = this.getZ() + (double)radius * Math.sin(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                    double y = this.getY() + (double)radius * Math.cos(Math.toRadians(t));
                    this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0);
                }
            }
        }
        super.tick();
    }

    protected void onHit(HitResult rtRes) {
        if (!this.level().isClientSide && this.getOwner() != null) {
            LivingEntity target;
            Entity entity;
            EntityHitResult ertResult = null;
            BlockHitResult brtResult = null;
            if (rtRes instanceof EntityHitResult) {
                ertResult = (EntityHitResult)rtRes;
            }
            if (rtRes instanceof BlockHitResult) {
                brtResult = (BlockHitResult)rtRes;
            }
            if (ertResult != null && (entity = ertResult.getEntity()) instanceof LivingEntity && (target = (LivingEntity)entity) != this.getOwner()) {
                if (target.getEffect(ModMobEffects.FREEZE) != null) {
                    target.removeEffect(ModMobEffects.FREEZE);
                }
                Party p = null;
                if (this.getOwner() != null) {
                    p = WorldData.get(this.getOwner().getServer()).getPartyFromMember(this.getOwner().getUUID());
                }
                if (p == null || p.getMember(target.getUUID()) == null || p.getFriendlyFire()) {
                    target.setRemainingFireTicks(30);
                    float dmg = this.getOwner() instanceof Player ? DamageCalculation.getMagicDamage((Player)this.getOwner()) : 2.0f;
                    target.hurt(KKDamageTypes.getElementalDamage(KKDamageTypes.FIRE, (Entity)this, this.getOwner()), dmg * this.dmgMult);
                }
            }
            float radius = 6.0f;
            if (brtResult != null) {
                BlockPos ogBlockPos = brtResult.getBlockPos();
                int x = (int)((float)ogBlockPos.getX() - radius);
                while ((float)x < (float)ogBlockPos.getX() + radius) {
                    int n = (int)((float)ogBlockPos.getY() - radius);
                    while ((float)n < (float)ogBlockPos.getY() + radius) {
                        int z = (int)((float)ogBlockPos.getZ() - radius);
                        while ((float)z < (float)ogBlockPos.getZ() + radius) {
                            BlockPos blockpos = new BlockPos(x, n, z);
                            BlockState blockstate = this.level().getBlockState(blockpos);
                            if (blockstate.getBlock() == Blocks.WET_SPONGE) {
                                this.level().setBlockAndUpdate(blockpos, Blocks.SPONGE.defaultBlockState());
                            }
                            if (blockstate.hasProperty((Property)BlockStateProperties.LIT)) {
                                this.level().setBlock(blockpos, (BlockState)blockstate.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 11);
                            }
                            ++z;
                        }
                        ++n;
                    }
                    ++x;
                }
            }
            if (this.getOwner() instanceof Player) {
                List<LivingEntity> list = Utils.getLivingEntitiesInRadiusExcludingParty((Player)this.getOwner(), radius);
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY(), this.getZ(), 1000, Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5, 0.3);
                if (!list.isEmpty()) {
                    for (Entity entity2 : list) {
                        if (!(entity2 instanceof LivingEntity)) continue;
                        LivingEntity ent = (LivingEntity)entity2;
                        entity2.setRemainingFireTicks(25);
                        float dmg = this.getOwner() instanceof Player ? DamageCalculation.getMagicDamage((Player)this.getOwner()) * 0.8f : 2.0f;
                        entity2.hurt(KKDamageTypes.getElementalDamage(KKDamageTypes.FIRE, (Entity)this, this.getOwner()), dmg * this.dmgMult);
                        if (ent.getEffect(ModMobEffects.FREEZE) == null) continue;
                        ent.removeEffect(ModMobEffects.FREEZE);
                    }
                }
            }
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
    }

    public void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }
}

