/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import online.kingdomkeys.kingdomkeys.damagesource.KKDamageTypes;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.lib.Party;

public class FireEntity
extends ThrowableProjectile {
    int maxTicks = 100;
    float dmgMult = 1.0f;
    LivingEntity lockOnEntity;

    public FireEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public FireEntity(Level world, LivingEntity player, float dmgMult, LivingEntity lockOnEntity) {
        super(ModEntities.TYPE_FIRE.get(), player, world);
        this.dmgMult = dmgMult;
        this.lockOnEntity = lockOnEntity;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public void tick() {
        if (this.tickCount > this.maxTicks) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        if (this.lockOnEntity != null && this.tickCount > 1) {
            double x = this.lockOnEntity.getX() - this.getX();
            double y = this.lockOnEntity.getY() - this.getY();
            double z = this.lockOnEntity.getZ() - this.getZ();
            this.shoot(this.getDeltaMovement().x + x / 100.0, this.getDeltaMovement().y + y / 100.0, this.getDeltaMovement().z + z / 100.0, 2.0f, 0.0f);
        }
        if (this.tickCount > 2) {
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
        super.tick();
    }

    protected void onHit(HitResult rtRes) {
        if (!this.level().isClientSide && this.getOwner() != null) {
            LivingEntity target;
            Entity entity;
            EntityHitResult ertResult = null;
            BlockHitResult brtResult = null;
            if (rtRes instanceof EntityHitResult) {
                ertResult = (EntityHitResult)rtRes;
            }
            if (rtRes instanceof BlockHitResult) {
                brtResult = (BlockHitResult)rtRes;
            }
            if (ertResult != null && (entity = ertResult.getEntity()) instanceof LivingEntity && (target = (LivingEntity)entity) != this.getOwner()) {
                if (target.getEffect(ModMobEffects.FREEZE) != null) {
                    target.removeEffect(ModMobEffects.FREEZE);
                }
                Party p = null;
                if (this.getOwner() != null) {
                    p = WorldData.get(this.getOwner().getServer()).getPartyFromMember(this.getOwner().getUUID());
                }
                if (p == null || p.getMember(target.getUUID()) == null || p.getFriendlyFire()) {
                    target.setRemainingFireTicks(5);
                    float dmg = this.getOwner() instanceof Player ? DamageCalculation.getMagicDamage((Player)this.getOwner()) * 0.2f : 2.0f;
                    target.hurt(KKDamageTypes.getElementalDamage(KKDamageTypes.FIRE, (Entity)this, this.getOwner()), dmg * this.dmgMult);
                }
            }
            if (brtResult != null) {
                BlockPos blockpos = brtResult.getBlockPos();
                BlockState blockstate = this.level().getBlockState(blockpos);
                if (blockstate.getBlock() == Blocks.WET_SPONGE) {
                    this.level().setBlockAndUpdate(blockpos, Blocks.SPONGE.defaultBlockState());
                }
                if (CampfireBlock.canLight((BlockState)blockstate) || CandleBlock.canLight((BlockState)blockstate) || CandleCakeBlock.canLight((BlockState)blockstate)) {
                    this.level().setBlock(blockpos, (BlockState)blockstate.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(true)), 11);
                }
            }
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
    }

    public void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }
}

