/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCRecalculateEyeHeight;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class GravityEntity
extends ThrowableProjectile {
    int maxTicks = 100;
    float dmgMult = 1.0f;

    public GravityEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public GravityEntity(Level world, Player player, float dmgMult) {
        super(ModEntities.TYPE_GRAVITY.get(), (LivingEntity)player, world);
        this.dmgMult = dmgMult;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public void tick() {
        if (this.tickCount > this.maxTicks) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        if (this.tickCount > 2) {
            this.level().addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
        super.tick();
    }

    protected void onHit(HitResult rtRes) {
        if (!this.level().isClientSide) {
            float radius = 2.0f;
            double X = this.getX();
            double Y = this.getY();
            double Z = this.getZ();
            for (int t = 1; t < 360; t += 20) {
                for (int s = 1; s < 360; s += 20) {
                    double x = X + (double)radius * Math.cos(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                    double z = Z + (double)radius * Math.sin(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                    double y = Y + (double)radius * Math.cos(Math.toRadians(t));
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.DRAGON_BREATH, x, y + 1.0, z, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            WorldData worldData = WorldData.get(this.level().getServer());
            if (this.getOwner() != null && worldData != null) {
                List oList = this.level().getEntities(this.getOwner(), this.getBoundingBox().inflate((double)radius));
                List<Entity> list = Utils.removePartyMembersFromList((Player)this.getOwner(), oList);
                if (!list.isEmpty()) {
                    for (Entity e : list) {
                        if (!(e instanceof LivingEntity)) continue;
                        LivingEntity livingEntity = (LivingEntity)e;
                        MobEffectInstance instance = new MobEffectInstance(ModMobEffects.GRAVITY, 100, 0, false, false, false);
                        livingEntity.addEffect(instance);
                        e.level().getServer().getPlayerList().getPlayers().forEach(player -> player.connection.send((Packet)new ClientboundUpdateMobEffectPacket(livingEntity.getId(), instance, false)));
                        if (Utils.isHostile(e)) {
                            float dmg = this.getOwner() instanceof Player ? livingEntity.getMaxHealth() * DamageCalculation.getMagicDamage((Player)this.getOwner()) / 100.0f : 2.0f;
                            dmg = Math.min(dmg, 99.0f);
                            e.hurt(e.damageSources().thrown((Entity)this, this.getOwner()), dmg * this.dmgMult);
                        }
                        if (!(e instanceof ServerPlayer)) continue;
                        PacketHandler.sendTo(new SCRecalculateEyeHeight(), (ServerPlayer)e);
                    }
                }
                this.remove(Entity.RemovalReason.KILLED);
            }
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
    }

    public void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
    }
}

