/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MagnetEntity
extends ThrowableProjectile {
    int maxTicks = 100;
    float dmgMult = 1.0f;
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.defineId(MagnetEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);

    public MagnetEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public MagnetEntity(Level world, Player player, float dmgMult) {
        super(ModEntities.TYPE_MAGNET.get(), (LivingEntity)player, world);
        this.setCaster(player.getUUID());
        this.dmgMult = dmgMult;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public void tick() {
        if (this.tickCount > this.maxTicks || this.getCaster() == null) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        if (this.level() == null || WorldData.get(this.level().getServer()) == null || this.getCaster() == null) {
            return;
        }
        this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        float radius = 2.0f;
        if (this.tickCount >= 3) {
            if (!this.level().isClientSide) {
                if (this.tickCount < 20) {
                    radius = (float)this.tickCount / 10.0f;
                }
                if (this.tickCount > this.maxTicks - 20) {
                    radius = (float)(this.maxTicks - this.tickCount) / 10.0f;
                }
                double X = this.getX();
                double Y = this.getY();
                double Z = this.getZ();
                for (int t = 1; t < 360; t += 30) {
                    for (int s = 1; s < 360; s += 30) {
                        double x = X + (double)radius * Math.cos(Math.toRadians(s + this.tickCount)) * Math.sin(Math.toRadians(t + this.tickCount));
                        double z = Z + (double)radius * Math.sin(Math.toRadians(s + this.tickCount)) * Math.sin(Math.toRadians(t + this.tickCount));
                        double y = Y + (double)radius * Math.cos(Math.toRadians(t + this.tickCount));
                        ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.BUBBLE_POP, x, y + 1.0, z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            this.setDeltaMovement(0.0, 0.0, 0.0);
            this.hurtMarked = true;
            List<Entity> list = this.level().getEntities((Entity)this.getCaster(), this.getBoundingBox().inflate((double)radius, (double)(radius * 2.0f), (double)radius));
            list = Utils.removePartyMembersFromList(this.getCaster(), list);
            if (!list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    Entity e = list.get(i);
                    double d = e.getX() - this.getX();
                    double d1 = e.getZ() - this.getZ();
                    if (e.getY() < this.getY() - 0.5) {
                        e.setDeltaMovement(0.0, 0.5, 0.0);
                    }
                    e.setDeltaMovement(d * -0.1, e.getDeltaMovement().y, d1 * -0.1);
                }
            }
        }
        if (this.tickCount == this.maxTicks - 20) {
            this.getCaster().level().playSound(null, this.getCaster().blockPosition(), (SoundEvent)ModSounds.magnet2.get(), SoundSource.PLAYERS, 1.0f, 1.1f);
        }
        super.tick();
    }

    protected void onHit(HitResult rtRes) {
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (((Optional)this.entityData.get(OWNER)).isPresent()) {
            compound.putString("OwnerUUID", ((UUID)((Optional)this.entityData.get(OWNER)).get()).toString());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(OWNER, Optional.of(UUID.fromString(compound.getString("OwnerUUID"))));
    }

    public Player getCaster() {
        return ((Optional)this.getEntityData().get(OWNER)).isPresent() ? this.level().getPlayerByUUID((UUID)((Optional)this.getEntityData().get(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.entityData.set(OWNER, Optional.of(uuid));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(OWNER, Optional.of(Util.NIL_UUID));
    }
}

