/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.damagesource.KKDamageTypes;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class ThunderBoltEntity
extends ThrowableProjectile {
    private int lightningState;
    public long boltVertex;
    private int boltLivingTime;
    private boolean effectOnly;
    float dmgMult = 1.0f;
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.defineId(ThunderBoltEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);

    public ThunderBoltEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public ThunderBoltEntity(Level world, Player player, double x, double y, double z, float dmgMult) {
        super(ModEntities.TYPE_THUNDERBOLT.get(), (LivingEntity)player, world);
        this.setCaster(player.getUUID());
        this.noCulling = true;
        this.moveTo(x, y, z, 0.0f, 0.0f);
        this.lightningState = 2;
        this.boltVertex = this.random.nextLong();
        this.boltLivingTime = this.random.nextInt(3) + 1;
        this.effectOnly = false;
        this.dmgMult = dmgMult;
    }

    public SoundSource getSoundSource() {
        return SoundSource.WEATHER;
    }

    public void tick() {
        super.tick();
        --this.lightningState;
        if (this.lightningState < 0) {
            if (this.boltLivingTime == 0) {
                this.remove(Entity.RemovalReason.KILLED);
            } else if (this.lightningState < -this.random.nextInt(10)) {
                --this.boltLivingTime;
                this.lightningState = 1;
                this.boltVertex = this.random.nextLong();
            }
        }
        if (this.lightningState >= 0 && this.getOwner() != null) {
            if (this.level().isClientSide) {
                this.level().setSkyFlashTime(2);
            } else if (!this.effectOnly) {
                List<LivingEntity> list;
                float radius = 1.0f;
                Entity entity = this.getOwner();
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    list = Utils.getLivingEntitiesInRadiusExcludingParty(player, (Entity)this, radius, 10.0f, radius);
                } else {
                    list = Utils.getLivingEntitiesInRadius((Entity)this, radius);
                }
                for (LivingEntity entity2 : list) {
                    float dmg = this.getOwner() instanceof Player ? DamageCalculation.getMagicDamage((Player)this.getOwner()) * 0.02f : 2.0f;
                    entity2.invulnerableTime = 0;
                    entity2.hurt(KKDamageTypes.getElementalDamage(KKDamageTypes.LIGHTNING, (Entity)this, this.getOwner()), dmg * this.dmgMult);
                    if (entity2 instanceof Pig && this.level().getDifficulty() != Difficulty.PEACEFUL) {
                        Pig pig = (Pig)entity2;
                        ZombifiedPiglin zombifiedpiglinentity = (ZombifiedPiglin)EntityType.ZOMBIFIED_PIGLIN.create(this.level());
                        zombifiedpiglinentity.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.GOLDEN_SWORD));
                        zombifiedpiglinentity.moveTo(pig.getX(), pig.getY(), pig.getZ(), pig.getYRot(), pig.getXRot());
                        zombifiedpiglinentity.setNoAi(pig.isNoAi());
                        zombifiedpiglinentity.setBaby(pig.isBaby());
                        if (pig.hasCustomName()) {
                            zombifiedpiglinentity.setCustomName(pig.getCustomName());
                            zombifiedpiglinentity.setCustomNameVisible(pig.isCustomNameVisible());
                        }
                        zombifiedpiglinentity.setPersistenceRequired();
                        this.level().addFreshEntity((Entity)zombifiedpiglinentity);
                        pig.remove(Entity.RemovalReason.KILLED);
                    }
                    if (entity2 instanceof Villager && this.level().getDifficulty() != Difficulty.PEACEFUL) {
                        Villager villager = (Villager)entity2;
                        Witch witchentity = (Witch)EntityType.WITCH.create(this.level());
                        witchentity.moveTo(villager.getX(), villager.getY(), villager.getZ(), villager.getYRot(), villager.getXRot());
                        witchentity.finalizeSpawn((ServerLevelAccessor)((ServerLevel)this.level()), this.level().getCurrentDifficultyAt(witchentity.blockPosition()), MobSpawnType.CONVERSION, null);
                        witchentity.setNoAi(villager.isNoAi());
                        if (villager.hasCustomName()) {
                            witchentity.setCustomName(villager.getCustomName());
                            witchentity.setCustomNameVisible(villager.isCustomNameVisible());
                        }
                        witchentity.setPersistenceRequired();
                        this.level().addFreshEntity((Entity)witchentity);
                        villager.remove(Entity.RemovalReason.KILLED);
                    }
                    if (!(entity2 instanceof Creeper)) continue;
                    LightningBolt lightningBoltEntity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
                    lightningBoltEntity.moveTo(Vec3.atBottomCenterOf((Vec3i)entity2.blockPosition()));
                    lightningBoltEntity.setCause(this.getCaster() instanceof ServerPlayer ? (ServerPlayer)this.getCaster() : null);
                    this.level().addFreshEntity((Entity)lightningBoltEntity);
                }
                if (this.getCaster() != null) {
                    CriteriaTriggers.CHANNELED_LIGHTNING.trigger((ServerPlayer)this.getCaster(), list);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = 64.0 * ThunderBoltEntity.getViewScale();
        return distance < d0 * d0;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (((Optional)this.entityData.get(OWNER)).isPresent()) {
            compound.putString("OwnerUUID", ((UUID)((Optional)this.entityData.get(OWNER)).get()).toString());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(OWNER, Optional.of(UUID.fromString(compound.getString("OwnerUUID"))));
    }

    public Player getCaster() {
        return ((Optional)this.getEntityData().get(OWNER)).isPresent() ? this.level().getPlayerByUUID((UUID)((Optional)this.getEntityData().get(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.entityData.set(OWNER, Optional.of(uuid));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(OWNER, Optional.of(Util.NIL_UUID));
    }

    protected void onHit(HitResult result) {
    }
}

