/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.magic.ThunderBoltEntity;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class ThunderEntity
extends ThrowableProjectile {
    int maxTicks = 20;
    float dmgMult = 1.0f;
    LivingEntity lockedOnEntity;
    private static final EntityDataAccessor<Optional<UUID>> OWNER = SynchedEntityData.defineId(ThunderEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    List<LivingEntity> list = new ArrayList<LivingEntity>();

    public ThunderEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public ThunderEntity(Level world, Player player, float dmgMult, LivingEntity lockedOnEntity) {
        super(ModEntities.TYPE_THUNDER.get(), (LivingEntity)player, world);
        this.setCaster(player.getUUID());
        this.dmgMult = dmgMult;
        this.lockedOnEntity = lockedOnEntity;
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        if (((Optional)this.entityData.get(OWNER)).isPresent()) {
            compound.putString("OwnerUUID", ((UUID)((Optional)this.entityData.get(OWNER)).get()).toString());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.entityData.set(OWNER, Optional.of(UUID.fromString(compound.getString("OwnerUUID"))));
    }

    public Player getCaster() {
        return ((Optional)this.getEntityData().get(OWNER)).isPresent() ? this.level().getPlayerByUUID((UUID)((Optional)this.getEntityData().get(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.entityData.set(OWNER, Optional.of(uuid));
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(OWNER, Optional.of(Util.NIL_UUID));
    }

    public void tick() {
        if (this.tickCount > this.maxTicks) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        if (this.getCaster() == null) {
            this.remove(Entity.RemovalReason.KILLED);
            return;
        }
        float radius = 2.0f;
        if (!this.level().isClientSide && this.getCaster() != null) {
            if (this.tickCount == 1) {
                this.list = this.lockedOnEntity != null ? Utils.getLivingEntitiesInRadiusExcludingParty(this.getCaster(), (Entity)this.lockedOnEntity, radius, radius, radius) : Utils.getLivingEntitiesInRadiusExcludingParty(this.getCaster(), radius);
                this.list.remove((Object)this);
            }
            if (this.tickCount % 10 == 1) {
                if (!this.list.isEmpty()) {
                    int i = this.level().random.nextInt(this.list.size());
                    Entity e = (Entity)this.list.get(i);
                    if (e instanceof LivingEntity) {
                        if (!e.isAlive()) {
                            this.list.remove(e);
                        }
                        float dmg = this.getOwner() instanceof Player ? DamageCalculation.getMagicDamage((Player)this.getOwner()) * 0.05f : 2.0f;
                        ThunderBoltEntity shot = new ThunderBoltEntity(this.getCaster().level(), this.getCaster(), e.getX(), e.getY(), e.getZ(), dmg * this.dmgMult);
                        shot.setCaster(this.getCaster().getUUID());
                        this.level().addFreshEntity((Entity)shot);
                        LightningBolt lightningBoltEntity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
                        lightningBoltEntity.setVisualOnly(true);
                        lightningBoltEntity.moveTo(Vec3.atBottomCenterOf((Vec3i)e.blockPosition()));
                        lightningBoltEntity.setCause(this.getCaster() instanceof ServerPlayer ? (ServerPlayer)this.getCaster() : null);
                        this.level().addFreshEntity((Entity)lightningBoltEntity);
                    }
                } else {
                    int z;
                    int x;
                    if (this.lockedOnEntity != null) {
                        x = (int)this.lockedOnEntity.getX();
                        z = (int)this.lockedOnEntity.getZ();
                    } else {
                        x = (int)this.getCaster().getX();
                        z = (int)this.getCaster().getZ();
                    }
                    int y = this.getCaster().level().getHeight(Heightmap.Types.WORLD_SURFACE, x, z);
                    int posX = (int)((float)(x + this.getCaster().level().random.nextInt((int)(radius * 2.0f))) - radius / 2.0f) - 1;
                    int posZ = (int)((float)(z + this.getCaster().level().random.nextInt((int)(radius * 2.0f))) - radius / 2.0f) - 1;
                    int px = (int)((float)x - radius);
                    while ((float)px < (float)x + radius) {
                        int py = (int)((float)y - radius);
                        while ((float)py < (float)y + radius) {
                            int pz = (int)((float)z - radius);
                            while ((float)pz < (float)z + radius) {
                                BlockPos blockpos = new BlockPos(px, py, pz);
                                BlockState blockstate = this.level().getBlockState(blockpos);
                                if (blockstate.getBlock() == Blocks.LIGHTNING_ROD) {
                                    posX = px;
                                    posZ = pz;
                                }
                                ++pz;
                            }
                            ++py;
                        }
                        ++px;
                    }
                    float dmg = this.getOwner() instanceof Player ? DamageCalculation.getMagicDamage((Player)this.getOwner()) * 0.06f : 2.0f;
                    dmg = Math.max(0.1f, dmg);
                    ThunderBoltEntity shot = new ThunderBoltEntity(this.getCaster().level(), this.getCaster(), posX, this.getCaster().level().getHeight(Heightmap.Types.WORLD_SURFACE, posX, posZ), posZ, dmg * this.dmgMult);
                    shot.setCaster(this.getCaster().getUUID());
                    this.level().addFreshEntity((Entity)shot);
                    BlockPos pos = new BlockPos(posX, this.getCaster().level().getHeight(Heightmap.Types.WORLD_SURFACE, posX, posZ), posZ);
                    LightningBolt lightningBoltEntity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level());
                    lightningBoltEntity.moveTo(Vec3.atBottomCenterOf((Vec3i)pos));
                    lightningBoltEntity.setVisualOnly(true);
                    lightningBoltEntity.setCause(this.getCaster() instanceof ServerPlayer ? (ServerPlayer)this.getCaster() : null);
                    this.level().addFreshEntity((Entity)lightningBoltEntity);
                }
            }
        }
        super.tick();
    }

    protected void onHit(HitResult result) {
    }
}

