/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import online.kingdomkeys.kingdomkeys.damagesource.KKDamageTypes;
import online.kingdomkeys.kingdomkeys.data.WorldData;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.lib.Party;

public class WaterEntity
extends ThrowableProjectile {
    int maxTicks = 100;
    Player player;
    String caster;
    float dmgMult = 1.0f;
    double a = 0.0;
    private static final EntityDataAccessor<String> CASTER = SynchedEntityData.defineId(WaterEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public WaterEntity(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
        this.blocksBuilding = true;
    }

    public WaterEntity(Level world, Player player, float dmgMult) {
        super(ModEntities.TYPE_WATER.get(), (LivingEntity)player, world);
        this.player = player;
        this.dmgMult = dmgMult;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public void tick() {
        for (Player playerFromList : this.level().players()) {
            if (!playerFromList.getDisplayName().getString().equals(this.getCaster())) continue;
            this.player = playerFromList;
            break;
        }
        if (this.player == null) {
            return;
        }
        if (this.tickCount > this.maxTicks || this.player == null) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        if (this.tickCount <= 1) {
            this.setDeltaMovement(0.0, 0.0, 0.0);
        } else if (this.tickCount < 50) {
            List list;
            this.setPos(this.player.getX(), this.getY(), this.player.getZ());
            double radius = 1.0;
            double cx = this.getX();
            double cy = this.getY();
            double cz = this.getZ();
            this.a += 40.0;
            double x = cx + radius * Math.cos(Math.toRadians(this.a));
            double z = cz + radius * Math.sin(Math.toRadians(this.a));
            double x2 = cx + radius * Math.cos(Math.toRadians(-this.a));
            double z2 = cz + radius * Math.sin(Math.toRadians(-this.a));
            if (!this.level().isClientSide) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.DRIPPING_WATER, x, cy + 0.5 - this.a / 1080.0, z, 1, 0.0, 0.0, 0.0, 0.5);
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.DOLPHIN, x2, cy + 0.5 - this.a / 1080.0, z2, 1, 0.0, 0.0, 0.0, 0.5);
            }
            if (!(list = this.level().getEntities((Entity)this.player, this.player.getBoundingBox().inflate(radius), Entity::isAlive)).isEmpty() && list.get(0) != this) {
                float baseDmg = DamageCalculation.getMagicDamage((Player)this.getOwner()) * 0.3f;
                float dmg = this.getOwner() instanceof Player ? baseDmg : 2.0f;
                for (Entity entity : list) {
                    if (!(entity instanceof LivingEntity)) continue;
                    entity.hurt(KKDamageTypes.getElementalDamage(KKDamageTypes.WATER, (Entity)this, this.getOwner()), dmg * this.dmgMult);
                }
            }
        } else {
            this.shootFromRotation((Entity)this.player, this.player.getXRot(), this.player.getYRot(), 0.0f, 2.0f, 0.0f);
            this.player.level().playSound(null, this.player.blockPosition(), SoundEvents.PLAYER_SWIM, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.hurtMarked = true;
            float radius = 0.2f;
            for (int t = 1; t < 360; t += 30) {
                for (int s = 1; s < 360; s += 30) {
                    double x = this.getX() + (double)radius * Math.cos(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                    double z = this.getZ() + (double)radius * Math.sin(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                    double y = this.getY() + (double)radius * Math.cos(Math.toRadians(t));
                    if (this.level().isClientSide) continue;
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.DOLPHIN, x, y, z, 1, 0.0, 0.0, 0.0, 0.5);
                }
            }
        }
        super.tick();
    }

    protected void onHit(HitResult rtRes) {
        if (!this.level().isClientSide) {
            Entity entity;
            EntityHitResult ertResult = null;
            BlockHitResult brtResult = null;
            if (rtRes instanceof EntityHitResult) {
                ertResult = (EntityHitResult)rtRes;
            }
            if (rtRes instanceof BlockHitResult) {
                brtResult = (BlockHitResult)rtRes;
            }
            if (ertResult != null && ertResult.getEntity() != null && (entity = ertResult.getEntity()) instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity;
                if (target.isOnFire()) {
                    target.clearFire();
                } else if (target != this.getOwner()) {
                    Party p = null;
                    if (this.getOwner() != null) {
                        p = WorldData.get(this.getOwner().getServer()).getPartyFromMember(this.getOwner().getUUID());
                    }
                    if (p == null || p.getMember(target.getUUID()) == null || p.getFriendlyFire()) {
                        float dmg = this.getOwner() instanceof Player ? DamageCalculation.getMagicDamage((Player)this.getOwner()) * 0.3f : 2.0f;
                        target.hurt(KKDamageTypes.getElementalDamage(KKDamageTypes.WATER, (Entity)this, this.getOwner()), dmg * this.dmgMult);
                        this.remove(Entity.RemovalReason.KILLED);
                    }
                }
            } else {
                this.remove(Entity.RemovalReason.KILLED);
            }
            if (brtResult != null) {
                BlockPos blockpos = brtResult.getBlockPos();
                BlockState blockstate = this.level().getBlockState(blockpos);
                if (blockstate.getBlock() == Blocks.FIRE) {
                    this.level().setBlockAndUpdate(blockpos, Blocks.AIR.defaultBlockState());
                }
                if (blockstate.hasProperty((Property)BlockStateProperties.LIT)) {
                    this.level().setBlock(blockpos, (BlockState)blockstate.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false)), 11);
                }
                if (blockstate.getBlock() == Blocks.SPONGE) {
                    this.level().setBlockAndUpdate(blockpos, Blocks.WET_SPONGE.defaultBlockState());
                }
            }
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putString("caster", this.getCaster());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.setCaster(compound.getString("caster"));
    }

    public String getCaster() {
        return this.caster;
    }

    public void setCaster(String name) {
        this.entityData.set(CASTER, (Object)name);
        this.caster = name;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (key.equals(CASTER)) {
            this.caster = this.getCasterDataManager();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        pBuilder.define(CASTER, (Object)"");
    }

    public String getCasterDataManager() {
        return (String)this.entityData.get(CASTER);
    }
}

