/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityMobGriefingEvent;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.damagesource.KKDamageTypes;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;

public abstract class BaseBombEntity
extends BaseKHEntity {
    private static final EntityDataAccessor<Integer> TICKS = SynchedEntityData.defineId(BaseBombEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    boolean hasExploded = false;

    protected BaseBombEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.setTicks(100);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract ResourceLocation getTexture();

    public abstract float getExplosionStength();

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createLivingAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new BombGoal(this, this));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(TICKS, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("ticks", ((Integer)this.entityData.get(TICKS)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.entityData.set(TICKS, (Object)compound.getInt("ticks"));
    }

    public int getTicks() {
        return (Integer)this.getEntityData().get(TICKS);
    }

    public void setTicks(int ticks) {
        this.entityData.set(TICKS, (Object)ticks);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!this.level().isClientSide && ModConfigs.bombExplodeWithfire && (this.isOnFire() || source.is(KKDamageTypes.FIRE))) {
            this.explode();
        }
        return super.hurt(source, amount);
    }

    public void tick() {
        super.tick();
    }

    public void explode() {
        if (!this.hasExploded) {
            this.hasExploded = true;
            Level.ExplosionInteraction explosion$mode = ((EntityMobGriefingEvent)NeoForge.EVENT_BUS.post((Event)new EntityMobGriefingEvent(this.level(), (Entity)this))).canGrief() ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), this.getExplosionStength(), false, explosion$mode);
            for (LivingEntity enemy : EntityHelper.getEntitiesNear((Entity)this, this.getExplosionStength() + 1.0f)) {
                this.doHurtTarget((Entity)enemy);
            }
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    public EntityHelper.MobType getKHMobType() {
        return EntityHelper.MobType.HEARTLESS_EMBLEM;
    }

    class BombGoal
    extends Goal {
        private final BaseBombEntity bomb;

        public BombGoal(BaseBombEntity this$0, BaseBombEntity bomb) {
            this.bomb = bomb;
        }

        public boolean canUse() {
            return this.bomb.getTarget() != null && this.bomb.distanceToSqr((Entity)this.bomb.getTarget()) < 64.0 && this.bomb.getHealth() < this.bomb.getMaxHealth();
        }

        public boolean canContinueToUse() {
            if (this.canUse()) {
                this.bomb.setState(1);
                this.bomb.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.8);
                this.bomb.setTicks(this.bomb.getTicks() - 2);
                if (this.bomb.getTicks() <= 0) {
                    this.bomb.explode();
                }
            }
            return false;
        }
    }
}

