/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.data.GlobalData;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.mob.IKHMob;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;

public class BaseKHEntity
extends Monster
implements IKHMob {
    public static final EntityDataAccessor<Integer> ANIMATION = SynchedEntityData.defineId(BaseKHEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> STATE = SynchedEntityData.defineId(BaseKHEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public BaseKHEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
    }

    public void setState(int i) {
        this.getEntityData().set(STATE, (Object)i);
    }

    public int getState() {
        return (Integer)this.getEntityData().get(STATE);
    }

    public void setAnimation(int i) {
        this.getEntityData().set(ANIMATION, (Object)i);
    }

    public int getAnimation() {
        return (Integer)this.getEntityData().get(ANIMATION);
    }

    @Override
    public int getDefense() {
        return 0;
    }

    @Override
    public EntityHelper.MobType getKHMobType() {
        return EntityHelper.MobType.NPC;
    }

    protected int getBaseExperienceReward() {
        GlobalData mobData;
        if (this.getKHMobType() != EntityHelper.MobType.NPC && (mobData = GlobalData.get((LivingEntity)this)) != null && mobData.getLevel() > 0) {
            return (int)((float)super.getBaseExperienceReward() * ((float)mobData.getLevel() / 10.0f));
        }
        return super.getBaseExperienceReward();
    }

    public boolean skipAttackInteraction(Entity pEntity) {
        if (this.getKHMobType() != EntityHelper.MobType.NPC && pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (ItemStack.isSameItem((ItemStack)player.getMainHandItem(), (ItemStack)ItemStack.EMPTY)) {
                return true;
            }
            if (player.getMainHandItem().getItem() instanceof KeybladeItem || player.getMainHandItem().getItem() instanceof IOrgWeapon) {
                return false;
            }
            if (player.getMainHandItem().getItem() == ModItems.dreamSword.get() || player.getMainHandItem().getItem() == ModItems.dreamSword.get() || player.getMainHandItem().getItem() == ModItems.dreamShield.get()) {
                return false;
            }
            if (player.getMainHandItem().getItem() == ModItems.struggleSword.get() || player.getMainHandItem().getItem() == ModItems.struggleWand.get() || player.getMainHandItem().getItem() == ModItems.struggleHammer.get() || player.getMainHandItem().getItem() == ModItems.woodenStick.get()) {
                return true;
            }
            return ModConfigs.needKeybladeForHeartless;
        }
        return super.skipAttackInteraction(pEntity);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(STATE, (Object)0);
        pBuilder.define(ANIMATION, (Object)0);
    }
}

