/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import java.util.Random;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;

public class DarkballEntity
extends BaseKHEntity {
    private SpecialAttack currentAttack;
    private SpecialAttack previousAttack;

    public DarkballEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.xpReward = 8;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(0, (Goal)new DarkCloudGoal(this, this));
        this.goalSelector.addGoal(1, (Goal)new ChargeGoal(this, this));
        this.goalSelector.addGoal(1, (Goal)new BerserkGoal(this, this));
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createLivingAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, 0.22).add(Attributes.MAX_HEALTH, 70.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    public int getMaxSpawnClusterSize() {
        return 4;
    }

    @Override
    public EntityHelper.MobType getKHMobType() {
        return EntityHelper.MobType.HEARTLESS_PUREBLOOD;
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected void customServerAiStep() {
        this.setInvulnerable(false);
        super.customServerAiStep();
    }

    public void setCurrentAttackState(SpecialAttack state) {
        this.currentAttack = state;
    }

    public SpecialAttack getCurrentAttackState() {
        return this.currentAttack;
    }

    public void setPreviousAttackState(SpecialAttack state) {
        this.previousAttack = state;
    }

    public SpecialAttack getPreviousAttackState() {
        return this.previousAttack;
    }

    class DarkCloudGoal
    extends Goal {
        private final DarkballEntity theEntity;
        private boolean canUseAttack = true;
        private int attackTimer = 50;
        private int whileAttackTimer;
        private double[] pivotPosToMove;

        public DarkCloudGoal(DarkballEntity this$0, DarkballEntity e) {
            this.theEntity = e;
        }

        public boolean canUse() {
            if (this.theEntity.getTarget() != null && this.theEntity.getCurrentAttackState() == null) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        this.attackTimer -= 2;
                        return false;
                    }
                    return this.prevAttackCalc();
                }
                return this.prevAttackCalc();
            }
            return false;
        }

        public boolean prevAttackCalc() {
            if (this.theEntity.getPreviousAttackState() == SpecialAttack.DARKCLOUD) {
                return this.theEntity.random.nextFloat() <= 0.3f;
            }
            return true;
        }

        public boolean canContinueToUse() {
            boolean flag = this.canUseAttack;
            if (!flag) {
                this.theEntity.setPreviousAttackState(this.theEntity.getCurrentAttackState());
                this.theEntity.setCurrentAttackState(null);
                this.theEntity.setState(0);
                for (Entity entity : EntityHelper.getEntitiesNear((Entity)this.theEntity, 1.4)) {
                    this.theEntity.doHurtTarget(entity);
                }
            }
            return flag;
        }

        public void start() {
            this.canUseAttack = true;
            this.attackTimer = 50;
            this.whileAttackTimer = 0;
            this.theEntity.setCurrentAttackState(SpecialAttack.DARKCLOUD);
            this.theEntity.setState(0);
        }

        public void tick() {
            if (this.theEntity.getTarget() != null && this.canUseAttack) {
                this.whileAttackTimer += 2;
                this.theEntity.setState(3);
                LivingEntity target = this.theEntity.getTarget();
                for (int i = 0; i < 20; ++i) {
                    double d = (double)new Random().nextInt(5) + 1.0 + 5.0 - 5.0;
                    double offsetY = (double)new Random().nextInt(5) + 1.0 + 5.0 - 5.0;
                    double offsetZ = (double)new Random().nextInt(5) + 1.0 + 5.0 - 5.0;
                    this.theEntity.getNavigation().moveTo((double)target.blockPosition().getX(), (double)target.blockPosition().getY(), (double)target.blockPosition().getZ(), 1.5);
                }
                for (Entity entity : EntityHelper.getEntitiesNear((Entity)this.theEntity, 1.0)) {
                    if (entity != target) continue;
                    this.canUseAttack = false;
                    break;
                }
                if (this.whileAttackTimer > 80) {
                    this.canUseAttack = false;
                }
            }
        }
    }

    class ChargeGoal
    extends Goal {
        private final DarkballEntity theEntity;
        private boolean canUseAttack = true;
        private int attackTimer = 50;
        private int whileAttackTimer;
        private double[] posToCharge;
        private float initialHealth;

        public ChargeGoal(DarkballEntity this$0, DarkballEntity e) {
            this.theEntity = e;
        }

        public boolean canUse() {
            if (this.theEntity.getTarget() != null && this.theEntity.getCurrentAttackState() == null && this.theEntity.distanceToSqr((Entity)this.theEntity.getTarget()) > 4.0) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        this.attackTimer -= 2;
                        return false;
                    }
                    return this.prevAttackCalc();
                }
                return this.prevAttackCalc();
            }
            return false;
        }

        public boolean prevAttackCalc() {
            if (this.theEntity.getPreviousAttackState() == SpecialAttack.CHARGE) {
                return this.theEntity.random.nextFloat() <= 0.1f;
            }
            return true;
        }

        public boolean canContinueToUse() {
            boolean flag = this.canUseAttack;
            if (!flag) {
                this.theEntity.setPreviousAttackState(this.theEntity.getCurrentAttackState());
                this.theEntity.setCurrentAttackState(null);
                this.theEntity.setState(0);
            }
            return flag;
        }

        public void start() {
            this.canUseAttack = true;
            this.attackTimer = 50;
            this.whileAttackTimer = 0;
            this.theEntity.setCurrentAttackState(SpecialAttack.CHARGE);
            this.theEntity.setState(0);
            LivingEntity target = this.theEntity.getTarget();
            this.initialHealth = this.theEntity.getHealth();
            if (target != null) {
                this.posToCharge = new double[]{target.getX(), target.getY(), target.getZ()};
            }
        }

        public void tick() {
            if (this.theEntity.getTarget() != null && this.canUseAttack) {
                this.whileAttackTimer += 2;
                this.theEntity.setState(1);
                this.theEntity.getNavigation().moveTo(this.posToCharge[0], this.posToCharge[1], this.posToCharge[2], 3.0);
                if (this.whileAttackTimer > 100) {
                    this.canUseAttack = false;
                }
                if (this.theEntity.blockPosition().getX() == (int)this.posToCharge[0] && this.theEntity.blockPosition().getY() == (int)this.posToCharge[1] && this.theEntity.blockPosition().getZ() == (int)this.posToCharge[2]) {
                    this.canUseAttack = false;
                }
                if (this.theEntity.distanceToSqr((Entity)this.theEntity.getTarget()) < 3.0) {
                    this.canUseAttack = false;
                }
                if (this.initialHealth > this.theEntity.getHealth()) {
                    this.canUseAttack = false;
                }
            }
        }
    }

    class BerserkGoal
    extends Goal {
        private final DarkballEntity theEntity;
        private boolean canUseAttack = true;
        private int attackTimer = 70;
        private int whileAttackTimer;
        private double[] pivotPosToBerserk;

        public BerserkGoal(DarkballEntity this$0, DarkballEntity e) {
            this.theEntity = e;
        }

        public boolean canUse() {
            if (this.theEntity.getTarget() != null && this.theEntity.getCurrentAttackState() == null && this.theEntity.distanceToSqr((Entity)this.theEntity.getTarget()) < 15.0) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        this.attackTimer -= 2;
                        return false;
                    }
                    return this.prevAttackCalc();
                }
                return this.prevAttackCalc();
            }
            return false;
        }

        public boolean prevAttackCalc() {
            if (this.theEntity.getPreviousAttackState() == SpecialAttack.BERSERK) {
                return this.theEntity.random.nextFloat() <= 0.5f;
            }
            return true;
        }

        public boolean canContinueToUse() {
            boolean flag = this.canUseAttack;
            if (!flag) {
                this.theEntity.setPreviousAttackState(this.theEntity.getCurrentAttackState());
                this.theEntity.setCurrentAttackState(null);
                this.theEntity.setState(0);
            }
            return flag;
        }

        public void start() {
            this.canUseAttack = true;
            this.attackTimer = 70;
            this.whileAttackTimer = 0;
            this.theEntity.setCurrentAttackState(SpecialAttack.BERSERK);
            this.theEntity.setState(0);
            this.pivotPosToBerserk = new double[]{this.theEntity.blockPosition().getX(), this.theEntity.blockPosition().getY(), this.theEntity.blockPosition().getZ()};
        }

        public void tick() {
            if (this.theEntity.getTarget() != null && this.canUseAttack) {
                this.whileAttackTimer += 2;
                this.theEntity.setState(2);
                for (int i = 0; i < 20; ++i) {
                    double offsetX = (double)new Random().nextInt(5) + 1.0 + 5.0 - 5.0;
                    double offsetY = (double)new Random().nextInt(5) + 1.0 + 5.0 - 5.0;
                    double offsetZ = (double)new Random().nextInt(5) + 1.0 + 5.0 - 5.0;
                    LivingEntity target = this.theEntity.getTarget();
                    this.theEntity.getNavigation().moveTo(this.pivotPosToBerserk[0] + offsetX, this.pivotPosToBerserk[1] + offsetY, this.pivotPosToBerserk[2] + offsetZ, 5.0);
                }
                if (this.whileAttackTimer > 40) {
                    this.canUseAttack = false;
                }
            }
        }
    }

    public static enum SpecialAttack {
        CHARGE,
        BERSERK,
        DARKCLOUD;

    }
}

