/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.SeedBulletEntity;

public class DirePlantEntity
extends BaseKHEntity {
    public DirePlantEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.xpReward = 6;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new SeedGoal(this));
        this.goalSelector.addGoal(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createLivingAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.MAX_HEALTH, 30.0).add(Attributes.KNOCKBACK_RESISTANCE, 1000.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    public int getMaxSpawnClusterSize() {
        return 4;
    }

    @Override
    public EntityHelper.MobType getKHMobType() {
        return EntityHelper.MobType.HEARTLESS_EMBLEM;
    }

    class SeedGoal
    extends TargetGoal {
        private boolean canUseAttack;
        private int attackTimer;
        private final BaseKHEntity mob;

        public SeedGoal(DirePlantEntity e) {
            super((Mob)e, true);
            this.canUseAttack = true;
            this.attackTimer = 30;
            this.mob = e;
        }

        public boolean canUse() {
            if (this.mob.getTarget() != null) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        this.attackTimer -= 2;
                        return false;
                    }
                    return true;
                }
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.canUseAttack;
        }

        public void start() {
            this.canUseAttack = true;
            this.attackTimer = 30;
            this.mob.setState(0);
        }

        public void tick() {
            if (this.mob.getTarget() != null && this.canUseAttack) {
                this.mob.setState(1);
                LivingEntity target = this.mob.getTarget();
                this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
                double d1 = this.mob.getTarget().getX() - this.mob.getX();
                double d2 = this.mob.getTarget().getY() - this.mob.getY();
                double d3 = this.mob.getTarget().getZ() - this.mob.getZ();
                int num = DirePlantEntity.this.level().random.nextInt(100) + 1;
                if (num < 30) {
                    SeedBulletEntity seed = new SeedBulletEntity((LivingEntity)this.mob, this.mob.level());
                    seed.setPos(seed.getX(), this.mob.getY() + (double)(this.mob.getBbHeight() / 2.0f) + 0.3, seed.getZ());
                    seed.shoot(d1, d2, d3, 1.2f, 0.0f);
                    DirePlantEntity.this.level().addFreshEntity((Entity)seed);
                } else if (num < 60) {
                    SeedBulletEntity seed = new SeedBulletEntity((LivingEntity)this.mob, this.mob.level());
                    seed.shoot(d1, d2 + 1.0, d3, 1.0f, 0.0f);
                    seed.setPos(seed.getX(), this.mob.getY() + (double)(this.mob.getBbHeight() / 2.0f) + 0.3, seed.getZ());
                    this.mob.level().addFreshEntity((Entity)seed);
                    seed = new SeedBulletEntity((LivingEntity)this.mob, this.mob.level());
                    seed.shoot(d1, d2 + 2.0, d3, 1.0f, 0.0f);
                    seed.setPos(seed.getX(), this.mob.getY() + (double)(this.mob.getBbHeight() / 2.0f) + 0.3, seed.getZ());
                    this.mob.level().addFreshEntity((Entity)seed);
                    seed = new SeedBulletEntity((LivingEntity)this.mob, this.mob.level());
                    seed.shoot(d1, d2, d3, 1.0f, 0.0f);
                    seed.setPos(seed.getX(), this.mob.getY() + (double)(this.mob.getBbHeight() / 2.0f) + 0.3, seed.getZ());
                    this.mob.level().addFreshEntity((Entity)seed);
                } else {
                    SeedBulletEntity seed = new SeedBulletEntity((LivingEntity)this.mob, this.mob.level());
                    seed.shoot(d1, d2, d3, 1.2f, 0.0f);
                    seed.setPos(seed.getX(), this.mob.getY() + (double)(this.mob.getBbHeight() / 2.0f) + 0.3, seed.getZ());
                    this.mob.level().addFreshEntity((Entity)seed);
                    seed = new SeedBulletEntity((LivingEntity)this.mob, this.mob.level());
                    seed.shoot(d1, d2, d3, 0.7f, 0.0f);
                    seed.setPos(seed.getX(), this.mob.getY() + (double)(this.mob.getBbHeight() / 2.0f) + 0.3, seed.getZ());
                    this.mob.level().addFreshEntity((Entity)seed);
                    seed = new SeedBulletEntity((LivingEntity)this.mob, this.mob.level());
                    seed.shoot(d1, d2, d3, 0.5f, 0.0f);
                    seed.setPos(seed.getX(), this.mob.getY() + (double)(this.mob.getBbHeight() / 2.0f) + 0.3, seed.getZ());
                    this.mob.level().addFreshEntity((Entity)seed);
                }
                this.canUseAttack = false;
            }
        }
    }
}

