/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.damagesource.MagicDamageSource;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseElementalMusicalHeartlessEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.IKHMob;

public class GreenRequiemEntity
extends BaseElementalMusicalHeartlessEntity {
    public GreenRequiemEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.xpReward = 4;
    }

    @Override
    protected Goal goalToUse() {
        return new GreenRequiemGoal(this);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return BaseElementalMusicalHeartlessEntity.registerAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 1.0);
    }

    @Override
    public BaseElementalMusicalHeartlessEntity.Element getElementToUse() {
        return BaseElementalMusicalHeartlessEntity.Element.CURE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"kingdomkeys", (String)"textures/entity/mob/green_requiem.png");
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!this.level().isClientSide() && source instanceof MagicDamageSource) {
            return false;
        }
        return super.hurt(source, amount);
    }

    class GreenRequiemGoal
    extends TargetGoal {
        private boolean canUseAttack;
        private int attackTimer;
        private int whileAttackTimer;
        private float initialHealth;
        private final BaseKHEntity mob;

        public GreenRequiemGoal(GreenRequiemEntity e) {
            super((Mob)e, true);
            this.canUseAttack = true;
            this.attackTimer = 5;
            this.mob = e;
        }

        public boolean canUse() {
            if (this.mob.getTarget() != null) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        this.attackTimer -= 2;
                        return false;
                    }
                    return true;
                }
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            boolean flag = this.canUseAttack;
            return flag;
        }

        public void start() {
            this.canUseAttack = true;
            this.attackTimer = 25 + GreenRequiemEntity.this.level().random.nextInt(5);
            this.mob.setState(0);
            this.mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.2);
            this.whileAttackTimer = 0;
            this.initialHealth = this.mob.getHealth();
        }

        public void tick() {
            if (this.mob.getTarget() != null && this.canUseAttack) {
                this.whileAttackTimer += 2;
                LivingEntity target = this.mob.getTarget();
                if (this.mob.getState() == 0) {
                    this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
                    if ((double)GreenRequiemEntity.this.level().random.nextInt(100) + GreenRequiemEntity.this.level().random.nextDouble() <= 20.0) {
                        this.mob.setState(1);
                        ((ServerLevel)GreenRequiemEntity.this.level()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER.getType(), this.mob.getX(), this.mob.getY() + (double)this.mob.getEyeHeight(), this.mob.getZ(), 1, 0.0, 1.0, 0.0, 1.0);
                        this.mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
                        if (!EntityHelper.getEntitiesNear((Entity)this.mob, 10.0).isEmpty()) {
                            for (LivingEntity heartless : EntityHelper.getEntitiesNear((Entity)this.mob, 10.0)) {
                                if (!(heartless instanceof IKHMob) || ((IKHMob)heartless).getKHMobType() == EntityHelper.MobType.NPC || !(heartless.getHealth() < heartless.getMaxHealth())) continue;
                                heartless.heal((float)this.mob.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue() / 4.0f);
                                ((ServerLevel)GreenRequiemEntity.this.level()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER.getType(), heartless.getX(), heartless.getY() + (double)heartless.getEyeHeight(), heartless.getZ() - 0.5, 1, 0.0, 1.0, 0.0, 1.0);
                                ((ServerLevel)GreenRequiemEntity.this.level()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER.getType(), heartless.getX(), heartless.getY() + (double)heartless.getEyeHeight(), heartless.getZ() + 0.5, 1, 0.0, 1.0, 0.0, 1.0);
                                ((ServerLevel)GreenRequiemEntity.this.level()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER.getType(), heartless.getX(), heartless.getY() + (double)heartless.getEyeHeight(), heartless.getZ(), 1, 0.0, 1.0, 0.0, 1.0);
                                ((ServerLevel)GreenRequiemEntity.this.level()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER.getType(), heartless.getX() + 0.5, heartless.getY() + (double)heartless.getEyeHeight(), heartless.getZ(), 1, 0.0, 1.0, 0.0, 1.0);
                                ((ServerLevel)GreenRequiemEntity.this.level()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER.getType(), heartless.getX() - 0.5, heartless.getY() + (double)heartless.getEyeHeight(), heartless.getZ(), 1, 0.0, 1.0, 0.0, 1.0);
                            }
                        }
                    }
                }
                if (this.mob.getState() == 1 && this.whileAttackTimer > 50) {
                    this.canUseAttack = false;
                    this.mob.setState(0);
                    this.mob.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.2);
                }
            }
        }
    }
}

