/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.GlobalData;
import online.kingdomkeys.kingdomkeys.effects.ModMobEffects;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseKHEntity;

public class LargeBodyEntity
extends BaseKHEntity {
    private SpecialAttack currentAttack;
    private SpecialAttack previousAttack;
    private int timeForNextAI = 80;
    private boolean isAngry = false;
    protected final int DAMAGE_HIT = 0;
    protected final int DAMAGE_CHARGE = 6;
    protected final int DAMAGE_MOWDOWN = 5;
    protected final int DAMAGE_SHOCKWAVE = 4;

    public LargeBodyEntity(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
        this.xpReward = 10;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(0, (Goal)new ChargeGoal(this));
        this.goalSelector.addGoal(1, (Goal)new MowdownGoal(this));
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createLivingAttributes().add(Attributes.MAX_HEALTH, 80.0).add(Attributes.MOVEMENT_SPEED, 0.15).add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    @Override
    public EntityHelper.MobType getKHMobType() {
        return EntityHelper.MobType.HEARTLESS_EMBLEM;
    }

    public void tick() {
        super.tick();
        int rotation = Mth.floor((double)((double)(this.getYHeadRot() * 4.0f / 360.0f) + 0.5)) & 3;
        if (this.getHealth() < this.getMaxHealth() / 3.0f) {
            this.isAngry = true;
        }
        if (this.getCurrentAttackState() == SpecialAttack.MOWDOWN) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
        }
        if (this.getPreviousAttackState() != SpecialAttack.WAIT && this.timeForNextAI > 0) {
            this.setCurrentAttackState(SpecialAttack.WAIT);
            this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.0);
            this.setTarget(null);
            this.setState(10);
            this.timeForNextAI -= 2;
        } else if (this.timeForNextAI <= 0) {
            this.setPreviousAttackState(SpecialAttack.WAIT);
            this.setCurrentAttackState(null);
            if (this.isAngry) {
                this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.2);
            } else {
                this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.15);
            }
            this.setState(0);
            this.setTarget(null);
            this.timeForNextAI = 80;
        }
        if (this.isAngry) {
            // empty if block
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (GlobalData.get((LivingEntity)this) == null) {
            KingdomKeys.LOGGER.warn("For some reason " + String.valueOf(this) + " doesn't have globaldata");
        }
        if (source.getEntity() instanceof LivingEntity && GlobalData.get((LivingEntity)this) != null) {
            Entity attacker = source.getDirectEntity();
            double d1 = attacker.getX() - this.getX();
            double d0 = attacker.getZ() - this.getZ();
            float attackYaw = (float)Math.toDegrees(Mth.atan2((double)d0, (double)d1));
            float diff = Mth.wrapDegrees((float)(attackYaw - this.getYRot()));
            if (diff > 30.0f && diff < 150.0f && !this.hasEffect(ModMobEffects.GRAVITY) && attacker instanceof LivingEntity) {
                ((LivingEntity)attacker).knockback((double)0.8f, -d1, -d0);
                this.level().playSound(null, this.blockPosition(), (SoundEvent)ModSounds.invincible_hit.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                attacker.setDeltaMovement(attacker.getDeltaMovement().x, 0.5, attacker.getDeltaMovement().z);
                return false;
            }
        }
        return super.hurt(source, amount);
    }

    public Level getWorld() {
        return this.level();
    }

    public void setCurrentAttackState(SpecialAttack state) {
        this.currentAttack = state;
    }

    public SpecialAttack getCurrentAttackState() {
        return this.currentAttack;
    }

    public void setPreviousAttackState(SpecialAttack state) {
        this.previousAttack = state;
    }

    public SpecialAttack getPreviousAttackState() {
        return this.previousAttack;
    }

    public float getScale() {
        return 1.5f;
    }

    public int getMaxSpawnClusterSize() {
        return 4;
    }

    class ChargeGoal
    extends Goal {
        private final LargeBodyEntity theEntity;
        private boolean canUseAttack = true;
        private final int ATTACK_MAX_TIMER = 70;
        private int attackTimer = 70;
        private int whileAttackTimer;
        private double[] posToCharge;
        private float initialHealth;

        public ChargeGoal(LargeBodyEntity e) {
            this.theEntity = e;
        }

        public boolean canUse() {
            if (this.theEntity.getTarget() != null && this.theEntity.getCurrentAttackState() == null && this.theEntity.distanceToSqr((Entity)this.theEntity.getTarget()) > 4.0) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        this.attackTimer -= 2;
                        return false;
                    }
                    return this.prevAttackCalc();
                }
                return this.prevAttackCalc();
            }
            return false;
        }

        public boolean prevAttackCalc() {
            if (this.theEntity.getPreviousAttackState() == SpecialAttack.CHARGE) {
                return this.theEntity.random.nextFloat() <= 0.2f;
            }
            return true;
        }

        public boolean canContinueToUse() {
            boolean flag = this.canUseAttack;
            if (!flag) {
                this.theEntity.setPreviousAttackState(this.theEntity.getCurrentAttackState());
                this.theEntity.setCurrentAttackState(null);
                LargeBodyEntity.this.setState(0);
            }
            return flag;
        }

        public void start() {
            this.canUseAttack = true;
            this.attackTimer = 70;
            this.whileAttackTimer = 0;
            this.theEntity.setCurrentAttackState(SpecialAttack.CHARGE);
            LargeBodyEntity.this.setState(1);
            LivingEntity target = this.theEntity.getTarget();
            this.initialHealth = this.theEntity.getHealth();
            if (target != null) {
                this.posToCharge = new double[]{target.getX(), target.getY(), target.getZ()};
            }
        }

        public void tick() {
            if (this.theEntity.getTarget() != null && this.canUseAttack) {
                this.whileAttackTimer += 2;
                LivingEntity target = this.theEntity.getTarget();
                this.theEntity.getNavigation().moveTo(this.posToCharge[0], this.posToCharge[1], this.posToCharge[2], this.theEntity.isAngry ? 2.3 : 2.0);
                if (this.whileAttackTimer > 70) {
                    this.canUseAttack = false;
                }
                if (this.theEntity.blockPosition().getX() == (int)this.posToCharge[0] && this.theEntity.blockPosition().getY() == (int)this.posToCharge[1] && this.theEntity.blockPosition().getZ() == (int)this.posToCharge[2] || this.theEntity.blockPosition().getX() == (int)this.posToCharge[0] + 1 && this.theEntity.blockPosition().getY() == (int)this.posToCharge[1] && this.theEntity.blockPosition().getZ() == (int)this.posToCharge[2] + 1 || this.theEntity.blockPosition().getX() == (int)this.posToCharge[0] - 1 && this.theEntity.blockPosition().getY() == (int)this.posToCharge[1] && this.theEntity.blockPosition().getZ() == (int)this.posToCharge[2] - 1) {
                    this.canUseAttack = false;
                }
                if (this.theEntity.distanceToSqr((Entity)this.theEntity.getTarget()) < 2.0) {
                    this.canUseAttack = false;
                }
                if (this.initialHealth > this.theEntity.getHealth()) {
                    this.canUseAttack = false;
                }
            }
        }
    }

    class MowdownGoal
    extends Goal {
        private final LargeBodyEntity theEntity;
        private boolean canUseAttack = true;
        private final int ATTACK_MAX_TIMER = 50;
        private int attackTimer = 50;
        private int whileAttackTimer;
        private double[] posToCharge;
        private float initialHealth;

        public MowdownGoal(LargeBodyEntity e) {
            this.theEntity = e;
        }

        public boolean canUse() {
            if (this.theEntity.getTarget() != null && this.theEntity.getCurrentAttackState() == null && this.theEntity.distanceTo((Entity)this.theEntity.getTarget()) < 5.0f) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        this.attackTimer -= 2;
                        return false;
                    }
                    return this.prevAttackCalc();
                }
                return this.prevAttackCalc();
            }
            return false;
        }

        public boolean prevAttackCalc() {
            if (this.theEntity.getPreviousAttackState() == SpecialAttack.MOWDOWN) {
                return this.theEntity.random.nextFloat() <= 0.5f;
            }
            return true;
        }

        public boolean canContinueToUse() {
            boolean flag = this.canUseAttack;
            if (!flag) {
                this.theEntity.setPreviousAttackState(this.theEntity.getCurrentAttackState());
                this.theEntity.setCurrentAttackState(null);
                LargeBodyEntity.this.setState(0);
            }
            return flag;
        }

        public void start() {
            this.canUseAttack = true;
            this.attackTimer = 50;
            this.whileAttackTimer = 0;
            this.theEntity.setCurrentAttackState(SpecialAttack.MOWDOWN);
            LargeBodyEntity.this.setState(2);
            this.initialHealth = this.theEntity.getHealth();
        }

        public void tick() {
            if (this.theEntity.getTarget() != null && this.canUseAttack) {
                this.whileAttackTimer += 2;
                for (Entity entity : EntityHelper.getEntitiesNear((Entity)this.theEntity, 0.2)) {
                    this.theEntity.doHurtTarget(entity);
                }
                if (this.whileAttackTimer > 40) {
                    this.canUseAttack = false;
                }
                if (this.initialHealth > this.theEntity.getHealth()) {
                    this.canUseAttack = false;
                }
            }
        }
    }

    public static enum SpecialAttack {
        WAIT,
        CHARGE,
        MOWDOWN,
        SHOCKWAVE;

    }
}

