/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.data.PlayerData;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCOpenSynthesisGui;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopList;
import online.kingdomkeys.kingdomkeys.synthesis.shop.ShopListRegistry;
import online.kingdomkeys.kingdomkeys.synthesis.shop.names.NamesListRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MoogleEntity
extends PathfinderMob
implements IEntityWithComplexSpawn {
    String inv = Utils.randomWithRange(0, 100) >= 98 ? "kingdomkeys:special" : "kingdomkeys:default";
    String name;
    Player interacting;
    private boolean fakeMoogle = false;

    public MoogleEntity(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
        this.setRandomName();
        if (this.name == null) {
            this.name = "";
        }
    }

    public void setRandomName() {
        List<String> names;
        ShopList shop = ShopListRegistry.getInstance().getValue(ResourceLocation.parse((String)this.inv));
        if (shop != null && (names = NamesListRegistry.getInstance().getValue(shop.getNames())) != null && !names.isEmpty()) {
            this.name = names.get(Utils.randomWithRange(0, names.size() - 1));
        }
    }

    @Nullable
    public Component getCustomName() {
        if (this.name != null && !this.name.isEmpty()) {
            return Component.translatable((String)this.name);
        }
        return super.getCustomName();
    }

    public boolean hasCustomName() {
        if (this.name != null && !this.name.isEmpty()) {
            return true;
        }
        return super.hasCustomName();
    }

    protected void registerGoals() {
        this.normalGoals();
    }

    public void normalGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 0.5));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createLivingAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.28);
    }

    public Player getInteracting() {
        return this.interacting;
    }

    public void stopInteracting() {
        this.interacting = null;
        this.normalGoals();
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeUtf(this.inv);
        buffer.writeUtf(this.name);
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        this.inv = additionalData.readUtf();
        this.name = additionalData.readUtf();
    }

    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand hand) {
        if (!player.level().isClientSide) {
            if (!player.isCrouching()) {
                ItemStack itemstack = player.getItemInHand(hand);
                if (!ItemStack.isSameItem((ItemStack)itemstack, (ItemStack)ItemStack.EMPTY) && itemstack.getItem() == ModItems.winnerStick.get()) {
                    PlayerData playerData = PlayerData.get(player);
                    int reward = 500;
                    playerData.setMunny(playerData.getMunny() + reward);
                    itemstack.shrink(1);
                    player.sendSystemMessage((Component)Component.translatable((String)(String.valueOf(ChatFormatting.YELLOW) + "You have been rewarded with " + reward + " munny!")));
                    return InteractionResult.FAIL;
                }
                PacketHandler.sendTo(new SCOpenSynthesisGui(PlayerData.get(player).serializeNBT((HolderLookup.Provider)player.level().registryAccess()), this.inv, this.name, this.getId()), (ServerPlayer)player);
                this.interacting = player;
                this.goalSelector.removeAllGoals(Objects::nonNull);
                this.goalSelector.addGoal(0, (Goal)new LookAtInteractingPlayerGoal(this));
                return InteractionResult.SUCCESS;
            }
            return super.interactAt(player, vec, hand);
        }
        ItemStack itemstack = player.getItemInHand(hand);
        if (!ItemStack.isSameItem((ItemStack)itemstack, (ItemStack)ItemStack.EMPTY) && itemstack.getItem() == ModItems.winnerStick.get()) {
            return InteractionResult.SUCCESS;
        }
        return super.interactAt(player, vec, hand);
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public int getMaxSpawnClusterSize() {
        return 1;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.kupoliving.get();
    }

    public int getAmbientSoundInterval() {
        return 600;
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return true;
    }

    public boolean isFakeMoogle() {
        return this.fakeMoogle;
    }

    public void setFakeMoogle(boolean fake) {
        this.fakeMoogle = fake;
    }

    public void tick() {
        if (this.interacting != null && this.distanceTo((Entity)this.interacting) > 10.0f) {
            this.interacting = null;
        }
        super.tick();
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putString("inv", this.inv);
        pCompound.putString("name", this.name);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.inv = pCompound.getString("inv");
        this.name = pCompound.getString("name");
        if (this.name.isEmpty()) {
            this.setRandomName();
        }
    }

    public static class LookAtInteractingPlayerGoal
    extends LookAtPlayerGoal {
        public LookAtInteractingPlayerGoal(MoogleEntity moogle) {
            super((Mob)moogle, Player.class, 8.0f);
        }

        public boolean canUse() {
            if (((MoogleEntity)this.mob).interacting != null) {
                this.lookAt = ((MoogleEntity)this.mob).interacting;
                return true;
            }
            return false;
        }
    }
}

